/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.eap.cloudsdk.httpclient;

import com.tplink.eap.cloudsdk.DeviceInfo;
import com.tplink.eap.cloudsdk.IDeviceMgmt;
import com.tplink.eap.cloudsdk.httpclient.a;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppHttpClient
extends a {
    private static final Logger d = LoggerFactory.getLogger(AppHttpClient.class);
    private static final String e = "UTF-8";
    private static final String f = "n-wap-omada.i.tplinkcloud.com";
    private static final String g = "eap/v1";
    public static final String KEY_METHOD = "method";
    public static final String KEY_PARAMS = "params";
    public static final String KEY_APP_TYPE = "appType";
    public static final String KEY_TERMINAL_UUID = "terminalUUID";
    public static final String KEY_TOKEN = "token";
    public static final String METHOD_VAL_LOGIN = "login";
    public static final String URL_LEAF_PATH_APPLY_SOFTWARE_DEVICE_ID = "applySoftwareDeviceId";
    public static final String KEY_CLOUD_USER_NAME = "cloudUserName";
    public static final String KEY_CLOUD_PASSWORD = "cloudPassword";
    public static final String KEY_DEVICE_NAME = "deviceName";
    public static final String KEY_ALIAS = "alias";
    public static final String KEY_DEVICE_MAC = "deviceMac";
    public static final String KEY_HW_ID = "hwId";
    public static final String KEY_DEVICE_MODEL = "deviceModel";
    public static final String KEY_DEVICE_HW_VER = "deviceHwVer";
    public static final String KEY_DEVICE_TYPE = "deviceType";
    public static final String KEY_FW_ID = "fwId";
    public static final String KEY_OEM_ID = "oemId";
    public static final String KEY_FW_VER = "fwVer";
    public static final String KEY_TCSP_VER = "tcspVer";
    public static final String KEY_CONTROLLER_VERSION = "controllerVersion";
    public static final String KEY_ERROR_CODE = "error_code";
    public static final String KEY_RESULT = "result";
    public static final String KEY_VALIDATE_HOST_V2 = "validateHostV2";
    private static final int h = -10000;
    private String i = "n-wap-omada.i.tplinkcloud.com";
    private String j = "eap/v1";
    IDeviceMgmt a;

    public AppHttpClient(IDeviceMgmt deviceMgmt) {
        this.a = deviceMgmt;
    }

    public JSONObject applySoftwareDeviceId(Map<String, String> urlParams, String cloudUserName, String cloudPassword) throws IOException {
        String string;
        Object object;
        if (urlParams == null || cloudUserName == null || cloudPassword == null) {
            d.error("Invalid parameter.");
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Content-Type", "application/json;charset=UTF-8");
        DeviceInfo deviceInfo = this.a.getDeviceInfo();
        JSONObject jSONObject = this.a(deviceInfo, urlParams, cloudUserName, cloudPassword);
        if (jSONObject != null && jSONObject.has(KEY_ERROR_CODE) && jSONObject.getInt(KEY_ERROR_CODE) == 0) {
            if (jSONObject.has(KEY_RESULT) && (object = jSONObject.getJSONObject(KEY_RESULT)).has(KEY_TOKEN)) {
                string = object.getString(KEY_TOKEN);
                urlParams.put(KEY_TOKEN, string);
            }
        } else {
            d.warn("Failed to login automatically when applys software device id.");
            return jSONObject;
        }
        jSONObject = null;
        object = this.a(URL_LEAF_PATH_APPLY_SOFTWARE_DEVICE_ID, urlParams);
        string = this.a(deviceInfo, cloudUserName, cloudPassword);
        if (string == null) {
            return null;
        }
        String string2 = this.sendPostRequest((String)object, hashMap, string.toString(), 35, 30);
        if (string2 != null) {
            jSONObject = new JSONObject(string2);
        }
        if (jSONObject == null) {
            jSONObject = new JSONObject();
            jSONObject.put(KEY_ERROR_CODE, -10000);
        }
        return jSONObject;
    }

    private String a(String string, Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("https://");
        stringBuilder.append(this.i);
        if (!StringUtils.isBlank((CharSequence)string)) {
            stringBuilder.append("/");
            stringBuilder.append(this.j);
            stringBuilder.append("/");
            stringBuilder.append(string);
        }
        d.debug("AppHttpClient http URL is {}", (Object)stringBuilder);
        stringBuilder.append("?");
        Iterator<String> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string2;
            String string3 = iterator.next();
            stringBuilder.append(string3);
            stringBuilder.append("=");
            try {
                string2 = URLEncoder.encode(map.get(string3), e);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                d.warn(unsupportedEncodingException.toString(), (Throwable)unsupportedEncodingException);
                string2 = map.get(string3);
            }
            stringBuilder.append(string2);
            if (!iterator.hasNext()) continue;
            stringBuilder.append("&");
        }
        return stringBuilder.toString();
    }

    private JSONObject a(DeviceInfo deviceInfo, String string, String string2) {
        JSONObject jSONObject = new JSONObject();
        if (deviceInfo == null || !deviceInfo.validateLegalityWithoutDeviceId()) {
            d.error("Device information from deviceMgmt is illegal.");
            return jSONObject;
        }
        jSONObject.put(KEY_CLOUD_USER_NAME, (Object)string);
        jSONObject.put(KEY_CLOUD_PASSWORD, (Object)string2);
        jSONObject.put(KEY_DEVICE_NAME, (Object)deviceInfo.getDeviceName());
        jSONObject.put(KEY_ALIAS, (Object)deviceInfo.getAlias());
        jSONObject.put(KEY_DEVICE_MAC, (Object)deviceInfo.getDeviceMac());
        jSONObject.put(KEY_HW_ID, (Object)deviceInfo.getHwId());
        jSONObject.put(KEY_DEVICE_MODEL, (Object)deviceInfo.getDeviceModel());
        jSONObject.put(KEY_DEVICE_HW_VER, (Object)deviceInfo.getDeviceHwVer());
        jSONObject.put(KEY_DEVICE_TYPE, (Object)deviceInfo.getDeviceType());
        jSONObject.put(KEY_FW_ID, (Object)deviceInfo.getFwId());
        jSONObject.put(KEY_OEM_ID, (Object)deviceInfo.getOemId());
        jSONObject.put(KEY_FW_VER, (Object)deviceInfo.getFwVer());
        jSONObject.put(KEY_TCSP_VER, (Object)"1.2");
        jSONObject.put(KEY_CONTROLLER_VERSION, (Object)deviceInfo.getControllerVersion());
        return jSONObject;
    }

    private JSONObject a(DeviceInfo deviceInfo, Map<String, String> map, String string, String string2) throws IOException {
        if (map == null || string == null || string2 == null) {
            d.error("Invalid parameter.");
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Content-Type", "application/json;charset=UTF-8");
        JSONObject jSONObject = null;
        String string3 = this.a(null, map);
        JSONObject jSONObject2 = new JSONObject();
        JSONObject jSONObject3 = new JSONObject();
        jSONObject3.put(KEY_CLOUD_USER_NAME, (Object)string);
        jSONObject3.put(KEY_CLOUD_PASSWORD, (Object)string2);
        jSONObject3.put(KEY_APP_TYPE, (Object)deviceInfo.getDeviceType());
        jSONObject3.put(KEY_TERMINAL_UUID, (Object)map.get("termID"));
        jSONObject2.put(KEY_METHOD, (Object)METHOD_VAL_LOGIN);
        jSONObject2.put(KEY_PARAMS, (Object)jSONObject3);
        String string4 = this.sendPostRequest(string3, hashMap, jSONObject2.toString(), 35, 30);
        if (string4 != null) {
            jSONObject = new JSONObject(string4);
        }
        return jSONObject;
    }
}

