/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.eap.cloudsdk.httpclient;

import com.tplink.eap.cloudsdk.DeviceInfo;
import com.tplink.eap.cloudsdk.IDeviceMgmt;
import com.tplink.eap.cloudsdk.deviceToken.DeviceTokenDTO;
import com.tplink.eap.cloudsdk.f;
import com.tplink.eap.cloudsdk.httpclient.a;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiHttpClient
extends a {
    private static final Logger d = LoggerFactory.getLogger(ApiHttpClient.class);
    private static final String e = "UTF-8";
    private static final String f = "n-device-omada-api.i.tplinkcloud.com";
    private static final String g = "eap/v1";
    public static final String KEY_ERROR_CODE = "error_code";
    public static final String KEY_RESULT = "result";
    public static final String KEY_SERVER_URL_V2 = "serverUrlV2";
    public static final String KEY_DEVICE_TOKEN = "deviceToken";
    public static final String KEY_EXPIRES_IN = "expiresIn";
    public static final String LEAF_PATH_VALIDATE = "validate";
    public static final String LEAF_PATH_VALIDATE_NO_DEVICE_ID = "validateForSoftware";
    public static final String KEY_DEVICE_ID = "deviceId";
    public static final String KEY_OMADAC_ID = "omadacId";
    public static final String KEY_CLOUD_USER_NAME = "cloudUserName";
    public static final String KEY_DEVICE_NAME = "deviceName";
    public static final String KEY_ALIAS = "alias";
    public static final String KEY_DEVICE_MAC = "deviceMac";
    public static final String KEY_HW_ID = "hwId";
    public static final String KEY_DEVICE_MODEL = "deviceModel";
    public static final String KEY_DEVICE_HW_VER = "deviceHwVer";
    public static final String KEY_DEVICE_TYPE = "deviceType";
    public static final String KEY_FW_ID = "fwId";
    public static final String KEY_OEM_ID = "oemId";
    public static final String KEY_FW_VER = "fwVer";
    public static final String KEY_TCSP_VER = "tcspVer";
    public static final String KEY_CONTROLLER_VERSION = "controllerVersion";
    public static final int ERROR_CODE_VAL_GENERIC_ERROR = -10000;
    public static final int ERROR_CODE_VAL_REQUEST_TIMEOUT = -20002;
    public static final int ERROR_CODE_VAL_DEVICE_TOKEN_EXPIRATE = -25001;
    public static final int ERROR_CODE_VAL_DEVICE_TOKEN_INVALID = -25002;
    private String h = "n-device-omada-api.i.tplinkcloud.com";
    private String i;
    private final String j = "eap/v1";
    IDeviceMgmt a;
    private final AtomicReference<DeviceTokenDTO> k = new AtomicReference<DeviceTokenDTO>(new DeviceTokenDTO(null, 0L));

    public ApiHttpClient(IDeviceMgmt deviceMgmt) {
        this.a = deviceMgmt;
    }

    public ApiHttpClient(String validateHost, IDeviceMgmt deviceMgmt) {
        this.h = validateHost;
        this.a = deviceMgmt;
    }

    public synchronized void setValidateHost(String validateHost) {
        this.setDeviceTokenDTO(new DeviceTokenDTO(null, 0L));
        this.h = validateHost;
    }

    public synchronized void restoreValidateHost() {
        this.setDeviceTokenDTO(new DeviceTokenDTO(null, 0L));
        this.h = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject sendPostRequest(String leafPath, JSONObject request) throws IOException {
        boolean bl = false;
        DeviceTokenDTO deviceTokenDTO = this.getDeviceTokenDTO();
        if (leafPath == null || request == null) {
            d.error("Invalid parameter.");
            return null;
        }
        boolean bl2 = leafPath.equals(LEAF_PATH_VALIDATE) || leafPath.equals(LEAF_PATH_VALIDATE_NO_DEVICE_ID);
        JSONObject jSONObject = null;
        ApiHttpClient apiHttpClient = this;
        synchronized (apiHttpClient) {
            if (!bl2) {
                if (deviceTokenDTO != null) {
                    if (deviceTokenDTO.getExpiresIn() <= System.currentTimeMillis() / 1000L) {
                        bl = true;
                    }
                } else {
                    bl = true;
                }
            } else {
                bl = true;
            }
            if (bl) {
                d.debug("Ready to refresh deviceToken.");
                JSONObject jSONObject2 = this.a();
                if (jSONObject2.length() == 0 || !jSONObject2.has(KEY_DEVICE_ID)) {
                    jSONObject2.remove(KEY_DEVICE_ID);
                    jSONObject2.remove(KEY_CLOUD_USER_NAME);
                    jSONObject = this.sendPostRequest(LEAF_PATH_VALIDATE_NO_DEVICE_ID, null, jSONObject2);
                } else {
                    jSONObject2.remove(KEY_OMADAC_ID);
                    jSONObject = this.sendPostRequest(LEAF_PATH_VALIDATE, null, jSONObject2);
                }
                if (jSONObject.has(KEY_ERROR_CODE) && jSONObject.getInt(KEY_ERROR_CODE) == 0) {
                    JSONObject jSONObject3;
                    if (jSONObject.has(KEY_RESULT) && (jSONObject3 = jSONObject.getJSONObject(KEY_RESULT)).has(KEY_DEVICE_TOKEN)) {
                        d.debug("device token validated. {}", (Object)jSONObject3);
                        String string = jSONObject3.getString(KEY_DEVICE_TOKEN);
                        long l2 = jSONObject3.getLong(KEY_EXPIRES_IN);
                        deviceTokenDTO = new DeviceTokenDTO(string, System.currentTimeMillis() / 1000L + l2 / 2L);
                        this.setDeviceTokenDTO(deviceTokenDTO);
                    }
                } else {
                    d.warn("Failed to validate device.");
                    return jSONObject;
                }
            }
        }
        if (!bl2 && (jSONObject = this.sendPostRequest(leafPath, deviceTokenDTO.getDeviceToken(), request)).has(KEY_ERROR_CODE) && (jSONObject.getInt(KEY_ERROR_CODE) == -25001 || jSONObject.getInt(KEY_ERROR_CODE) == -25002)) {
            d.warn("Device token is expired or invalid, so clear device token.");
            apiHttpClient = this;
            synchronized (apiHttpClient) {
                this.setDeviceTokenDTO(new DeviceTokenDTO(null, 0L));
                this.h = f;
            }
        }
        if (d.isDebugEnabled()) {
            d.debug("validateHost is {}, regionServerUrl is {}.", (Object)this.h, (Object)this.i);
            if (com.tplink.eap.cloudsdk.f.a()) {
                d.debug("deviceToken is {}, getDeviceTokenDTO().getExpiresIn() is {}.", (Object)deviceTokenDTO.getDeviceToken(), (Object)deviceTokenDTO.getExpiresIn());
            }
        }
        return jSONObject;
    }

    public JSONObject sendPostRequest(String leafPath, String deviceToken, JSONObject request) throws IOException {
        return this.sendPostRequest(leafPath, deviceToken, request, 35, 30);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject sendPostRequest(String leafPath, String deviceToken, JSONObject request, int connTimeout, int readTimeout) throws IOException {
        boolean bl;
        if (request == null || connTimeout <= 0 || readTimeout <= 0) {
            d.error("Invalid parameter.");
            return null;
        }
        boolean bl2 = bl = leafPath.equals(LEAF_PATH_VALIDATE) || leafPath.equals(LEAF_PATH_VALIDATE_NO_DEVICE_ID);
        if (!bl && this.i == null) {
            d.warn("regionHost(provides common web service) is null, please make sures that 'validate' request gets successful response before.");
            return null;
        }
        String string = this.a(leafPath, deviceToken);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Content-Type", "application/json;charset=UTF-8");
        JSONObject jSONObject = this.a(string, hashMap, request, connTimeout, readTimeout);
        if (bl && jSONObject != null) {
            ApiHttpClient apiHttpClient = this;
            synchronized (apiHttpClient) {
                if (jSONObject.has(KEY_ERROR_CODE) && jSONObject.getInt(KEY_ERROR_CODE) == 0 && jSONObject.has(KEY_RESULT)) {
                    JSONObject jSONObject2 = jSONObject.getJSONObject(KEY_RESULT);
                    String string2 = jSONObject2.getString(KEY_SERVER_URL_V2);
                    d.debug("sendPostRequest localHost is {}", (Object)string2);
                    this.i = string2 != null ? string2 : this.i;
                }
            }
        }
        return jSONObject;
    }

    private JSONObject a(String string, Map<String, String> map, JSONObject jSONObject, int n2, int n3) throws IOException {
        JSONObject jSONObject2 = null;
        if (null == string || null == jSONObject) {
            d.error("Invalid parameter.");
            return null;
        }
        String string2 = this.sendPostRequest(string, map, jSONObject.toString(), n2, n3);
        if (string2 != null) {
            jSONObject2 = new JSONObject(string2);
        }
        if (jSONObject2 == null) {
            jSONObject2 = new JSONObject();
            jSONObject2.put(KEY_ERROR_CODE, -10000);
        }
        return jSONObject2;
    }

    private JSONObject a() {
        JSONObject jSONObject = new JSONObject();
        DeviceInfo deviceInfo = this.a.getDeviceInfo();
        if (deviceInfo == null) {
            d.error("Device information from deviceMgmt is illegal.");
            return jSONObject;
        }
        if (deviceInfo.getDeviceId() != null && !deviceInfo.validateLegality()) {
            d.error("Device information from deviceMgmt is illegal.");
            return jSONObject;
        }
        if (deviceInfo.getDeviceId() == null && !deviceInfo.validateLegalityWithoutDeviceIdAndCloudUsername()) {
            d.error("Device information from deviceMgmt is illegal.");
            return jSONObject;
        }
        jSONObject.put(KEY_DEVICE_ID, (Object)deviceInfo.getDeviceId());
        jSONObject.put(KEY_OMADAC_ID, (Object)deviceInfo.getOmadacId());
        jSONObject.put(KEY_CLOUD_USER_NAME, (Object)deviceInfo.getCloudUserName());
        jSONObject.put(KEY_DEVICE_NAME, (Object)deviceInfo.getDeviceName());
        jSONObject.put(KEY_ALIAS, (Object)deviceInfo.getAlias());
        jSONObject.put(KEY_DEVICE_MAC, (Object)deviceInfo.getDeviceMac());
        jSONObject.put(KEY_HW_ID, (Object)deviceInfo.getHwId());
        jSONObject.put(KEY_DEVICE_MODEL, (Object)deviceInfo.getDeviceModel());
        jSONObject.put(KEY_DEVICE_HW_VER, (Object)deviceInfo.getDeviceHwVer());
        jSONObject.put(KEY_DEVICE_TYPE, (Object)deviceInfo.getDeviceType());
        jSONObject.put(KEY_FW_ID, (Object)deviceInfo.getFwId());
        jSONObject.put(KEY_OEM_ID, (Object)deviceInfo.getOemId());
        jSONObject.put(KEY_FW_VER, (Object)deviceInfo.getFwVer());
        jSONObject.put(KEY_TCSP_VER, (Object)"1.2");
        jSONObject.put(KEY_CONTROLLER_VERSION, (Object)deviceInfo.getControllerVersion());
        return jSONObject;
    }

    private String a(String string, String string2) {
        boolean bl = string.equals(LEAF_PATH_VALIDATE) || string.equals(LEAF_PATH_VALIDATE_NO_DEVICE_ID);
        DeviceInfo deviceInfo = this.a.getDeviceInfo();
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = bl ? this.h : this.i;
        d.debug("buildURLWithDevInfo, urlSegment http validateHost is  {}, regionServerUrl {}", (Object)this.h, (Object)this.i);
        if (string3.startsWith("https:")) {
            stringBuilder.append(string3);
        } else {
            stringBuilder.append("https://");
            stringBuilder.append(string3);
        }
        stringBuilder.append("/");
        stringBuilder.append(g);
        stringBuilder.append("/");
        stringBuilder.append(string);
        stringBuilder.append("?");
        d.debug("buildURLWithDevInfo, ApiHttpClient http URL is  {}", (Object)stringBuilder);
        if (string2 != null) {
            this.a(stringBuilder, KEY_DEVICE_TOKEN, string2, false);
        } else {
            this.a(stringBuilder, KEY_DEVICE_TOKEN, "default", false);
        }
        if (deviceInfo.getDeviceId() != null) {
            this.a(stringBuilder, KEY_DEVICE_ID, deviceInfo.getDeviceId(), false);
        } else {
            this.a(stringBuilder, KEY_DEVICE_ID, "default", false);
        }
        if (deviceInfo.getCloudUserName() != null) {
            this.a(stringBuilder, "user", deviceInfo.getCloudUserName(), false);
        } else {
            this.a(stringBuilder, "user", "default", false);
        }
        this.a(stringBuilder, "model", deviceInfo.getDeviceModel(), false);
        this.a(stringBuilder, "hwVer", deviceInfo.getDeviceHwVer(), false);
        this.a(stringBuilder, KEY_HW_ID, deviceInfo.getHwId(), false);
        this.a(stringBuilder, KEY_OEM_ID, deviceInfo.getOemId(), false);
        this.a(stringBuilder, KEY_FW_VER, deviceInfo.getFwVer(), false);
        this.a(stringBuilder, KEY_DEVICE_TYPE, deviceInfo.getDeviceType(), true);
        return stringBuilder.toString();
    }

    private void a(StringBuilder stringBuilder, String string, String string2, boolean bl) {
        stringBuilder.append(string);
        stringBuilder.append("=");
        try {
            stringBuilder.append(URLEncoder.encode(string2, e));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            d.warn(unsupportedEncodingException.toString(), (Throwable)unsupportedEncodingException);
            stringBuilder.append(string2);
        }
        if (!bl) {
            stringBuilder.append("&");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject sendPostRequestWithPathPrefix(String leafPath, String pathPrefixs, JSONObject request) throws IOException {
        boolean bl = false;
        DeviceTokenDTO deviceTokenDTO = this.getDeviceTokenDTO();
        if (leafPath == null || request == null || pathPrefixs == null) {
            d.error("Invalid parameter.");
            return null;
        }
        boolean bl2 = leafPath.equals(LEAF_PATH_VALIDATE) || leafPath.equals(LEAF_PATH_VALIDATE_NO_DEVICE_ID);
        JSONObject jSONObject = null;
        ApiHttpClient apiHttpClient = this;
        synchronized (apiHttpClient) {
            if (!bl2) {
                if (deviceTokenDTO != null) {
                    if (deviceTokenDTO.getExpiresIn() <= System.currentTimeMillis() / 1000L) {
                        bl = true;
                    }
                } else {
                    bl = true;
                }
            } else {
                bl = true;
            }
            if (bl) {
                d.debug("<deviceToken> Ready to refresh deviceToken.");
                JSONObject jSONObject2 = this.a();
                if (jSONObject2.length() == 0 || !jSONObject2.has(KEY_DEVICE_ID)) {
                    jSONObject2.remove(KEY_DEVICE_ID);
                    jSONObject2.remove(KEY_CLOUD_USER_NAME);
                    jSONObject = this.a(LEAF_PATH_VALIDATE_NO_DEVICE_ID, pathPrefixs, null, jSONObject2);
                } else {
                    jSONObject2.remove(KEY_OMADAC_ID);
                    jSONObject = this.a(LEAF_PATH_VALIDATE, pathPrefixs, null, jSONObject2);
                }
                if (jSONObject.has(KEY_ERROR_CODE) && jSONObject.getInt(KEY_ERROR_CODE) == 0) {
                    JSONObject jSONObject3;
                    if (jSONObject.has(KEY_RESULT) && (jSONObject3 = jSONObject.getJSONObject(KEY_RESULT)).has(KEY_DEVICE_TOKEN)) {
                        String string = jSONObject3.getString(KEY_DEVICE_TOKEN);
                        long l2 = jSONObject3.getLong(KEY_EXPIRES_IN);
                        long l3 = System.currentTimeMillis() / 1000L;
                        deviceTokenDTO = new DeviceTokenDTO(string, l3 + l2 / 2L);
                        this.setDeviceTokenDTO(deviceTokenDTO);
                    }
                } else {
                    d.warn("Failed to validate device.");
                    return jSONObject;
                }
            }
        }
        if (!bl2 && (jSONObject = this.a(leafPath, pathPrefixs, deviceTokenDTO.getDeviceToken(), request)).has(KEY_ERROR_CODE) && (jSONObject.getInt(KEY_ERROR_CODE) == -25001 || jSONObject.getInt(KEY_ERROR_CODE) == -25002)) {
            d.warn("<deviceToken> Device token is expired or invalid, so clear device token.");
            apiHttpClient = this;
            synchronized (apiHttpClient) {
                this.setDeviceTokenDTO(new DeviceTokenDTO(null, 0L));
                this.h = f;
            }
        }
        if (d.isDebugEnabled()) {
            d.debug("validateHost is {}, regionServerUrl is {}.", (Object)this.h, (Object)this.i);
            if (com.tplink.eap.cloudsdk.f.a()) {
                d.debug("deviceToken is {}, getDeviceTokenDTO().getExpiresIn() is {}.", (Object)deviceTokenDTO.getDeviceToken(), (Object)deviceTokenDTO.getExpiresIn());
            }
        }
        return jSONObject;
    }

    private JSONObject a(String string, String string2, String string3, JSONObject jSONObject) throws IOException {
        return this.a(string, string2, string3, jSONObject, 35, 30);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject a(String string, String string2, String string3, JSONObject jSONObject, int n2, int n3) throws IOException {
        boolean bl;
        if (jSONObject == null || n2 <= 0 || n3 <= 0 || string2 == null) {
            d.error("Invalid parameter.");
            return null;
        }
        boolean bl2 = bl = string.equals(LEAF_PATH_VALIDATE) || string.equals(LEAF_PATH_VALIDATE_NO_DEVICE_ID);
        if (!bl && this.i == null) {
            d.warn("regionHost(provides common web service) is null, please make sures that 'validate' request gets successful response before.");
            return null;
        }
        String string4 = this.a(string, string2, string3);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Content-Type", "application/json;charset=UTF-8");
        JSONObject jSONObject2 = this.a(string4, hashMap, jSONObject, n2, n3);
        if (bl && jSONObject2 != null) {
            ApiHttpClient apiHttpClient = this;
            synchronized (apiHttpClient) {
                if (jSONObject2.has(KEY_ERROR_CODE) && jSONObject2.getInt(KEY_ERROR_CODE) == 0 && jSONObject2.has(KEY_RESULT)) {
                    JSONObject jSONObject3 = jSONObject2.getJSONObject(KEY_RESULT);
                    String string5 = jSONObject3.getString(KEY_SERVER_URL_V2);
                    this.i = string5 != null ? string5 : this.i;
                }
            }
        }
        return jSONObject2;
    }

    private String a(String string, String string2, String string3) {
        boolean bl = string.equals(LEAF_PATH_VALIDATE) || string.equals(LEAF_PATH_VALIDATE_NO_DEVICE_ID);
        DeviceInfo deviceInfo = this.a.getDeviceInfo();
        StringBuilder stringBuilder = new StringBuilder();
        String string4 = bl ? this.h : this.i;
        d.debug("buildURLWithDevInfo pathPrefixs, urlSegment http validateHost is  {}, regionServerUrl {}", (Object)this.h, (Object)this.i);
        if (string4.startsWith("https:")) {
            stringBuilder.append(string4);
        } else {
            stringBuilder.append("https://");
            stringBuilder.append(string4);
        }
        stringBuilder.append("/");
        stringBuilder.append(bl ? g : string2);
        stringBuilder.append("/");
        stringBuilder.append(string);
        stringBuilder.append("?");
        if (string3 != null) {
            this.a(stringBuilder, KEY_DEVICE_TOKEN, string3, false);
        } else {
            this.a(stringBuilder, KEY_DEVICE_TOKEN, "default", false);
        }
        if (deviceInfo.getDeviceId() != null) {
            this.a(stringBuilder, KEY_DEVICE_ID, deviceInfo.getDeviceId(), false);
        } else {
            this.a(stringBuilder, KEY_DEVICE_ID, "default", false);
        }
        if (deviceInfo.getCloudUserName() != null) {
            this.a(stringBuilder, "user", deviceInfo.getCloudUserName(), false);
        } else {
            this.a(stringBuilder, "user", "default", false);
        }
        this.a(stringBuilder, "model", deviceInfo.getDeviceModel(), false);
        this.a(stringBuilder, "hwVer", deviceInfo.getDeviceHwVer(), false);
        this.a(stringBuilder, KEY_HW_ID, deviceInfo.getHwId(), false);
        this.a(stringBuilder, KEY_OEM_ID, deviceInfo.getOemId(), false);
        this.a(stringBuilder, KEY_FW_VER, deviceInfo.getFwVer(), false);
        this.a(stringBuilder, KEY_DEVICE_TYPE, deviceInfo.getDeviceType(), true);
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceTokenDTO getDeviceTokenDTO() {
        ApiHttpClient apiHttpClient = this;
        synchronized (apiHttpClient) {
            if (this.a.needGetTokenFromontroller().booleanValue()) {
                DeviceTokenDTO deviceTokenDTO = this.a.getDeviceTokenFromController();
                if (Objects.isNull(deviceTokenDTO)) {
                    deviceTokenDTO = new DeviceTokenDTO(null, 0L);
                }
                d.debug("<deviceToken> getDeviceTokenDTO needGetTokenFromontroller deviceToken {} expiresIn {}", (Object)this.k.get().getDeviceToken(), (Object)this.k.get().getExpiresIn());
                return deviceTokenDTO;
            }
            if (Objects.isNull(this.k)) {
                this.k.set(new DeviceTokenDTO(null, 0L));
            }
            d.debug("<deviceToken> getDeviceTokenDTO deviceToken {} expiresIn {}", (Object)this.k.get().getDeviceToken(), (Object)this.k.get().getExpiresIn());
            return this.k.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeviceTokenDTO(DeviceTokenDTO deviceTokenDTO) {
        ApiHttpClient apiHttpClient = this;
        synchronized (apiHttpClient) {
            if (this.a.needGetTokenFromontroller().booleanValue()) {
                this.a.setDeviceTokenForController(deviceTokenDTO);
                d.debug("<deviceToken> setDeviceTokenDTO needGetTokenFromontroller deviceToken {} expiresIn {}", (Object)this.k.get().getDeviceToken(), (Object)this.k.get().getExpiresIn());
            } else {
                this.k.set(deviceTokenDTO);
                d.debug("<deviceToken> setDeviceTokenDTO deviceToken {} expiresIn {}", (Object)this.k.get().getDeviceToken(), (Object)this.k.get().getExpiresIn());
            }
        }
    }
}

