/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.eap.cloudsdk.client;

import com.tplink.eap.cloudsdk.DeviceInfo;
import com.tplink.eap.cloudsdk.client.CloudRequest;
import com.tplink.eap.cloudsdk.client.ConnectionStatus;
import com.tplink.eap.cloudsdk.client.ConnectionType;
import com.tplink.eap.cloudsdk.client.HelloCloudDelegate;
import com.tplink.eap.cloudsdk.client.IResponseDelegate;
import com.tplink.eap.cloudsdk.client.ReconnectionEvent;
import com.tplink.eap.cloudsdk.client.a;
import com.tplink.eap.cloudsdk.client.b;
import com.tplink.eap.cloudsdk.client.n;
import com.tplink.eap.cloudsdk.client.q;
import com.tplink.eap.cloudsdk.observable.ObservableDTO;
import com.tplink.eap.cloudsdk.observable.StatusChangedObservable;
import com.tplink.eap.cloudsdk.observable.StatusChangedReasonEnum;
import java.io.IOException;
import java.net.SocketException;
import java.util.Map;
import java.util.Observer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudClient {
    private static final Logger a = LoggerFactory.getLogger(CloudClient.class);
    private static final long b = 600000L;
    private static final long c = 30000L;
    private final HelloCloudDelegate d;
    private final boolean e;
    private AtomicReference<ConnectionType> f = new AtomicReference();
    private n g;
    private q h;
    private AtomicReference<Thread> i = new AtomicReference();
    private AtomicReference<b> j = new AtomicReference<b>(com.tplink.eap.cloudsdk.client.b.a);
    private int k = 35000;
    private int l = 500;
    private StatusChangedObservable m;

    public CloudClient(HelloCloudDelegate helloCloudDelegate, Map<String, CloudRequest> requestMap, boolean keepPersistentConnection) {
        this.d = helloCloudDelegate;
        this.e = keepPersistentConnection;
        this.g = new n(helloCloudDelegate);
        this.h = new q(helloCloudDelegate, requestMap);
    }

    public void onCloudClientStatusChange(Observer observer) {
        this.m = this.h.a();
        this.m.addObserver(observer);
    }

    public synchronized void start() {
        Thread thread = new Thread(new a(this));
        thread.setDaemon(true);
        thread.start();
        this.i.set(thread);
    }

    public synchronized void stop() {
        a.debug("Tries to stop CloudClient.");
        StatusChangedObservable statusChangedObservable = this.h.a();
        Thread thread = this.i.get();
        if (thread != null) {
            thread.interrupt();
            if (this.g != null) {
                this.g.b();
            }
            if (this.h != null) {
                if (ConnectionStatus.CONNECTED.equals((Object)this.h.b())) {
                    statusChangedObservable.changeStatus(new ObservableDTO(ConnectionStatus.DISCONNECTED_NORMAL, StatusChangedReasonEnum.CLOUD_ACTIVELY_DISCONNECTION));
                }
                this.h.f();
            }
            ExecutorService executorService = Executors.newFixedThreadPool(1);
            Future<?> future = executorService.submit(() -> {
                long l2 = 50L;
                long l3 = 0L;
                while (thread.isAlive() && l3 < 600000L) {
                    a.debug("'startupThread' is stopping.");
                    try {
                        this.wait(l2);
                        l3 += l2;
                    }
                    catch (InterruptedException interruptedException) {
                        a.warn(interruptedException.toString(), (Throwable)interruptedException);
                    }
                }
                if (thread.isAlive() && l3 >= 600000L) {
                    a.warn("'startupThread' isn't still stopped after monitoring {} milliseconds.", (Object)600000L);
                }
            });
            try {
                future.get(30000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                a.debug(interruptedException.toString(), (Throwable)interruptedException);
            }
            catch (ExecutionException executionException) {
                a.debug(executionException.toString(), (Throwable)executionException);
            }
            catch (TimeoutException timeoutException) {
                a.warn("'startupThread' isn't stopped after waiting {} milliseconds.", (Object)30000L);
                a.debug(timeoutException.toString(), (Throwable)timeoutException);
            }
        }
        a.info("CloudClient is stopped.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRequestAsync(JSONObject request, IResponseDelegate delegate, boolean reconnect) {
        if (reconnect && !this.h.b().equals((Object)ConnectionStatus.CONNECTED)) {
            try {
                this.a(this.k);
            }
            catch (InterruptedException interruptedException) {
                a.info(interruptedException.toString(), (Throwable)interruptedException);
                delegate.onResponse(this.c());
                return;
            }
        }
        q q2 = this.h;
        synchronized (q2) {
            try {
                if (this.h.b().equals((Object)ConnectionStatus.CONNECTED)) {
                    this.h.a(request, delegate);
                } else {
                    delegate.onResponse(this.c());
                }
            }
            catch (SocketException socketException) {
                a.info(socketException.toString(), (Throwable)socketException);
                if (this.f.get().equals((Object)ConnectionType.PERSISTENT_CONNECTION)) {
                    this.h.notifyAll();
                }
                delegate.onResponse(this.c());
            }
            catch (IOException iOException) {
                a.warn(iOException.toString(), (Throwable)iOException);
                delegate.onResponse(this.c());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject sendRequestSync(JSONObject request, boolean reconnect) {
        JSONObject jSONObject = null;
        if (reconnect && !this.h.b().equals((Object)ConnectionStatus.CONNECTED)) {
            try {
                this.a(this.k);
            }
            catch (InterruptedException interruptedException) {
                a.info(interruptedException.toString(), (Throwable)interruptedException);
                return this.c();
            }
        }
        q q2 = this.h;
        synchronized (q2) {
            try {
                if (this.h.b().equals((Object)ConnectionStatus.CONNECTED)) {
                    jSONObject = this.h.a(request);
                }
            }
            catch (SocketException socketException) {
                if (this.f.get().equals((Object)ConnectionType.PERSISTENT_CONNECTION)) {
                    this.h.notifyAll();
                }
                a.info(socketException.toString(), (Throwable)socketException);
            }
            catch (InterruptedException interruptedException) {
                a.info(interruptedException.toString(), (Throwable)interruptedException);
            }
            catch (IOException iOException) {
                a.warn(iOException.toString(), (Throwable)iOException);
            }
        }
        if (jSONObject == null) {
            jSONObject = this.c();
        }
        return jSONObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notifyEvent(ReconnectionEvent event) {
        boolean bl = false;
        ConnectionStatus connectionStatus = this.getConnectionStatus();
        a.debug("Received reconnectionEvent is {}.", (Object)event);
        if (event.equals((Object)ReconnectionEvent.NON_USER_REQUEST_TIMEOUT_THREE_TIMES) || event.equals((Object)ReconnectionEvent.WAN_IP_CHANGED) || event.equals((Object)ReconnectionEvent.LAN_IP_CHANGED)) {
            if (!connectionStatus.equals((Object)ConnectionStatus.DISCONNECTED_FORBIDDEN)) {
                bl = true;
                this.b();
            }
        } else if (event.equals((Object)ReconnectionEvent.USER_REQUEST_TIMEOUT_TWO_TIMES) || event.equals((Object)ReconnectionEvent.RECOVER_CONNECTION)) {
            bl = true;
            this.b();
        } else if (event.equals((Object)ReconnectionEvent.DEVICE_BINDED) || event.equals((Object)ReconnectionEvent.DEVICE_UNBOUND)) {
            bl = true;
            CloudClient cloudClient = this;
            synchronized (cloudClient) {
                this.stop();
                this.start();
            }
        } else {
            a.error("Unexpected reconnection event.");
        }
        return bl;
    }

    public ConnectionStatus getConnectionStatus() {
        ConnectionStatus connectionStatus = this.g.c();
        ConnectionStatus connectionStatus2 = this.h.b();
        if (connectionStatus2.equals((Object)ConnectionStatus.CONNECTED)) {
            return ConnectionStatus.CONNECTED;
        }
        if (connectionStatus.equals((Object)ConnectionStatus.CONNECTING) || connectionStatus2.equals((Object)ConnectionStatus.CONNECTING)) {
            return ConnectionStatus.CONNECTING;
        }
        if (connectionStatus.equals((Object)ConnectionStatus.DISCONNECTED_FORBIDDEN) || connectionStatus2.equals((Object)ConnectionStatus.DISCONNECTED_FORBIDDEN)) {
            return ConnectionStatus.DISCONNECTED_FORBIDDEN;
        }
        return ConnectionStatus.DISCONNECTED_NORMAL;
    }

    public ConnectionType getConnectionType() {
        return this.f.get();
    }

    public boolean isRunning() {
        if (this.i.get() == null) {
            return false;
        }
        return this.i.get().isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshConnection() {
        JSONObject jSONObject = this.h.h();
        a.info("send tp cloud heartbeat now result: {}", (Object)jSONObject);
        if (jSONObject == null || 0 != (Integer)jSONObject.get("error_code")) {
            CloudClient cloudClient = this;
            synchronized (cloudClient) {
                this.stop();
                this.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(int n2) throws InterruptedException {
        long l2;
        long l3 = System.currentTimeMillis() + (long)n2;
        if (this.j.get().equals((Object)com.tplink.eap.cloudsdk.client.b.a)) {
            n n3 = this.g;
            synchronized (n3) {
                a.trace("Tries to skip the phase of connecting SEF server.");
                this.g.a(true);
                this.g.notifyAll();
            }
        }
        q q2 = this.h;
        synchronized (q2) {
            ConnectionStatus connectionStatus = this.h.b();
            if (connectionStatus.equals((Object)ConnectionStatus.DISCONNECTED_FORBIDDEN) || connectionStatus.equals((Object)ConnectionStatus.DISCONNECTED_NORMAL)) {
                this.h.notifyAll();
            }
        }
        do {
            a.trace("Sleep...");
            Thread.sleep(this.l);
            l2 = System.currentTimeMillis();
        } while (this.h.b().equals((Object)ConnectionStatus.CONNECTING) && l2 <= l3);
        a.trace("svrClient.getConnStatus() is {}", (Object)this.h.b());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void b() {
        if (this.j.get().equals((Object)com.tplink.eap.cloudsdk.client.b.a)) {
            n n2 = this.g;
            synchronized (n2) {
                this.g.notifyAll();
            }
        }
        q q2 = this.h;
        synchronized (q2) {
            this.h.notifyAll();
        }
    }

    private JSONObject c() {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("error_code", -10000);
        return jSONObject;
    }

    private ConnectionType d() {
        if (this.e) {
            return ConnectionType.PERSISTENT_CONNECTION;
        }
        DeviceInfo deviceInfo = this.d.getDeviceInfoMgmt().getDeviceInfo();
        if (StringUtils.isBlank((CharSequence)deviceInfo.getCloudUserName())) {
            return ConnectionType.SHORT_CONNECTION;
        }
        return ConnectionType.PERSISTENT_CONNECTION;
    }

    static /* synthetic */ Logger a() {
        return a;
    }

    static /* synthetic */ AtomicReference a(CloudClient cloudClient) {
        return cloudClient.j;
    }

    static /* synthetic */ q b(CloudClient cloudClient) {
        return cloudClient.h;
    }

    static /* synthetic */ n c(CloudClient cloudClient) {
        return cloudClient.g;
    }

    static /* synthetic */ ConnectionType d(CloudClient cloudClient) {
        return cloudClient.d();
    }

    static /* synthetic */ AtomicReference e(CloudClient cloudClient) {
        return cloudClient.f;
    }

    static /* synthetic */ StatusChangedObservable f(CloudClient cloudClient) {
        return cloudClient.m;
    }
}

