/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.utils;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ArrayUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nonnull;

public final class StringUtil {
    public static String escExprSpecWord(String keyword) {
        if (keyword != null) {
            String[] fbsArr;
            for (String key : fbsArr = new String[]{"$", "(", ")", "*", "+", ".", "[", "]", "?", "^", "{", "}", "|"}) {
                if (!keyword.contains(key)) continue;
                keyword = keyword.replace(key, "\\" + key);
            }
        }
        return keyword;
    }

    public static boolean isNotBlank(Object obj) {
        return !StringUtil.isBlank(obj);
    }

    public static boolean isBlank(Object obj) {
        if (obj == null) {
            return true;
        }
        String str = obj.toString().trim();
        return "".equals(str) || "null".equalsIgnoreCase(str);
    }

    public static boolean hasBlank(Object obj) {
        return obj == null || obj.toString().contains(" ");
    }

    public static boolean isNotEmpty(CharSequence str) {
        return !StringUtil.isEmpty(str);
    }

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static String getExceptionAllInformation(Exception ex) {
        StackTraceElement[] trace;
        StringBuilder sOut = new StringBuilder();
        for (StackTraceElement s : trace = ex.getStackTrace()) {
            sOut.append("\tat ").append(s).append("\r\n");
        }
        return sOut.toString();
    }

    public static String getExceptionAllInformation(Throwable ex) {
        StringBuilder sOut = new StringBuilder();
        Throwable d = ex.getCause();
        sOut.append(d.getMessage());
        sOut.append("\r\n");
        StringWriter sw = new StringWriter();
        ex.printStackTrace(new PrintWriter((Writer)sw, true));
        sOut.append(sw.toString());
        return sOut.toString();
    }

    public static String getNewLine() {
        return System.getProperty("line.separator");
    }

    public static String uuid() {
        return UUID.randomUUID().toString();
    }

    public static String trim(Object obj) {
        if (obj == null) {
            return "";
        }
        return obj.toString().trim();
    }

    public static String[] splitToArray(String str, char separator) {
        List<String> result = StringUtil.split(str, separator);
        return result.toArray(new String[0]);
    }

    public static List<String> split(String str, char separator) {
        return StringUtil.split(str, separator, 0);
    }

    public static List<String> split(String str, char separator, int limit) {
        if (str == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(limit == 0 ? 16 : limit);
        if (limit == 1) {
            list.add(str);
            return list;
        }
        boolean isNotEnd = true;
        int strLen = str.length();
        StringBuilder sb = new StringBuilder(strLen);
        for (int i = 0; i < strLen; ++i) {
            char c = str.charAt(i);
            if (isNotEnd && c == separator) {
                list.add(sb.toString());
                sb.delete(0, sb.length());
                if (limit == 0 || list.size() != limit - 1) continue;
                isNotEnd = false;
                continue;
            }
            sb.append(c);
        }
        list.add(sb.toString());
        return list;
    }

    public static String[] splitToArray(String str, char separator, int limit) {
        List<String> result = StringUtil.split(str, separator, limit);
        return result.toArray(new String[0]);
    }

    public static String[] split(String str, String delimiter) {
        int i;
        if (str == null) {
            return null;
        }
        if (str.trim().length() == 0) {
            return new String[]{str};
        }
        int dellen = delimiter.length();
        int maxparts = str.length() / dellen + 2;
        int[] positions = new int[maxparts];
        int j = 0;
        int count = 0;
        positions[0] = -dellen;
        while ((i = str.indexOf(delimiter, j)) != -1) {
            positions[++count] = i;
            j = i + dellen;
        }
        positions[++count] = str.length();
        String[] result = new String[count];
        for (i = 0; i < count; ++i) {
            result[i] = str.substring(positions[i] + dellen, positions[i + 1]);
        }
        return result;
    }

    public static String[] split(String str, int len) {
        int partCount = str.length() / len;
        int lastPartCount = str.length() % len;
        int fixPart = 0;
        if (lastPartCount != 0) {
            fixPart = 1;
        }
        String[] strs = new String[partCount + fixPart];
        for (int i = 0; i < partCount + fixPart; ++i) {
            strs[i] = i == partCount + fixPart - 1 && lastPartCount != 0 ? str.substring(i * len, i * len + lastPartCount) : str.substring(i * len, i * len + len);
        }
        return strs;
    }

    public static int count(String content, String strForSearch) {
        if (StringUtil.hasEmpty(content, strForSearch) || strForSearch.length() > content.length()) {
            return 0;
        }
        int count = 0;
        int idx = 0;
        while ((idx = content.indexOf(strForSearch, idx)) > -1) {
            ++count;
            idx += strForSearch.length();
        }
        return count;
    }

    public static boolean hasEmpty(CharSequence ... strs) {
        if (ArrayUtil.isEmpty((Object[])strs)) {
            return true;
        }
        for (CharSequence str : strs) {
            if (!StringUtil.isEmpty(str)) continue;
            return true;
        }
        return false;
    }

    public static int count(String content, char charForSearch) {
        int count = 0;
        if (StringUtil.isEmpty(content)) {
            return 0;
        }
        int contentLength = content.length();
        for (int i = 0; i < contentLength; ++i) {
            if (charForSearch != content.charAt(i)) continue;
            ++count;
        }
        return count;
    }

    public static String padPre(String str, int minLength, char padChar) {
        if (str.length() >= minLength) {
            return str;
        }
        StringBuilder sb = new StringBuilder(minLength);
        for (int i = str.length(); i < minLength; ++i) {
            sb.append(padChar);
        }
        sb.append(str);
        return sb.toString();
    }

    public static String padEnd(String str, int minLength, char padChar) {
        if (str.length() >= minLength) {
            return str;
        }
        StringBuilder sb = new StringBuilder(minLength);
        sb.append(str);
        for (int i = str.length(); i < minLength; ++i) {
            sb.append(padChar);
        }
        return sb.toString();
    }

    public static String compress(String str) throws IOException {
        if (null == str || str.length() <= 0) {
            return str;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(out);
        gzip.write(str.getBytes());
        gzip.close();
        return out.toString("ISO-8859-1");
    }

    public static String unCompress(String str) throws IOException {
        int n;
        if (null == str || str.length() <= 0) {
            return str;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream in = new ByteArrayInputStream(str.getBytes(StandardCharsets.ISO_8859_1));
        GZIPInputStream gzip = new GZIPInputStream(in);
        byte[] buffer = new byte[256];
        while ((n = gzip.read(buffer)) >= 0) {
            out.write(buffer, 0, n);
        }
        return out.toString("GBK");
    }

    public static List<String> getSubStrBetween(String soap, String frontStr, String backStr) {
        if (StringUtil.isEmpty(soap)) {
            return CollUtil.newArrayList((Object[])new String[0]);
        }
        ArrayList<String> list = new ArrayList<String>();
        Pattern pattern = Pattern.compile(frontStr + "(.*?)" + backStr);
        Matcher m = pattern.matcher(soap);
        while (m.find()) {
            list.add(m.group(1));
        }
        return list;
    }

    public static boolean isNumber(String str) {
        try {
            Long.parseLong(str);
        }
        catch (Exception ignored) {
            return false;
        }
        return true;
    }

    public static String formatMac(String mac) {
        if (!StringUtil.isEmpty(mac)) {
            mac = mac.replace(":", "").replace("-", "");
            StringBuilder sb = new StringBuilder();
            int index = 0;
            for (char c : mac.toCharArray()) {
                sb.append(c);
                if (++index != 2) continue;
                sb.append("-");
                index = 0;
            }
            mac = sb.toString();
            return mac.substring(0, mac.length() - 1).toUpperCase();
        }
        return mac;
    }

    public static boolean strLengthBetween(String str, int minLength, int maxLength) {
        if (str == null) {
            return true;
        }
        int strLength = str.length();
        return strLength >= minLength && strLength <= maxLength;
    }

    public static String join(String[] array) {
        if (array.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String s : array) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static String join(String[] array, String split) {
        if (array.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                sb.append(split);
            }
            sb.append(array[i]);
        }
        return sb.toString();
    }

    public static boolean isEmptyAfterTrim(String s) {
        return s == null || s.trim().length() == 0;
    }

    @Nonnull
    public static String escapeSql(String str) {
        if (str == null) {
            return "";
        }
        return str.replace("%", "\\%").replace("_", "\\_");
    }

    private StringUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

