/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.utils;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MacAddressUtil {
    private static final String MAC_PATTERN1 = "^([0-9a-fA-F]{2})(([/\\s:-][0-9a-fA-F]{2}){5})$";
    private static final String MAC_PATTERN2 = "^([0-9a-fA-F]{2})(([0-9a-fA-F]{2}){5})$";

    private MacAddressUtil() {
    }

    public static boolean isValidMacAddress(String macAddress) {
        Pattern pattern1 = Pattern.compile(MAC_PATTERN1);
        Pattern pattern2 = Pattern.compile(MAC_PATTERN2);
        Matcher matcher1 = pattern1.matcher(macAddress);
        Matcher matcher2 = pattern2.matcher(macAddress);
        return matcher1.matches() || matcher2.matches();
    }

    public static String toCompactMac(String macAddress) {
        if (!MacAddressUtil.isValidMacAddress(macAddress)) {
            throw new IllegalArgumentException("mac format is error");
        }
        return macAddress.replaceAll("[/\\s:-]", "").toUpperCase();
    }

    public static String toDashMac(String macAddress) {
        if (Objects.isNull(macAddress)) {
            return null;
        }
        String s = macAddress.replaceAll("[/\\s:-]", "");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(s.charAt(0));
        for (int i = 1; i < s.length(); ++i) {
            if (i % 2 == 0) {
                stringBuilder.append("-");
            }
            stringBuilder.append(s.charAt(i));
        }
        return stringBuilder.toString().toUpperCase();
    }
}

