/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.server.utils;

import com.tplink.cdd.component.aaa.server.dto.BuildDMRequestDTO;
import com.tplink.cdd.component.aaa.server.io.RadiusEndpoint;
import com.tplink.cdd.component.aaa.server.io.client.RadiusClient;
import com.tplink.cdd.component.aaa.server.io.client.handler.ClientDatagramCodec;
import com.tplink.cdd.component.aaa.server.io.client.handler.PromiseAdapter;
import com.tplink.cdd.component.aaa.server.io.client.timeout.FixedTimeoutHandler;
import com.tplink.cdd.component.aaa.server.io.client.timeout.TimeoutHandler;
import com.tplink.cdd.component.aaa.utils.StringUtil;
import com.tplink.cdd.radius.common.RadiusPacketException;
import com.tplink.cdd.radius.common.dictionary.DefaultDictionary;
import com.tplink.cdd.radius.common.dictionary.Dictionary;
import com.tplink.cdd.radius.common.enums.RadiusAvp;
import com.tplink.cdd.radius.common.packet.request.RadiusRequest;
import com.tplink.cdd.radius.common.packet.response.RadiusResponse;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timer;
import java.net.InetSocketAddress;
import java.util.Collections;

public final class SendRequestUtil {
    private static final int NUM_OF_THREADS = 2;
    private static final int MAX_ATTEMPTS = 3;
    private static final int TIME_OUT_MS = 1000;
    private static NioEventLoopGroup eventLoopGroup = new NioEventLoopGroup(2);
    private static Bootstrap bootstrap = (Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)eventLoopGroup)).channel(NioDatagramChannel.class);
    private static TimeoutHandler timeoutHandler;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RadiusResponse startClientAndSend(RadiusRequest coaDmRequest, InetSocketAddress address, String sharedSecret) {
        RadiusEndpoint radiusEndpoint = new RadiusEndpoint(address, sharedSecret);
        try (RadiusClient radiusClient = new RadiusClient(bootstrap, new InetSocketAddress(0), timeoutHandler, (ChannelHandler)new ChannelInitializer<DatagramChannel>(){

            protected void initChannel(DatagramChannel datagramChannel) {
                datagramChannel.pipeline().addLast(new ChannelHandler[]{new ClientDatagramCodec(), new PromiseAdapter()});
            }
        });){
            RadiusResponse radiusResponse = (RadiusResponse)radiusClient.communicate(coaDmRequest, radiusEndpoint).syncUninterruptibly().getNow();
            return radiusResponse;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static RadiusRequest buildDMRequest(BuildDMRequestDTO dto) throws RadiusPacketException {
        RadiusRequest radiusRequest = (RadiusRequest)((RadiusRequest)((RadiusRequest)((RadiusRequest)RadiusRequest.create((Dictionary)DefaultDictionary.INSTANCE, (byte)40, (byte)1, null, Collections.emptyList()).addAttribute(RadiusAvp.USER_NAME.getName(), dto.getUsername())).addAttribute(RadiusAvp.NAS_IP_ADDRESS.getName(), dto.getNasIp())).addAttribute(RadiusAvp.CALLED_STATION_ID.getName(), dto.getNasMac() + ':' + dto.getSsId())).addAttribute(RadiusAvp.CALLING_STATION_ID.getName(), dto.getClientMac());
        if (StringUtil.isNotEmpty(dto.getClientIp())) {
            radiusRequest = (RadiusRequest)radiusRequest.addAttribute(RadiusAvp.FRAMED_IP_ADDRESS.getName(), dto.getClientIp());
        }
        if (StringUtil.isNotEmpty(dto.getAcctSessionId())) {
            radiusRequest = (RadiusRequest)radiusRequest.addAttribute(RadiusAvp.ACCT_SESSION_ID.getName(), dto.getAcctSessionId());
        }
        return radiusRequest;
    }

    private SendRequestUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        HashedWheelTimer timer = new HashedWheelTimer();
        timeoutHandler = new FixedTimeoutHandler((Timer)timer, 3, 1000);
    }
}

