/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.server.utils;

import com.tplink.cdd.component.aaa.core.authentication.cache.UserEapCacheInfo;
import com.tplink.cdd.component.aaa.core.authentication.dto.AuthReq;
import com.tplink.cdd.component.aaa.core.authentication.utils.CipherUtil;
import com.tplink.cdd.component.aaa.core.authentication.utils.EapPacketUtil;
import com.tplink.cdd.component.aaa.core.authentication.utils.UserCacheUtils;
import com.tplink.cdd.radius.common.RadiusPacketException;
import com.tplink.cdd.radius.common.attribute.type.OctetsAttribute;
import com.tplink.cdd.radius.common.attribute.type.RadiusAttribute;
import com.tplink.cdd.radius.common.attribute.type.VendorSpecificAttributeType;
import com.tplink.cdd.radius.common.dictionary.Dictionary;
import com.tplink.cdd.radius.common.eap.enums.DataType;
import com.tplink.cdd.radius.common.eap.packet.EapPacket;
import com.tplink.cdd.radius.common.enums.RadiusAvp;
import com.tplink.cdd.radius.common.packet.request.AccessRequest;
import com.tplink.cdd.radius.common.packet.request.AccessRequestEap;
import com.tplink.cdd.radius.common.packet.request.RadiusRequest;
import com.tplink.cdd.radius.common.packet.response.AccessResponse;
import com.tplink.cdd.radius.common.packet.response.RadiusResponse;
import com.tplink.cdd.radius.common.tls.CipherSuite.TlsGenericCipher;
import com.tplink.cdd.radius.common.utils.RadiusAttributeUtil;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AccessResponseUtil {
    private static final Logger log = LoggerFactory.getLogger(AccessResponseUtil.class);

    public static AccessResponse accept(AccessRequest accessRequest) {
        if (accessRequest instanceof AccessRequestEap) {
            return AccessResponseUtil.fromEapPacket(accessRequest, EapPacketUtil.success((AccessRequestEap)accessRequest), null);
        }
        return AccessResponseUtil.accept(accessRequest, Collections.emptyList());
    }

    public static AccessResponse reject(AccessRequest accessRequest) {
        if (accessRequest instanceof AccessRequestEap) {
            return AccessResponseUtil.fromEapPacket(accessRequest, EapPacketUtil.failure((AccessRequestEap)accessRequest), null);
        }
        return AccessResponseUtil.reject(accessRequest, Collections.emptyList());
    }

    public static AccessResponse fromEapPacket(AccessRequest accessRequest, EapPacket eapPacket, AuthReq authReq) {
        switch (eapPacket.getCode()) {
            case 1: {
                return AccessResponseUtil.challenge(accessRequest, eapPacket.toRadiusAttribute(accessRequest.getDictionary()));
            }
            case 3: {
                DataType dataType;
                List radiusAttributes = eapPacket.toRadiusAttribute(accessRequest.getDictionary());
                if (accessRequest instanceof AccessRequestEap && (DataType.PEAP.equals((Object)(dataType = ((AccessRequestEap)accessRequest).getEapResponse().getEapData().getType())) || DataType.EAP_TTLS.equals((Object)dataType))) {
                    if (Objects.isNull(authReq)) {
                        return AccessResponseUtil.reject(accessRequest, eapPacket.toRadiusAttribute(accessRequest.getDictionary()));
                    }
                    String clientMac = RadiusAttributeUtil.clientMac((RadiusRequest)accessRequest);
                    UserEapCacheInfo eapCacheInfo = UserCacheUtils.getUserEapCacheInfo(authReq, clientMac);
                    if (Objects.isNull(eapCacheInfo)) {
                        return AccessResponseUtil.reject(accessRequest, eapPacket.toRadiusAttribute(accessRequest.getDictionary()));
                    }
                    byte[] msKeyMaterial = DataType.PEAP.equals((Object)dataType) ? ((TlsGenericCipher)eapCacheInfo.getEapTlsInfo().getTlsCipher()).getMsPeapKeyMaterial() : ((TlsGenericCipher)eapCacheInfo.getEapTlsInfo().getTlsCipher()).getMsTtlsKeyMaterial();
                    byte[] msSendKeyMaterial = new byte[32];
                    System.arraycopy(msKeyMaterial, 32, msSendKeyMaterial, 0, 32);
                    byte[] msRecvKeyMaterial = new byte[32];
                    System.arraycopy(msKeyMaterial, 0, msRecvKeyMaterial, 0, 32);
                    byte[] sharedKey = authReq.getRadiusKey().getBytes(StandardCharsets.UTF_8);
                    byte[] authenticator = authReq.getAuthenticator();
                    byte[] msMppeSendBytes = CipherUtil.toTunnelPassword(msSendKeyMaterial, sharedKey, authenticator);
                    OctetsAttribute msMppeSendKey = new OctetsAttribute(accessRequest.getDictionary(), VendorSpecificAttributeType.MS_MPPE_SEND_KEY.getVendorId(), Unpooled.buffer().writeByte(RadiusAvp.VENDOR_SPECIFIC.getIndex()).writeByte(msMppeSendBytes.length + 8).writeInt(VendorSpecificAttributeType.MS_MPPE_SEND_KEY.getVendorId()).writeByte(VendorSpecificAttributeType.MS_MPPE_SEND_KEY.getValue()).writeByte(msMppeSendBytes.length + 2).writeBytes(msMppeSendBytes));
                    radiusAttributes.add(msMppeSendKey);
                    byte[] msMppeRecvBytes = CipherUtil.toTunnelPassword(msRecvKeyMaterial, sharedKey, authenticator);
                    OctetsAttribute msMppeRecvKey = new OctetsAttribute(accessRequest.getDictionary(), VendorSpecificAttributeType.MS_MPPE_RECV_KEY.getVendorId(), Unpooled.buffer().writeByte(RadiusAvp.VENDOR_SPECIFIC.getIndex()).writeByte(msMppeRecvBytes.length + 8).writeInt(VendorSpecificAttributeType.MS_MPPE_RECV_KEY.getVendorId()).writeByte(VendorSpecificAttributeType.MS_MPPE_RECV_KEY.getValue()).writeByte(msMppeRecvBytes.length + 2).writeBytes(msMppeRecvBytes));
                    radiusAttributes.add(msMppeRecvKey);
                    RadiusAttribute userName = accessRequest.getDictionary().createAttribute(RadiusAvp.USER_NAME.getName(), authReq.getUsername());
                    radiusAttributes.add(userName);
                }
                return AccessResponseUtil.accept(accessRequest, radiusAttributes);
            }
            case 4: {
                return AccessResponseUtil.reject(accessRequest, eapPacket.toRadiusAttribute(accessRequest.getDictionary()));
            }
        }
        log.error("Unexpected EAP packet type [{}]!", (Object)eapPacket.getCode());
        return AccessResponseUtil.reject(accessRequest, Collections.emptyList());
    }

    private static AccessResponse challenge(AccessRequest accessRequest, List<RadiusAttribute> radiusAttributeList) {
        return AccessResponseUtil.buildAccessResponse(accessRequest, (byte)11, radiusAttributeList);
    }

    public static AccessResponse accept(AccessRequest accessRequest, List<RadiusAttribute> radiusAttributeList) {
        return AccessResponseUtil.buildAccessResponse(accessRequest, (byte)2, radiusAttributeList);
    }

    private static AccessResponse reject(AccessRequest accessRequest, List<RadiusAttribute> radiusAttributeList) {
        return AccessResponseUtil.buildAccessResponse(accessRequest, (byte)3, radiusAttributeList);
    }

    private static AccessResponse buildAccessResponse(AccessRequest accessRequest, byte type, List<RadiusAttribute> attributeList) {
        try {
            return (AccessResponse)RadiusResponse.create((Dictionary)accessRequest.getDictionary(), (byte)type, (byte)accessRequest.getId(), (byte[])accessRequest.getAuthenticator(), attributeList);
        }
        catch (RadiusPacketException e) {
            log.error("Unexpect exception caught when build RADIUS response!", (Throwable)e);
            return null;
        }
    }

    private AccessResponseUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

