/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.server.utils;

import com.tplink.cdd.component.aaa.core.authentication.annotation.Auth;
import com.tplink.cdd.component.aaa.core.authentication.service.handler.RadiusAuthAbstractHandler;
import com.tplink.cdd.radius.common.eap.packet.EapResponse;
import com.tplink.cdd.radius.common.enums.AuthType;
import com.tplink.cdd.radius.common.enums.RadiusAuthPacketType;
import com.tplink.cdd.radius.common.packet.request.AccessRequest;
import com.tplink.cdd.radius.common.packet.request.AccessRequestEap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AccessRequestUtil {
    private static final Logger log = LoggerFactory.getLogger(AccessRequestUtil.class);

    public static <T extends RadiusAuthAbstractHandler> RadiusAuthPacketType findPacketType(T handler) {
        return handler.getClass().getAnnotation(Auth.class).radiusAuthPacketType();
    }

    public static <T extends RadiusAuthAbstractHandler> AuthType findAuthType(T handler) {
        return handler.getClass().getAnnotation(Auth.class).authType();
    }

    public static EapResponse findEapResponse(AccessRequest accessRequest) {
        AccessRequestEap accessRequestEap = (AccessRequestEap)accessRequest;
        return accessRequestEap.getEapResponse();
    }

    private AccessRequestUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

