/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.server.io.client.timeout;

import com.tplink.cdd.component.aaa.server.io.client.timeout.TimeoutHandler;
import com.tplink.cdd.radius.common.packet.response.RadiusResponse;
import io.netty.util.Timer;
import io.netty.util.concurrent.Promise;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class FixedTimeoutHandler
implements TimeoutHandler {
    private final Timer timer;
    private final int maxAttempts;
    private final int timeoutMs;

    public FixedTimeoutHandler(Timer timer, int maxAttempts, int timeoutMs) {
        this.timer = timer;
        this.maxAttempts = maxAttempts;
        this.timeoutMs = timeoutMs;
    }

    @Override
    public void onTimeout(Runnable retry, int totalAttempts, Promise<RadiusResponse> promise) {
        this.timer.newTimeout(t -> {
            if (promise.isDone()) {
                return;
            }
            if (totalAttempts >= this.maxAttempts) {
                promise.tryFailure((Throwable)new TimeoutException("Client send timeout - max attempts reached: " + this.maxAttempts));
            } else {
                retry.run();
            }
        }, (long)this.timeoutMs, TimeUnit.MILLISECONDS);
    }
}

