/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.server.io.client.handler;

import com.tplink.cdd.component.aaa.server.io.client.PendingRequestCtx;
import com.tplink.cdd.radius.common.RadiusPacketException;
import com.tplink.cdd.radius.common.packet.request.RadiusRequest;
import com.tplink.cdd.radius.common.packet.response.RadiusResponse;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.util.concurrent.Promise;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PromiseAdapter
extends MessageToMessageCodec<RadiusResponse, PendingRequestCtx> {
    private static final Logger log = LoggerFactory.getLogger(PromiseAdapter.class);
    private final Map<String, Request> requests = new ConcurrentHashMap<String, Request>();

    protected void encode(ChannelHandlerContext ctx, PendingRequestCtx msg, List<Object> out) {
        RadiusRequest packet = msg.getRequest();
        String requestId = Byte.toString(packet.getId());
        try {
            RadiusRequest encodedRequest = packet.encodeRequest(msg.getEndpoint().getSecret());
            msg.getResponse().addListener(future -> {
                this.requests.remove(requestId);
                log.debug("Removing {} from pending requests", (Object)requestId);
            });
            this.requests.put(requestId, new Request(msg.getEndpoint().getSecret(), encodedRequest.getAuthenticator(), encodedRequest.getId(), msg.getResponse()));
            log.debug("Adding {} to pending requests", (Object)requestId);
            out.add(new PendingRequestCtx(encodedRequest, msg.getEndpoint(), msg.getRadiusKey(), msg.getResponse()));
        }
        catch (RadiusPacketException e) {
            log.warn("Could not encode packet", (Throwable)e);
            msg.getResponse().tryFailure((Throwable)e);
        }
    }

    protected void decode(ChannelHandlerContext ctx, RadiusResponse msg, List<Object> out) {
        String responseId = Byte.toString(msg.getId());
        Request request = this.requests.get(responseId);
        if (request == null) {
            log.warn("Ignoring response - request context not found, responseId {}", (Object)responseId);
            return;
        }
        try {
            RadiusResponse response = msg.decodeResponse(request.secret, request.auth);
            log.info("Found request for response identifier => {}", (Object)response.getId());
            request.promise.trySuccess((Object)response);
        }
        catch (RadiusPacketException e) {
            log.warn("Could not decode packet", (Throwable)e);
        }
    }

    private static class Request {
        private final String secret;
        private final byte[] auth;
        private final int id;
        private final Promise<RadiusResponse> promise;

        Request(String secret, byte[] auth, int id, Promise<RadiusResponse> promise) {
            this.secret = secret;
            this.auth = auth;
            this.id = id;
            this.promise = promise;
        }
    }
}

