/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.server.io.client.handler;

import com.tplink.cdd.component.aaa.server.io.client.PendingRequestCtx;
import com.tplink.cdd.radius.common.RadiusPacketException;
import com.tplink.cdd.radius.common.dictionary.DefaultDictionary;
import com.tplink.cdd.radius.common.dictionary.Dictionary;
import com.tplink.cdd.radius.common.packet.response.RadiusResponse;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.MessageToMessageCodec;
import java.net.InetSocketAddress;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class ClientDatagramCodec
extends MessageToMessageCodec<DatagramPacket, PendingRequestCtx> {
    private static final Logger log = LoggerFactory.getLogger(ClientDatagramCodec.class);
    private final Dictionary dictionary = DefaultDictionary.INSTANCE;

    protected void encode(ChannelHandlerContext ctx, PendingRequestCtx msg, List<Object> out) {
        log.debug("Sending packet to {} - {}", (Object)msg.getEndpoint().getAddress(), (Object)msg.getRequest());
        DatagramPacket datagramPacket = new DatagramPacket(msg.getRequest().toByteBuf(), msg.getEndpoint().getAddress(), (InetSocketAddress)ctx.channel().localAddress());
        out.add(datagramPacket);
    }

    protected void decode(ChannelHandlerContext channelHandlerContext, DatagramPacket msg, List<Object> out) {
        InetSocketAddress remoteAddress = (InetSocketAddress)msg.sender();
        if (remoteAddress == null) {
            log.warn("Ignoring response, remoteAddress is null");
        }
        try {
            RadiusResponse response = RadiusResponse.fromDatagram((Dictionary)this.dictionary, (DatagramPacket)msg);
            log.debug("Received packet from {} - {}", (Object)remoteAddress, (Object)response);
            out.add(response);
        }
        catch (RadiusPacketException e) {
            log.warn("Could not deserialize packet: {}", (Object)e.getMessage());
        }
    }
}

