/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.server.io.client;

import com.tplink.cdd.component.aaa.server.io.RadiusEndpoint;
import com.tplink.cdd.component.aaa.server.io.client.PendingRequestCtx;
import com.tplink.cdd.component.aaa.server.io.client.timeout.TimeoutHandler;
import com.tplink.cdd.radius.common.packet.request.RadiusRequest;
import com.tplink.cdd.radius.common.packet.response.RadiusResponse;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import java.io.Closeable;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RadiusClient
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(RadiusClient.class);
    private final TimeoutHandler timeoutHandler;
    private final EventLoopGroup eventLoopGroup;
    private final ChannelFuture channelFuture;

    public RadiusClient(Bootstrap bootstrap, SocketAddress listenAddress, TimeoutHandler timeoutHandler, ChannelHandler handler) {
        this.eventLoopGroup = bootstrap.config().group();
        this.timeoutHandler = timeoutHandler;
        this.channelFuture = ((Bootstrap)bootstrap.clone().handler(handler)).bind(listenAddress);
    }

    public Future<RadiusResponse> communicate(RadiusRequest packet, List<RadiusEndpoint> endpoints) {
        if (endpoints.isEmpty()) {
            return this.eventLoopGroup.next().newFailedFuture((Throwable)new IOException("Client send failed - no valid endpoints"));
        }
        Promise promise = this.eventLoopGroup.next().newPromise();
        this.communicateRecursive(packet, endpoints, 0, (Promise<RadiusResponse>)promise, null);
        return promise;
    }

    private void communicateRecursive(RadiusRequest packet, List<RadiusEndpoint> endpoints, int endpointIndex, Promise<RadiusResponse> promise, Throwable LastException) {
        if (endpointIndex >= endpoints.size()) {
            promise.tryFailure((Throwable)new IOException("Client send failed - all endpoints failed", LastException));
            return;
        }
        this.communicate(packet, endpoints.get(endpointIndex)).addListener(f -> {
            if (f.isSuccess()) {
                promise.trySuccess(f.getNow());
            } else {
                this.communicateRecursive(packet, endpoints, endpointIndex + 1, promise, f.cause());
            }
        });
    }

    public Future<RadiusResponse> communicate(RadiusRequest packet, RadiusEndpoint endpoint) {
        Promise promise = this.eventLoopGroup.next().newPromise().addListener(future -> {
            if (future.isSuccess()) {
                log.info("Response received, packet: {}", future.getNow());
            } else {
                log.warn(future.cause().getMessage());
            }
        });
        this.channelFuture.addListener(future -> {
            if (future.isSuccess()) {
                this.send(new PendingRequestCtx(packet, endpoint, endpoint.getSecret(), (Promise<RadiusResponse>)promise), 1);
            } else {
                promise.tryFailure(future.cause());
            }
        });
        return promise;
    }

    private void send(PendingRequestCtx ctx, int attempt) {
        log.info("Attemp {}, sending packet to {}", (Object)attempt, (Object)ctx.getEndpoint().getAddress());
        this.channelFuture.channel().writeAndFlush((Object)ctx);
        this.timeoutHandler.onTimeout(() -> this.send(ctx, attempt + 1), attempt, ctx.getResponse());
    }

    @Override
    public void close() throws IOException {
        this.channelFuture.channel().close();
    }
}

