/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.server.io;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TacacsServer
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(TacacsServer.class);
    private final NioEventLoopGroup boss = new NioEventLoopGroup();
    private final NioEventLoopGroup worker;
    private final ChannelFuture tacacsFuture;

    public TacacsServer(int nioEventLoopGroupThreadNum, ChannelHandler tacacsHandler, InetSocketAddress socket) {
        this.worker = new NioEventLoopGroup(nioEventLoopGroupThreadNum);
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        serverBootstrap.group((EventLoopGroup)this.boss, (EventLoopGroup)this.worker).channel(NioServerSocketChannel.class);
        this.tacacsFuture = serverBootstrap.childHandler(tacacsHandler).bind((SocketAddress)socket).addListener(readyFuture -> {
            if (readyFuture.isSuccess()) {
                log.info("Tacacs-plus-server started on {}", (Object)socket);
            } else {
                log.error("Could not start Tacacs-plus-server on {}", (Object)socket);
                this.close();
            }
        });
    }

    @Override
    public void close() {
        log.info("Closing tacacs-plus-server on {}", (Object)this.tacacsFuture.channel().localAddress());
        this.tacacsFuture.channel().close();
        log.info("Shutdown tacacs-plus-server eventLoopGroup Gracefully");
        this.boss.shutdownGracefully();
        this.worker.shutdownGracefully();
    }

    public boolean checkStatus() {
        return this.tacacsFuture.channel().isActive() && !this.boss.isShutdown() && !this.worker.isShutdown();
    }
}

