/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.server.io;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseCombiner;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RadiusServer
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(RadiusServer.class);
    private final EventLoopGroup eventLoopGroup;
    private final ChannelFuture future;

    public RadiusServer(int nioEventLoopGroupThreadNum, ChannelHandler handler, InetSocketAddress socket) {
        this.eventLoopGroup = new NioEventLoopGroup(nioEventLoopGroupThreadNum);
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)new Bootstrap().channel(NioDatagramChannel.class)).group(this.eventLoopGroup);
        this.future = ((Bootstrap)bootstrap.handler(handler)).bind((SocketAddress)socket);
        Promise isReady = bootstrap.config().group().next().newPromise();
        PromiseCombiner combiner = new PromiseCombiner((EventExecutor)ImmediateEventExecutor.INSTANCE);
        combiner.addAll(new Future[]{this.future});
        combiner.finish(isReady);
        isReady.addListener(readyFuture -> {
            if (readyFuture.isSuccess()) {
                log.info("radius-server started on {}", (Object)this.future.channel().localAddress());
            } else {
                log.error("Could not start radius-server on {}", (Object)this.future.channel().localAddress());
                this.close();
            }
        });
    }

    @Override
    public void close() {
        log.info("Closing radius-server on {}", (Object)this.future.channel().localAddress());
        this.future.channel().close();
        log.info("Shutdown radius-server eventLoopGroup Gracefully");
        this.eventLoopGroup.shutdownGracefully();
    }

    public boolean checkStatus() {
        return this.future.channel().isActive() && !this.eventLoopGroup.isShutdown();
    }
}

