/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.server.core.service;

import com.tplink.cdd.component.aaa.server.api.tacacs.TacacsApiService;
import com.tplink.cdd.component.aaa.server.core.service.TacacsAuthorHandler;
import com.tplink.cdd.component.aaa.server.dto.tacacs.TacacsUserApiDTO;
import com.tplink.cdd.component.aaa.server.utils.CustomPIIMaskUtil;
import com.tplink.cdd.components.aaa.tacacs.common.TacacsPacketException;
import com.tplink.cdd.components.aaa.tacacs.common.packet.base.Argument;
import com.tplink.cdd.components.aaa.tacacs.common.packet.base.TacacsHeader;
import com.tplink.cdd.components.aaa.tacacs.common.packet.constant.ReplyConstant;
import com.tplink.cdd.components.aaa.tacacs.common.packet.constant.RequestConstant;
import com.tplink.cdd.components.aaa.tacacs.common.packet.reply.AuthorizationReply;
import com.tplink.cdd.components.aaa.tacacs.common.packet.request.AuthorizationRequest;
import com.tplink.smb.component.cache.api.CacheService;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class TacacsLoginAuthorHandler
implements TacacsAuthorHandler {
    private static final Logger log = LoggerFactory.getLogger(TacacsLoginAuthorHandler.class);
    @Autowired
    private CacheService cacheService;
    @Autowired
    private TacacsApiService tacacsApiService;

    @Override
    public AuthorizationReply author(String nasIp, AuthorizationRequest authorizationRequest) throws TacacsPacketException {
        TacacsHeader header = authorizationRequest.getHeader();
        TacacsHeader replyHeader = header.next();
        String username = authorizationRequest.getUser();
        AuthorizationReply authorizationReply = new AuthorizationReply();
        authorizationReply.setTacacsHeader(replyHeader);
        authorizationReply.setStatus(ReplyConstant.AuthorStatusEnum.FOLLOW);
        if (StringUtils.isEmpty((Object)username)) {
            log.warn("Username is empty for the authorization packet, authorization failed, device ip: {}", (Object)CustomPIIMaskUtil.encrypt(nasIp));
            return authorizationReply;
        }
        if (authorizationRequest.getAuthenService() != RequestConstant.AuthenServiceEnum.LOGIN) {
            return authorizationReply;
        }
        Optional<TacacsUserApiDTO> tacacsUserApiDTO = this.tacacsApiService.getUserInfo(nasIp, username);
        if (!tacacsUserApiDTO.isPresent()) {
            log.warn("The authorized user: {} does not exist", (Object)CustomPIIMaskUtil.hash(username));
            return authorizationReply;
        }
        Boolean authCache = (Boolean)this.cacheService.get("tpas:aaa:tacacs:user", nasIp + username, Boolean.class);
        if (authCache != null) {
            authorizationReply.setStatus(ReplyConstant.AuthorStatusEnum.PASS_ADD);
            authorizationReply.setServerMsg("Authorization passed.");
            if (!authCache.booleanValue()) {
                int privLvl = tacacsUserApiDTO.get().getAccessLevel() == null ? RequestConstant.PrivLvlEnum.USER.getCode() : tacacsUserApiDTO.get().getAccessLevel().intValue();
                authorizationReply.setArguments(new Argument[]{new Argument("priv-lvl=" + privLvl)});
            }
        } else {
            log.warn("Authorization fail, no login information, nasIP: {}, user: {}", (Object)CustomPIIMaskUtil.encrypt(nasIp), (Object)CustomPIIMaskUtil.hash(username));
            authorizationReply.setServerMsg("Login information not found, please login again.");
        }
        return authorizationReply;
    }
}

