/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.server.core.service;

import com.tplink.cdd.component.aaa.server.api.tacacs.TacacsApiService;
import com.tplink.cdd.component.aaa.server.utils.CustomPIIMaskUtil;
import com.tplink.cdd.components.aaa.tacacs.common.TacacsPacketException;
import com.tplink.cdd.components.aaa.tacacs.common.packet.base.TacacsHeader;
import com.tplink.cdd.components.aaa.tacacs.common.packet.constant.HeaderConstant;
import com.tplink.cdd.components.aaa.tacacs.common.packet.constant.ReplyConstant;
import com.tplink.cdd.components.aaa.tacacs.common.packet.constant.RequestConstant;
import com.tplink.cdd.components.aaa.tacacs.common.packet.reply.AuthenticationReply;
import com.tplink.cdd.components.aaa.tacacs.common.packet.request.AuthenticationStart;
import com.tplink.smb.component.cache.api.CacheService;
import io.netty.util.internal.StringUtil;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TacacsAuthStartHandler {
    private static final Logger log = LoggerFactory.getLogger(TacacsAuthStartHandler.class);
    @Autowired
    private CacheService cacheService;
    @Autowired
    private TacacsApiService tacacsApiService;

    public AuthenticationReply startAuth(String nasIp, AuthenticationStart authenticationStart) throws TacacsPacketException {
        TacacsHeader header = authenticationStart.getHeader();
        TacacsHeader replyHeader = header.next();
        AuthenticationReply authenticationReply = new AuthenticationReply();
        authenticationReply.setTacacsHeader(replyHeader);
        authenticationReply.setFlags(ReplyConstant.FlagEnum.ECHO.getCode());
        authenticationReply.setStatus(ReplyConstant.AuthenStatusEnum.FOLLOW);
        RequestConstant.AuthenTypeEnum authenType = authenticationStart.getAuthenType();
        RequestConstant.AuthenServiceEnum authenService = authenticationStart.getAuthenService();
        String username = authenticationStart.getUser();
        if (authenService == RequestConstant.AuthenServiceEnum.ENABLE) {
            this.getAsciiAuthStartReplyPacket(authenticationReply, username, nasIp);
            this.cacheService.set("tpas:aaa:tacacs:enable", header.getSessionId() + nasIp, (Object)nasIp, 15L, TimeUnit.SECONDS);
            return authenticationReply;
        }
        if (authenType == RequestConstant.AuthenTypeEnum.ASCII) {
            if (header.getVersion() == HeaderConstant.VersionEnum.VER_ONE) {
                authenticationReply.setServerMsg("Invalid version for ASCII login");
                log.warn("Invalid version for ASCII login, authentication failed, nasIp: {}", (Object)CustomPIIMaskUtil.encrypt(nasIp));
                return authenticationReply;
            }
            this.getAsciiAuthStartReplyPacket(authenticationReply, username, nasIp);
        } else {
            authenticationReply.setServerMsg("Unsupported authentication type");
        }
        return authenticationReply;
    }

    private void getAsciiAuthStartReplyPacket(AuthenticationReply authenticationReply, String username, String nasIp) {
        if (StringUtil.isNullOrEmpty((String)username)) {
            authenticationReply.setStatus(ReplyConstant.AuthenStatusEnum.GETUSER);
            authenticationReply.setServerMsg("username: ");
            return;
        }
        if (!this.tacacsApiService.getUserInfo(nasIp, username).isPresent()) {
            log.warn("User not found, username: {}", (Object)CustomPIIMaskUtil.hash(username));
            authenticationReply.setStatus(ReplyConstant.AuthenStatusEnum.FOLLOW);
            authenticationReply.setServerMsg("Invalid user");
            return;
        }
        this.cacheService.set("tpas:aaa:tacacs:user", authenticationReply.getTacacsHeader().getSessionId() + nasIp, (Object)username, 15L, TimeUnit.SECONDS);
        authenticationReply.setStatus(ReplyConstant.AuthenStatusEnum.GETPASS);
        authenticationReply.setServerMsg("password: ");
    }
}

