/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.server.core.service;

import com.tplink.cdd.component.aaa.server.api.tacacs.TacacsApiService;
import com.tplink.cdd.component.aaa.server.dto.tacacs.TacacsUserApiDTO;
import com.tplink.cdd.component.aaa.server.utils.CustomPIIMaskUtil;
import com.tplink.cdd.components.aaa.tacacs.common.TacacsPacketException;
import com.tplink.cdd.components.aaa.tacacs.common.packet.base.TacacsHeader;
import com.tplink.cdd.components.aaa.tacacs.common.packet.constant.ReplyConstant;
import com.tplink.cdd.components.aaa.tacacs.common.packet.reply.AuthenticationReply;
import com.tplink.cdd.components.aaa.tacacs.common.packet.request.AuthenticationContinue;
import com.tplink.smb.component.cache.api.CacheService;
import io.netty.util.internal.StringUtil;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TacacsAuthContinueHandler {
    private static final Logger log = LoggerFactory.getLogger(TacacsAuthContinueHandler.class);
    @Autowired
    private CacheService cacheService;
    @Autowired
    private TacacsApiService tacacsApiService;

    public AuthenticationReply continueAuth(String nasIp, AuthenticationContinue authenticationContinue) throws TacacsPacketException {
        TacacsHeader replyHeader = authenticationContinue.getHeader().next();
        AuthenticationReply authenticationReply = new AuthenticationReply();
        authenticationReply.setTacacsHeader(replyHeader);
        authenticationReply.setStatus(ReplyConstant.AuthenStatusEnum.FOLLOW);
        authenticationReply.setFlags(ReplyConstant.FlagEnum.ECHO.getCode());
        String sessionId = Integer.toString(replyHeader.getSessionId());
        String cacheKey = sessionId + nasIp;
        String cacheUsername = (String)this.cacheService.get("tpas:aaa:tacacs:user", cacheKey, String.class);
        if (cacheUsername == null) {
            return this.continueAuthToRequestData(nasIp, authenticationContinue, authenticationReply, cacheKey);
        }
        return this.continueAuthWithUsername(nasIp, authenticationContinue, authenticationReply, cacheUsername, cacheKey);
    }

    private AuthenticationReply continueAuthWithUsername(String nasIp, AuthenticationContinue authenticationContinue, AuthenticationReply authenticationReply, String cacheUsername, String cacheKey) {
        String enablePassword;
        boolean enable;
        String password = authenticationContinue.getUserMsg();
        if (StringUtil.isNullOrEmpty((String)password)) {
            if (authenticationReply.getTacacsHeader().getSeqNum() > 12) {
                authenticationReply.setServerMsg("Exceeded maximum number of retries.");
                log.warn("Exceeded the maximum number of retries to request username and password, authentication failed, username: {}, device ip: {}.", (Object)CustomPIIMaskUtil.hash(cacheUsername), (Object)CustomPIIMaskUtil.encrypt(nasIp));
                return authenticationReply;
            }
            authenticationReply.setStatus(ReplyConstant.AuthenStatusEnum.GETPASS);
            authenticationReply.setServerMsg("password: ");
            authenticationReply.setFlags(ReplyConstant.FlagEnum.NOECHO.getCode());
            return authenticationReply;
        }
        Optional<TacacsUserApiDTO> tacacsUserApiDTO = this.tacacsApiService.getUserInfo(nasIp, cacheUsername);
        if (!tacacsUserApiDTO.isPresent()) {
            log.warn("user not found, username: {}.", (Object)CustomPIIMaskUtil.hash(cacheUsername));
            authenticationReply.setServerMsg("Invalid user");
            return authenticationReply;
        }
        String enableFlag = (String)this.cacheService.get("tpas:aaa:tacacs:enable", cacheKey, String.class);
        String userPassword = tacacsUserApiDTO.get().getPassword();
        boolean bl = enable = enableFlag != null;
        if (enable && StringUtils.isNotEmpty((CharSequence)(enablePassword = tacacsUserApiDTO.get().getEnablePwd()))) {
            userPassword = enablePassword;
        }
        if (StringUtils.equals((CharSequence)password, (CharSequence)userPassword)) {
            authenticationReply.setStatus(ReplyConstant.AuthenStatusEnum.PASS);
            authenticationReply.setServerMsg("Welcome");
            this.cacheService.set("tpas:aaa:tacacs:user", nasIp + cacheUsername, (Object)enable, 15L, TimeUnit.SECONDS);
        } else {
            authenticationReply.setStatus(ReplyConstant.AuthenStatusEnum.FOLLOW);
            authenticationReply.setServerMsg("Bad username or password");
            log.warn("Authentication failed with bad username or password, username: {}, nasIp: {}.", (Object)CustomPIIMaskUtil.hash(cacheUsername), (Object)CustomPIIMaskUtil.encrypt(nasIp));
        }
        return authenticationReply;
    }

    private AuthenticationReply continueAuthToRequestData(String nasIp, AuthenticationContinue authenticationContinue, AuthenticationReply authenticationReply, String cacheKey) {
        String username = authenticationContinue.getUserMsg();
        if (StringUtil.isNullOrEmpty((String)username)) {
            if (authenticationReply.getTacacsHeader().getSeqNum() > 7) {
                authenticationReply.setServerMsg("Exceeded maximum number of retries.");
                log.warn("Exceeded the maximum number of retries to request username, connection with device {} will be closed.", (Object)CustomPIIMaskUtil.encrypt(nasIp));
                return authenticationReply;
            }
            authenticationReply.setStatus(ReplyConstant.AuthenStatusEnum.GETUSER);
            authenticationReply.setServerMsg("username: ");
            return authenticationReply;
        }
        if (!this.tacacsApiService.getUserInfo(nasIp, username).isPresent()) {
            log.warn("User not found, username: {}", (Object)CustomPIIMaskUtil.hash(username));
            authenticationReply.setStatus(ReplyConstant.AuthenStatusEnum.FOLLOW);
            authenticationReply.setServerMsg("Invalid user");
            return authenticationReply;
        }
        this.cacheService.set("tpas:aaa:tacacs:user", cacheKey, (Object)username, 15L, TimeUnit.SECONDS);
        authenticationReply.setStatus(ReplyConstant.AuthenStatusEnum.GETPASS);
        authenticationReply.setServerMsg("password: ");
        authenticationReply.setFlags(ReplyConstant.FlagEnum.NOECHO.getCode());
        return authenticationReply;
    }
}

