/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.server.core.handler.tacacs;

import com.tplink.cdd.component.aaa.server.api.tacacs.TacacsApiService;
import com.tplink.cdd.component.aaa.server.config.TacacsServerConfig;
import com.tplink.cdd.component.aaa.server.core.TacacsAuthRequestHandlerOrder;
import com.tplink.cdd.component.aaa.server.dto.NasApiDTO;
import com.tplink.cdd.component.aaa.server.dto.tacacs.TacacsAuthenticationContinueReq;
import com.tplink.cdd.component.aaa.server.dto.tacacs.TacacsAuthenticationStartReq;
import com.tplink.cdd.component.aaa.server.dto.tacacs.TacacsAuthorizationReq;
import com.tplink.cdd.component.aaa.server.utils.CustomPIIMaskUtil;
import com.tplink.cdd.component.aaa.utils.StringUtil;
import com.tplink.cdd.components.aaa.tacacs.common.TacacsPacketException;
import com.tplink.cdd.components.aaa.tacacs.common.packet.base.TacacsHeader;
import com.tplink.cdd.components.aaa.tacacs.common.packet.constant.HeaderConstant;
import com.tplink.cdd.components.aaa.tacacs.common.packet.reply.ReplyPacket;
import com.tplink.cdd.components.aaa.tacacs.common.packet.request.AuthenticationContinue;
import com.tplink.cdd.components.aaa.tacacs.common.packet.request.AuthenticationStart;
import com.tplink.cdd.components.aaa.tacacs.common.packet.request.AuthorizationRequest;
import com.tplink.smb.component.cache.api.CacheService;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@ChannelHandler.Sharable
@TacacsAuthRequestHandlerOrder(order=40)
public class TacacsPacketCodec
extends MessageToMessageCodec<ByteBuf, ReplyPacket> {
    private static final Logger log = LoggerFactory.getLogger(TacacsPacketCodec.class);
    @Autowired
    private TacacsApiService tacacsApiService;
    @Autowired
    private CacheService cacheService;
    @Autowired
    private TacacsServerConfig tacacsServerConfig;

    protected void encode(ChannelHandlerContext ctx, ReplyPacket reply, List<Object> list) throws Exception {
        try {
            ByteBuf byteBuf = ctx.alloc().buffer();
            byte[] replyBytes = reply.writeToBytes(reply.getTacacsKey());
            log.debug(CustomPIIMaskUtil.encrypt(reply.toString()));
            byteBuf.writeBytes(replyBytes);
            list.add(byteBuf);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            log.warn("Could not serialize tacacs-plus packet: {}", (Object)e.getMessage());
        }
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf byteBuf, List<Object> list) throws Exception {
        InetSocketAddress address = (InetSocketAddress)ctx.channel().remoteAddress();
        String nasIp = address.getAddress().getHostAddress();
        Optional<NasApiDTO> optionalNasApiDTO = this.tacacsApiService.getNasInfo(address);
        if (!optionalNasApiDTO.isPresent()) {
            log.warn("Device: {} does not exist, connection closed.", (Object)CustomPIIMaskUtil.encrypt(nasIp));
            return;
        }
        String tacacsKey = !StringUtil.isEmpty(optionalNasApiDTO.get().getSecretKey()) ? optionalNasApiDTO.get().getSecretKey() : this.tacacsServerConfig.getSecretKey();
        if (StringUtils.isEmpty((Object)tacacsKey)) {
            log.warn("Device: {} does not exist, connection closed.", (Object)CustomPIIMaskUtil.encrypt(nasIp));
            return;
        }
        byte[] headerBytes = new byte[12];
        byteBuf.readBytes(headerBytes);
        TacacsHeader header = new TacacsHeader(headerBytes);
        byte[] body = new byte[header.getBodyLength()];
        byteBuf.readBytes(body);
        HeaderConstant.TypeEnum type = header.getType();
        HeaderConstant.VersionEnum version = header.getVersion();
        if (version == null || type == null) {
            ctx.channel().close();
            log.warn("Unknown tacacs-plus packet version or type.");
            return;
        }
        byte[] bodyClear = header.hasFlag(HeaderConstant.FlagsEnum.UNENCRYPTED) ? body : header.obfuscateBody(body, tacacsKey.getBytes(StandardCharsets.UTF_8));
        try {
            switch (type) {
                case AUTHEN: {
                    if (header.getSeqNum() == 1) {
                        AuthenticationStart authenStart = new AuthenticationStart(header, bodyClear);
                        log.debug(CustomPIIMaskUtil.encrypt(authenStart.toString()));
                        this.setSingleConnectFlag(ctx, header);
                        list.add(TacacsAuthenticationStartReq.builder().authenticationStart(authenStart).nasIp(nasIp).tacacsKey(tacacsKey).build());
                        break;
                    }
                    if (version == HeaderConstant.VersionEnum.VER_DEFAULT) {
                        AuthenticationContinue authenContinue = new AuthenticationContinue(header, bodyClear);
                        log.debug(CustomPIIMaskUtil.encrypt(authenContinue.toString()));
                        list.add(TacacsAuthenticationContinueReq.builder().authenticationContinue(authenContinue).nasIp(nasIp).tacacsKey(tacacsKey).build());
                        break;
                    }
                    log.warn("Unsupported tacacs-plus packet version: {}.", (Object)version);
                    ctx.channel().close();
                    return;
                }
                case AUTHOR: {
                    AuthorizationRequest authorRequest = new AuthorizationRequest(header, bodyClear);
                    log.debug(CustomPIIMaskUtil.encrypt(authorRequest.toString()));
                    this.setSingleConnectFlag(ctx, header);
                    list.add(TacacsAuthorizationReq.builder().authorizationRequest(authorRequest).nasIp(nasIp).tacacsKey(tacacsKey).build());
                    break;
                }
                default: {
                    log.warn("Unsupported tacacs-plus packet type: {}.", (Object)type);
                    ctx.channel().close();
                    break;
                }
            }
        }
        catch (TacacsPacketException e) {
            log.warn("TACACS+ packet exception: {}, connection with device: {} will be closed.", (Object)e.getMessage(), (Object)CustomPIIMaskUtil.encrypt(nasIp));
            ctx.channel().close();
        }
    }

    private void setSingleConnectFlag(ChannelHandlerContext ctx, TacacsHeader header) {
        String cacheKey = ctx.channel().id().asLongText();
        if (this.cacheService.get("tpas:aaa:tacacs:connect", cacheKey, Boolean.class) == null) {
            if (header.hasFlag(HeaderConstant.FlagsEnum.SINGLE_CONNECT)) {
                this.cacheService.set("tpas:aaa:tacacs:connect", cacheKey, (Object)Boolean.TRUE, 20L, TimeUnit.SECONDS);
            } else {
                this.cacheService.set("tpas:aaa:tacacs:connect", cacheKey, (Object)Boolean.FALSE, 20L, TimeUnit.SECONDS);
            }
        } else {
            this.cacheService.expireKey("tpas:aaa:tacacs:connect", cacheKey, 20L, TimeUnit.SECONDS);
        }
    }
}

