/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.server.core.handler.tacacs;

import com.tplink.cdd.component.aaa.server.core.TacacsAuthRequestHandlerOrder;
import com.tplink.cdd.component.aaa.server.core.service.TacacsAuthorizationInternalApiService;
import com.tplink.cdd.component.aaa.server.dto.tacacs.TacacsAuthorizationReq;
import com.tplink.cdd.component.aaa.server.utils.CustomPIIMaskUtil;
import com.tplink.cdd.components.aaa.tacacs.common.packet.reply.AuthorizationReply;
import com.tplink.cdd.components.aaa.tacacs.common.packet.request.AuthorizationRequest;
import com.tplink.smb.component.cache.api.CacheService;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ChannelHandler.Sharable
@TacacsAuthRequestHandlerOrder(order=70)
public class AuthorRequestHandler
extends SimpleChannelInboundHandler<TacacsAuthorizationReq> {
    private static final Logger log = LoggerFactory.getLogger(AuthorRequestHandler.class);
    @Autowired
    private TacacsAuthorizationInternalApiService tacacsAuthorizationInternalApiService;
    @Autowired
    private CacheService cacheService;

    protected void channelRead0(ChannelHandlerContext ctx, TacacsAuthorizationReq tacacsAuthorizationReq) throws Exception {
        AuthorizationRequest authorizationRequest = tacacsAuthorizationReq.getAuthorizationRequest();
        String nasIp = tacacsAuthorizationReq.getNasIp();
        Boolean singleConnect = (Boolean)this.cacheService.get("tpas:aaa:tacacs:connect", ctx.channel().id().asLongText(), Boolean.class);
        AuthorizationReply authorizationReply = this.tacacsAuthorizationInternalApiService.doHandler(authorizationRequest, nasIp);
        authorizationReply.setTacacsKey(tacacsAuthorizationReq.getTacacsKey());
        ctx.writeAndFlush((Object)authorizationReply);
        if (!Boolean.TRUE.equals(singleConnect)) {
            log.debug("Session completed and long connection not established, connection closed with {}.", (Object)CustomPIIMaskUtil.encrypt(nasIp));
            this.cacheService.deleteKey("tpas:aaa:tacacs:connect", ctx.channel().id().asLongText());
            ctx.channel().close();
        }
    }
}

