/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.server.core.handler.tacacs;

import com.tplink.cdd.component.aaa.core.authentication.config.AaaExtendServiceFactory;
import com.tplink.cdd.component.aaa.server.api.tacacs.TacacsExtendApiService;
import com.tplink.cdd.component.aaa.server.core.TacacsAuthRequestHandlerOrder;
import com.tplink.cdd.component.aaa.server.core.service.TacacsAuthenticationInternalApiService;
import com.tplink.cdd.component.aaa.server.dto.tacacs.TacacsAuthenticationStartReq;
import com.tplink.cdd.component.aaa.server.utils.CustomPIIMaskUtil;
import com.tplink.cdd.components.aaa.tacacs.common.packet.base.TacacsHeader;
import com.tplink.cdd.components.aaa.tacacs.common.packet.constant.ReplyConstant;
import com.tplink.cdd.components.aaa.tacacs.common.packet.constant.RequestConstant;
import com.tplink.cdd.components.aaa.tacacs.common.packet.reply.AuthenticationReply;
import com.tplink.cdd.components.aaa.tacacs.common.packet.request.AuthenticationStart;
import com.tplink.smb.component.cache.api.CacheService;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ChannelHandler.Sharable
@TacacsAuthRequestHandlerOrder(order=50)
public class AuthenStartHandler
extends SimpleChannelInboundHandler<TacacsAuthenticationStartReq> {
    private static final Logger log = LoggerFactory.getLogger(AuthenStartHandler.class);
    @Autowired
    private CacheService cacheService;
    @Autowired
    private TacacsAuthenticationInternalApiService tacacsAuthenticationInternalApiService;
    @Autowired
    private AaaExtendServiceFactory aaaExtendServiceFactory;

    protected void channelRead0(ChannelHandlerContext ctx, TacacsAuthenticationStartReq authenticationStartReq) throws Exception {
        AuthenticationStart authenStartPacket = authenticationStartReq.getAuthenticationStart();
        TacacsHeader replyHeader = authenStartPacket.getHeader().next();
        String nasIp = authenticationStartReq.getNasIp();
        String singleConnectCacheKey = ctx.channel().id().asLongText();
        Boolean singleConnect = (Boolean)this.cacheService.get("tpas:aaa:tacacs:connect", singleConnectCacheKey, Boolean.class);
        AuthenticationReply authenticationReply = new AuthenticationReply();
        authenticationReply.setTacacsKey(authenticationStartReq.getTacacsKey());
        authenticationReply.setTacacsHeader(replyHeader);
        authenticationReply.setFlags(ReplyConstant.FlagEnum.ECHO.getCode());
        authenticationReply.setStatus(ReplyConstant.AuthenStatusEnum.FOLLOW);
        TacacsExtendApiService tacacsExtendApiService = this.aaaExtendServiceFactory.getTacacsExtendApiServiceBean();
        RequestConstant.AuthenTypeEnum authenType = authenStartPacket.getAuthenType();
        if (authenStartPacket.getAction() != RequestConstant.ActionEnum.LOGIN) {
            authenticationReply.setServerMsg("Unsupported authentication action.");
            ctx.writeAndFlush((Object)authenticationReply);
            log.warn("Unsupported authentication type, connection with device: {} will be closed.", (Object)CustomPIIMaskUtil.encrypt(nasIp));
            if (!Objects.isNull(tacacsExtendApiService)) {
                tacacsExtendApiService.handle(nasIp, authenType.getMsg(), Boolean.FALSE);
            }
            if (!Boolean.TRUE.equals(singleConnect)) {
                log.debug("Session completed and long connection not established, connection closed with {}.", (Object)CustomPIIMaskUtil.encrypt(nasIp));
                this.cacheService.deleteKey("tpas:aaa:tacacs:connect", singleConnectCacheKey);
                ctx.channel().close();
            }
            return;
        }
        authenticationReply = this.tacacsAuthenticationInternalApiService.doAuthStartHandler(authenStartPacket, nasIp);
        authenticationReply.setTacacsKey(authenticationStartReq.getTacacsKey());
        ReplyConstant.AuthenStatusEnum status = authenticationReply.getStatus();
        ctx.writeAndFlush((Object)authenticationReply);
        if (status == ReplyConstant.AuthenStatusEnum.FOLLOW || status == ReplyConstant.AuthenStatusEnum.FAIL) {
            log.warn("Authentication failed, nasIp: {}.", (Object)CustomPIIMaskUtil.encrypt(nasIp));
            String sessionId = Integer.toString(replyHeader.getSessionId());
            String cacheKey = sessionId + nasIp;
            this.cacheService.deleteKey("tpas:aaa:tacacs:user", cacheKey);
            this.cacheService.deleteKey("tpas:aaa:tacacs:enable", cacheKey);
            if (!Objects.isNull(tacacsExtendApiService)) {
                tacacsExtendApiService.handle(nasIp, authenType.getMsg(), Boolean.FALSE);
            }
            if (!Boolean.TRUE.equals(singleConnect)) {
                log.debug("Session completed and long connection not established, connection closed with device: {}.", (Object)CustomPIIMaskUtil.encrypt(nasIp));
                this.cacheService.deleteKey("tpas:aaa:tacacs:connect", singleConnectCacheKey);
                ctx.channel().close();
            }
            return;
        }
        if (status == ReplyConstant.AuthenStatusEnum.PASS) {
            if (!Objects.isNull(tacacsExtendApiService)) {
                tacacsExtendApiService.handle(nasIp, authenType.getMsg(), Boolean.TRUE);
            }
            if (!Boolean.TRUE.equals(singleConnect)) {
                log.debug("Session completed and long connection not established, connection closed with {}.", (Object)CustomPIIMaskUtil.encrypt(nasIp));
                this.cacheService.deleteKey("tpas:aaa:tacacs:connect", singleConnectCacheKey);
                ctx.channel().close();
            }
        }
    }
}

