/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.server.core.handler.tacacs;

import com.tplink.cdd.component.aaa.core.authentication.config.AaaExtendServiceFactory;
import com.tplink.cdd.component.aaa.server.api.tacacs.TacacsExtendApiService;
import com.tplink.cdd.component.aaa.server.core.TacacsAuthRequestHandlerOrder;
import com.tplink.cdd.component.aaa.server.core.service.TacacsAuthenticationInternalApiService;
import com.tplink.cdd.component.aaa.server.dto.tacacs.TacacsAuthenticationContinueReq;
import com.tplink.cdd.component.aaa.server.utils.CustomPIIMaskUtil;
import com.tplink.cdd.components.aaa.tacacs.common.packet.base.TacacsHeader;
import com.tplink.cdd.components.aaa.tacacs.common.packet.constant.ReplyConstant;
import com.tplink.cdd.components.aaa.tacacs.common.packet.constant.RequestConstant;
import com.tplink.cdd.components.aaa.tacacs.common.packet.reply.AuthenticationReply;
import com.tplink.cdd.components.aaa.tacacs.common.packet.request.AuthenticationContinue;
import com.tplink.smb.component.cache.api.CacheService;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ChannelHandler.Sharable
@TacacsAuthRequestHandlerOrder(order=60)
public class AuthenContinueHandler
extends SimpleChannelInboundHandler<TacacsAuthenticationContinueReq> {
    private static final Logger log = LoggerFactory.getLogger(AuthenContinueHandler.class);
    @Autowired
    private CacheService cacheService;
    @Autowired
    private TacacsAuthenticationInternalApiService tacacsAuthenticationInternalApiService;
    @Autowired
    private AaaExtendServiceFactory aaaExtendServiceFactory;

    protected void channelRead0(ChannelHandlerContext ctx, TacacsAuthenticationContinueReq authenticationContinueReq) throws Exception {
        AuthenticationContinue authenticationContinue = authenticationContinueReq.getAuthenticationContinue();
        TacacsHeader header = authenticationContinue.getHeader();
        String sessionId = Integer.toString(header.getSessionId());
        String nasIp = authenticationContinueReq.getNasIp();
        String cacheKey = sessionId + nasIp;
        String singleConnectCacheKey = ctx.channel().id().asLongText();
        Boolean singleConnect = (Boolean)this.cacheService.get("tpas:aaa:tacacs:connect", singleConnectCacheKey, Boolean.class);
        TacacsExtendApiService tacacsExtendApiService = this.aaaExtendServiceFactory.getTacacsExtendApiServiceBean();
        if (authenticationContinue.getFlags() == RequestConstant.AuthenContinueFlagEnum.ABORT.getCode()) {
            log.warn("The client terminates authentication, nasIp: {}", (Object)CustomPIIMaskUtil.encrypt(nasIp));
            this.cacheService.deleteKey("tpas:aaa:tacacs:user", cacheKey);
            this.cacheService.deleteKey("tpas:aaa:tacacs:enable", cacheKey);
            if (!Objects.isNull(tacacsExtendApiService)) {
                tacacsExtendApiService.handle(nasIp, RequestConstant.AuthenTypeEnum.ASCII.getMsg(), Boolean.FALSE);
            }
            if (!Boolean.TRUE.equals(singleConnect)) {
                log.debug("Session completed and long connection not established, connection closed with {}.", (Object)CustomPIIMaskUtil.encrypt(nasIp));
                this.cacheService.deleteKey("tpas:aaa:tacacs:connect", singleConnectCacheKey);
                ctx.channel().close();
            }
            return;
        }
        AuthenticationReply authenticationReply = this.tacacsAuthenticationInternalApiService.doAuthContinueHandler(authenticationContinue, nasIp);
        authenticationReply.setTacacsKey(authenticationContinueReq.getTacacsKey());
        ctx.writeAndFlush((Object)authenticationReply);
        ReplyConstant.AuthenStatusEnum status = authenticationReply.getStatus();
        if (status == ReplyConstant.AuthenStatusEnum.FOLLOW || status == ReplyConstant.AuthenStatusEnum.FAIL) {
            log.warn("Authentication failed, nasIp: {}.", (Object)CustomPIIMaskUtil.encrypt(nasIp));
            this.cacheService.deleteKey("tpas:aaa:tacacs:user", cacheKey);
            this.cacheService.deleteKey("tpas:aaa:tacacs:enable", cacheKey);
            if (!Objects.isNull(tacacsExtendApiService)) {
                tacacsExtendApiService.handle(nasIp, RequestConstant.AuthenTypeEnum.ASCII.getMsg(), Boolean.FALSE);
            }
            if (!Boolean.TRUE.equals(singleConnect)) {
                log.debug("Session completed and long connection not established, connection closed with {}.", (Object)CustomPIIMaskUtil.encrypt(nasIp));
                this.cacheService.deleteKey("tpas:aaa:tacacs:connect", singleConnectCacheKey);
                ctx.channel().close();
            }
            return;
        }
        if (status == ReplyConstant.AuthenStatusEnum.PASS) {
            this.cacheService.deleteKey("tpas:aaa:tacacs:user", cacheKey);
            if (!Objects.isNull(tacacsExtendApiService)) {
                tacacsExtendApiService.handle(nasIp, RequestConstant.AuthenTypeEnum.ASCII.getMsg(), Boolean.TRUE);
            }
            if (!Boolean.TRUE.equals(singleConnect)) {
                log.debug("Session completed and long connection not established, connection closed with {}.", (Object)CustomPIIMaskUtil.encrypt(nasIp));
                this.cacheService.deleteKey("tpas:aaa:tacacs:connect", singleConnectCacheKey);
                ctx.channel().close();
            }
        }
    }
}

