/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.server.core.handler;

import com.tplink.cdd.component.aaa.server.api.RadiusApiService;
import com.tplink.cdd.component.aaa.server.config.AuthServerConfig;
import com.tplink.cdd.component.aaa.server.core.AuthRequestHandlerOrder;
import com.tplink.cdd.component.aaa.server.core.HandlerTypeEnum;
import com.tplink.cdd.component.aaa.server.dto.NasApiDTO;
import com.tplink.cdd.component.aaa.server.io.RadiusEndpoint;
import com.tplink.cdd.component.aaa.server.io.RequestCtx;
import com.tplink.cdd.component.aaa.server.io.ResponseCtx;
import com.tplink.cdd.component.aaa.server.utils.CustomPIIMaskUtil;
import com.tplink.cdd.component.aaa.utils.StringUtil;
import com.tplink.cdd.radius.common.RadiusPacketException;
import com.tplink.cdd.radius.common.dictionary.Dictionary;
import com.tplink.cdd.radius.common.packet.request.RadiusRequest;
import com.tplink.cdd.radius.common.packet.response.RadiusResponse;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.MessageToMessageCodec;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.util.StringUtils;

@ChannelHandler.Sharable
@AuthRequestHandlerOrder(order=30, type=HandlerTypeEnum.RADIUS_ACCESS_ACCOUNTING)
public class ServerPacketCodec
extends MessageToMessageCodec<DatagramPacket, ResponseCtx> {
    private static final Logger log = LoggerFactory.getLogger(ServerPacketCodec.class);
    @Autowired
    @Qualifier(value="radius-default-dictionary")
    private Dictionary dictionary;
    @Autowired
    private RadiusApiService radiusApiService;
    @Autowired
    private AuthServerConfig authServerConfig;

    protected void encode(ChannelHandlerContext ctx, ResponseCtx msg, List<Object> out) {
        try {
            DatagramPacket datagramPacket = new DatagramPacket(msg.getResponse().encodeResponse(msg.getEndpoint().getSecret(), msg.getRequest().getAuthenticator()).toByteBuf(), msg.getEndpoint().getAddress(), (InetSocketAddress)ctx.channel().localAddress());
            log.debug("Sending packet to {}", (Object)CustomPIIMaskUtil.encrypt(msg.getEndpoint().getAddress().toString()));
            log.debug("------ ServerPacketCodec encode ------");
            log.debug("Sending response packet as following :");
            log.debug("{}", (Object)CustomPIIMaskUtil.encrypt(msg.getResponse().toString()));
            out.add(datagramPacket);
        }
        catch (RadiusPacketException e) {
            log.warn("Could not serialize packet: {}", (Object)e.getMessage());
        }
    }

    protected void decode(ChannelHandlerContext ctx, DatagramPacket msg, List<Object> out) {
        String sharedSecretKey;
        RadiusRequest request;
        log.debug("++++++ {} ++++++", (Object)msg.toString());
        InetSocketAddress remoteAddress = (InetSocketAddress)msg.sender();
        try {
            request = RadiusRequest.fromDatagram((Dictionary)this.dictionary, (DatagramPacket)msg);
            log.debug("Received request packet as following :");
            log.debug("{}", (Object)CustomPIIMaskUtil.encrypt(request.toString()));
            Optional<NasApiDTO> optionalNasApiDTO = this.radiusApiService.getNasInfo(remoteAddress, request);
            if (!optionalNasApiDTO.isPresent()) {
                throw new RadiusPacketException("Nas info lookup failed");
            }
            sharedSecretKey = !StringUtil.isEmpty(optionalNasApiDTO.get().getSecretKey()) ? optionalNasApiDTO.get().getSecretKey() : this.authServerConfig.getRadiusSecretKey();
            if (StringUtils.isEmpty((Object)sharedSecretKey)) {
                throw new RadiusPacketException("radius shared key not found.");
            }
        }
        catch (RadiusPacketException e) {
            log.warn("Could not deserialize packet: {}. Dropping packet without response", (Object)e.getMessage());
            return;
        }
        try {
            out.add(new RequestCtx(request.decodeRequest(sharedSecretKey), new RadiusEndpoint(remoteAddress, sharedSecretKey), sharedSecretKey));
        }
        catch (RadiusPacketException e) {
            log.warn("Could not parse user info, msg = {}", (Object)e.getMessage());
            ctx.writeAndFlush((Object)this.defaultReject(ctx, remoteAddress, request, sharedSecretKey));
        }
    }

    private DatagramPacket defaultReject(ChannelHandlerContext ctx, InetSocketAddress remoteAddress, RadiusRequest radiusRequest, String sharedSecretKey) {
        try {
            byte[] reqAuth = radiusRequest.getAuthenticator();
            RadiusResponse tmpResp = RadiusResponse.create((Dictionary)radiusRequest.getDictionary(), (byte)3, (byte)radiusRequest.getId(), (byte[])reqAuth, Collections.emptyList());
            ByteBuf finalResp = tmpResp.encodeResponse(sharedSecretKey, reqAuth).toByteBuf();
            return new DatagramPacket(finalResp, remoteAddress, (InetSocketAddress)ctx.channel().localAddress());
        }
        catch (RadiusPacketException e) {
            log.error("Unexpect exception caught when build default RADIUS reject packet!", (Throwable)e);
            return null;
        }
    }
}

