/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.server.core.handler;

import com.tplink.cdd.component.aaa.server.io.RequestCtx;
import com.tplink.cdd.radius.common.packet.request.RadiusRequest;
import io.netty.channel.SimpleChannelInboundHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RequestHandler
extends SimpleChannelInboundHandler<RequestCtx> {
    private static final Logger log = LoggerFactory.getLogger(RequestHandler.class);

    protected abstract Class<? extends RadiusRequest> acceptedPacketType();

    public boolean acceptInboundMessage(Object msg) throws Exception {
        boolean acceptInboundMessage = super.acceptInboundMessage(msg);
        if (!acceptInboundMessage) {
            return false;
        }
        RadiusRequest request = ((RequestCtx)msg).getRequest();
        if (this.acceptedPacketType().isInstance(request)) {
            return true;
        }
        log.debug("Ignoring {} received - handler only accepts {} packets", (Object)request.getClass().getSimpleName(), (Object)this.acceptedPacketType().getSimpleName());
        return false;
    }
}

