/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.server.core.handler;

import com.tplink.cdd.component.aaa.core.accounting.dto.AccountingInfoDTO;
import com.tplink.cdd.component.aaa.core.authentication.config.AaaExtendServiceFactory;
import com.tplink.cdd.component.aaa.core.enums.RadiusAccountingPacketType;
import com.tplink.cdd.component.aaa.core.enums.RadiusAccountingStatusType;
import com.tplink.cdd.component.aaa.server.api.RadiusAccountingHandler;
import com.tplink.cdd.component.aaa.server.api.extend.AccountingExtendApiService;
import com.tplink.cdd.component.aaa.server.core.AuthRequestHandlerOrder;
import com.tplink.cdd.component.aaa.server.core.HandlerTypeEnum;
import com.tplink.cdd.component.aaa.server.core.handler.RequestHandler;
import com.tplink.cdd.component.aaa.server.io.RequestCtx;
import com.tplink.cdd.radius.common.dictionary.Dictionary;
import com.tplink.cdd.radius.common.packet.request.AccountingRequest;
import com.tplink.cdd.radius.common.packet.request.RadiusRequest;
import com.tplink.cdd.radius.common.packet.response.RadiusResponse;
import com.tplink.nbu.common.utils.JacksonUtil;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ChannelHandler.Sharable
@AuthRequestHandlerOrder(order=60, type=HandlerTypeEnum.RADIUS_ACCOUNTING)
public class AccountingRequestHandler
extends RequestHandler {
    private static final Logger log = LoggerFactory.getLogger(AccountingRequestHandler.class);
    @Autowired
    @Qualifier(value="radiusAccountingHandler")
    private Map<RadiusAccountingStatusType, RadiusAccountingHandler> invokes;
    @Autowired
    private AaaExtendServiceFactory aaaExtendServiceFactory;

    @Override
    protected Class<? extends RadiusRequest> acceptedPacketType() {
        return AccountingRequest.class;
    }

    protected void channelRead0(ChannelHandlerContext ctx, RequestCtx msg) throws Exception {
        AccountingInfoDTO accountingInfoDTO;
        log.debug("------ AccountingRequestHandler Start ------");
        AccountingRequest request = (AccountingRequest)msg.getRequest();
        AccountingInfoDTO accountingInfoExtendDTO = accountingInfoDTO = AccountingInfoDTO.builder().accountingPacketInfoDTO(this.getAccountingPacketInfoDTO(request)).build();
        AccountingExtendApiService accountingExtendApiService = this.aaaExtendServiceFactory.getAccountingExtendServiceBean();
        if (!Objects.isNull(accountingExtendApiService)) {
            accountingInfoExtendDTO = accountingExtendApiService.extendAccountingInfo(accountingInfoDTO, msg);
        }
        log.info("Accounting request. accountingInfoDTO {}. ", (Object)JacksonUtil.parseToStr((Object)accountingInfoDTO));
        RadiusAccountingHandler handler = this.invokes.get((Object)accountingInfoDTO.getAccountingPacketInfoDTO().getAcctStatusType());
        try {
            handler.process(accountingInfoExtendDTO, request);
        }
        catch (RuntimeException e) {
            log.warn("process failed. Because AccountingManageException", (Throwable)e);
        }
        catch (Exception e) {
            log.warn("process failed. Because Exception", (Throwable)e);
        }
        RadiusResponse response = RadiusResponse.create((Dictionary)request.getDictionary(), (byte)5, (byte)request.getId(), null, (List)request.filterAttributes(33));
        log.info("Accounting start to write to client : {}", (Object)response);
        ctx.writeAndFlush((Object)msg.withResponse(response));
        log.debug("------ AccountingHandler End ------");
    }

    private AccountingInfoDTO.AccountingPacketInfoDTO getAccountingPacketInfoDTO(AccountingRequest request) {
        AccountingInfoDTO.AccountingPacketInfoDTO dto = new AccountingInfoDTO.AccountingPacketInfoDTO();
        request.getAttribute(RadiusAccountingPacketType.ACCT_SESSION_ID.getIndex().intValue()).ifPresent(radiusAttribute -> dto.setAcctSessionId(radiusAttribute.getValueString()));
        request.getAttribute(RadiusAccountingPacketType.ACCT_STATUS_TYPE.getIndex().intValue()).ifPresent(radiusAttribute -> dto.setAcctStatusType(RadiusAccountingStatusType.findByValue(radiusAttribute.getValueString())));
        request.getAttribute(RadiusAccountingPacketType.ACCT_SESSION_TIME.getIndex().intValue()).ifPresent(radiusAttribute -> dto.setAcctSessionTime(Long.parseLong(radiusAttribute.getValueString())));
        request.getAttribute(RadiusAccountingPacketType.ACCT_INPUT_OCTETS.getIndex().intValue()).ifPresent(radiusAttribute -> dto.setAcctInputOctets(Long.parseLong(radiusAttribute.getValueString())));
        request.getAttribute(RadiusAccountingPacketType.ACCT_OUTPUT_OCTETS.getIndex().intValue()).ifPresent(radiusAttribute -> dto.setAcctOutputOctets(Long.parseLong(radiusAttribute.getValueString())));
        request.getAttribute(RadiusAccountingPacketType.ACCT_INPUT_PACKETS.getIndex().intValue()).ifPresent(radiusAttribute -> dto.setAcctInputPackets(Long.parseLong(radiusAttribute.getValueString())));
        request.getAttribute(RadiusAccountingPacketType.ACCT_OUTPUT_PACKETS.getIndex().intValue()).ifPresent(radiusAttribute -> dto.setAcctOutputPackets(Long.parseLong(radiusAttribute.getValueString())));
        return dto;
    }
}

