/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.server.core.handler;

import com.tplink.cdd.component.aaa.core.authentication.config.AaaExtendServiceFactory;
import com.tplink.cdd.component.aaa.core.authentication.dto.AuthResp;
import com.tplink.cdd.component.aaa.core.authentication.service.handler.RadiusAuthHandler;
import com.tplink.cdd.component.aaa.server.api.RadiusApiService;
import com.tplink.cdd.component.aaa.server.api.extend.ResponseHandleApiService;
import com.tplink.cdd.component.aaa.server.core.AuthRequestHandlerOrder;
import com.tplink.cdd.component.aaa.server.core.HandlerTypeEnum;
import com.tplink.cdd.component.aaa.server.core.handler.RequestHandler;
import com.tplink.cdd.component.aaa.server.dto.AddAttAfterAcceptReq;
import com.tplink.cdd.component.aaa.server.dto.AttributeApiDTO;
import com.tplink.cdd.component.aaa.server.dto.NasApiDTO;
import com.tplink.cdd.component.aaa.server.dto.RadiusAttributeApiDTO;
import com.tplink.cdd.component.aaa.server.dto.VendorSpecificAttributeApiDTO;
import com.tplink.cdd.component.aaa.server.io.RequestCtx;
import com.tplink.cdd.component.aaa.server.utils.AccessResponseUtil;
import com.tplink.cdd.component.aaa.server.utils.CustomPIIMaskUtil;
import com.tplink.cdd.radius.common.attribute.type.OctetsAttribute;
import com.tplink.cdd.radius.common.attribute.type.RadiusAttribute;
import com.tplink.cdd.radius.common.enums.AuthType;
import com.tplink.cdd.radius.common.enums.RadiusAuthPacketType;
import com.tplink.cdd.radius.common.enums.RadiusAvp;
import com.tplink.cdd.radius.common.enums.UserAuthCategory;
import com.tplink.cdd.radius.common.packet.request.AccessRequest;
import com.tplink.cdd.radius.common.packet.request.RadiusRequest;
import com.tplink.cdd.radius.common.packet.response.AccessResponse;
import com.tplink.cdd.radius.common.packet.response.RadiusResponse;
import com.tplink.cdd.radius.common.utils.RadiusAttributeUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.util.CollectionUtils;

@ChannelHandler.Sharable
@AuthRequestHandlerOrder(order=60, type=HandlerTypeEnum.RADIUS_ACCESS)
public class AccessRequestHandler
extends RequestHandler {
    private static final Logger log = LoggerFactory.getLogger(AccessRequestHandler.class);
    @Autowired
    @Qualifier(value="radiusAuthDispatcher")
    private Map<UserAuthCategory, RadiusAuthHandler> radiusAuthDispatcher;
    @Autowired
    private RadiusApiService radiusApiService;
    @Autowired
    private AaaExtendServiceFactory aaaExtendServiceFactory;

    @Override
    protected Class<? extends RadiusRequest> acceptedPacketType() {
        return AccessRequest.class;
    }

    protected void channelRead0(ChannelHandlerContext ctx, RequestCtx msg) {
        AccessResponse accessResponse;
        log.debug("------ AccessRequestHandler Start ------");
        AccessRequest accessRequest = (AccessRequest)msg.getRequest();
        RadiusAuthPacketType radiusAuthPacketType = RadiusAuthPacketType.fromAccessRequest((AccessRequest)accessRequest);
        UserAuthCategory userAuthCategory = null;
        AuthResp authResp = null;
        if (Objects.isNull(radiusAuthPacketType)) {
            log.error("Catch unknown access request : {}", (Object)accessRequest.getClass().getSimpleName());
            accessResponse = AccessResponseUtil.reject(accessRequest);
        } else {
            InetSocketAddress remoteAddress = msg.getEndpoint().getAddress();
            Optional<NasApiDTO> optionalNasApiDTO = this.radiusApiService.getNasInfo(remoteAddress, (RadiusRequest)accessRequest);
            if (!optionalNasApiDTO.isPresent()) {
                log.info("Not found device: {}", (Object)CustomPIIMaskUtil.hash(RadiusAttributeUtil.nasId((RadiusRequest)msg.getRequest())));
                log.debug("------ AccessRequestHandler End ------");
                accessResponse = AccessResponseUtil.reject(accessRequest);
            } else {
                NasApiDTO nasApiDTO = optionalNasApiDTO.get();
                AuthType authType = nasApiDTO.getAuthType();
                userAuthCategory = UserAuthCategory.of((RadiusAuthPacketType)radiusAuthPacketType, (AuthType)authType);
                authResp = this.radiusAuthDispatcher.get(userAuthCategory).process(msg);
                accessResponse = authResp.getAccessResponse();
                accessResponse.setUserAuthCategory(userAuthCategory);
            }
        }
        ResponseHandleApiService responseHandleApiService = this.aaaExtendServiceFactory.getModifyAttributeApiServiceBean();
        if (!Objects.isNull(responseHandleApiService)) {
            responseHandleApiService.handleAccessResponse(msg, userAuthCategory, accessResponse);
            if (accessResponse instanceof AccessResponse.Accept) {
                AttributeApiDTO attributeApiDTO;
                AddAttAfterAcceptReq addAttAfterAcceptReq = new AddAttAfterAcceptReq();
                addAttAfterAcceptReq.setUserAuthCategory(userAuthCategory);
                if (authResp != null) {
                    addAttAfterAcceptReq.setPpskUserName(authResp.getPpskUserName());
                    addAttAfterAcceptReq.setPpskPassword(authResp.getPpskPassword());
                }
                if (Objects.isNull(attributeApiDTO = responseHandleApiService.addAttAfterAccept(msg, addAttAfterAcceptReq))) {
                    return;
                }
                if (!CollectionUtils.isEmpty(attributeApiDTO.getVendorSpecificAttributeApiDTO())) {
                    accessResponse.getAttributes().addAll(this.fromVendorAttributeApiDTO(attributeApiDTO.getVendorSpecificAttributeApiDTO(), accessResponse));
                }
                if (!CollectionUtils.isEmpty(attributeApiDTO.getRadiusAttributeApiDTO())) {
                    accessResponse.getAttributes().addAll(this.fromAttributeApiDTO(attributeApiDTO.getRadiusAttributeApiDTO(), accessResponse));
                }
            }
        }
        ctx.writeAndFlush((Object)msg.withResponse((RadiusResponse)accessResponse));
        log.debug("------ AccessRequestHandler End ------");
    }

    private List<RadiusAttribute> fromVendorAttributeApiDTO(List<VendorSpecificAttributeApiDTO> vendorSpecificAttributeApiDTOS, AccessResponse accessResponse) {
        ArrayList<RadiusAttribute> radiusAttributes = new ArrayList<RadiusAttribute>();
        vendorSpecificAttributeApiDTOS.forEach(vendorSpecificAttributeApiDTO -> {
            OctetsAttribute octetsAttribute = new OctetsAttribute(accessResponse.getDictionary(), vendorSpecificAttributeApiDTO.getVendorId().intValue(), Unpooled.buffer().writeByte(RadiusAvp.VENDOR_SPECIFIC.getIndex()).writeByte(vendorSpecificAttributeApiDTO.getData().readableBytes() + 8).writeInt(vendorSpecificAttributeApiDTO.getVendorId().intValue()).writeByte(vendorSpecificAttributeApiDTO.getType().intValue()).writeByte(vendorSpecificAttributeApiDTO.getData().readableBytes() + 2).writeBytes(vendorSpecificAttributeApiDTO.getData()));
            radiusAttributes.add((RadiusAttribute)octetsAttribute);
        });
        return radiusAttributes;
    }

    private List<RadiusAttribute> fromAttributeApiDTO(List<RadiusAttributeApiDTO> attributeApiDTOS, AccessResponse accessResponse) {
        ArrayList<RadiusAttribute> radiusAttributes = new ArrayList<RadiusAttribute>();
        attributeApiDTOS.forEach(radiusAttributeApiDTO -> {
            OctetsAttribute octetsAttribute = new OctetsAttribute(accessResponse.getDictionary(), -1, Unpooled.buffer().writeByte(radiusAttributeApiDTO.getType().intValue()).writeByte(radiusAttributeApiDTO.getValue().readableBytes() + 2).writeBytes(radiusAttributeApiDTO.getValue()));
            radiusAttributes.add((RadiusAttribute)octetsAttribute);
        });
        return radiusAttributes;
    }
}

