/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.server.core;

import com.tplink.cdd.component.aaa.core.authentication.utils.VendorSpecificAttributeUtil;
import com.tplink.cdd.component.aaa.server.api.coa.CoaService;
import com.tplink.cdd.component.aaa.server.dto.CoaResultApiDTO;
import com.tplink.cdd.component.aaa.server.dto.TrafficControlApiDTO;
import com.tplink.cdd.component.aaa.server.utils.SendRequestUtil;
import com.tplink.cdd.radius.common.attribute.type.RadiusAttribute;
import com.tplink.cdd.radius.common.attribute.type.VendorSpecificAttributeType;
import com.tplink.cdd.radius.common.dictionary.DefaultDictionary;
import com.tplink.cdd.radius.common.dictionary.Dictionary;
import com.tplink.cdd.radius.common.enums.RadiusAvp;
import com.tplink.cdd.radius.common.enums.error.CoaErrorCause;
import com.tplink.cdd.radius.common.packet.RadiusPacket;
import com.tplink.cdd.radius.common.packet.request.CoaRequest;
import com.tplink.cdd.radius.common.packet.request.RadiusRequest;
import com.tplink.cdd.radius.common.packet.response.RadiusResponse;
import com.tplink.cdd.radius.common.utils.CoaIdUtil;
import io.netty.buffer.ByteBuf;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class CoaServiceImpl
implements CoaService {
    private static final Logger log = LoggerFactory.getLogger(CoaServiceImpl.class);
    private static final String NO_RESPONSE = "CoA failed, No response received";
    private static final String WRONG_RESPONSE = "CoA failed, wrong response received";
    private static final String COA_SUCCESS = "CoA success";
    private static final String COA_FAIL = "CoA fail";
    private static final Dictionary dictionary = DefaultDictionary.INSTANCE;

    @Override
    public CoaResultApiDTO sendCoaRequest(String ipAddress, int port, String sharedSecret, List<RadiusAttribute> attributeList) {
        try {
            InetSocketAddress address = new InetSocketAddress(ipAddress, port);
            ByteBuf header = RadiusPacket.buildHeader((byte)43, (byte)CoaIdUtil.genCoaId(), (byte[])new byte[16], attributeList);
            CoaRequest coaRequest = new CoaRequest(dictionary, header, attributeList);
            RadiusResponse radiusResponse = SendRequestUtil.startClientAndSend((RadiusRequest)coaRequest, address, sharedSecret);
            return this.checkCoaResponse(radiusResponse);
        }
        catch (Exception e) {
            log.warn("CoA Request send failed, message is {}", (Object)e.getMessage());
            return CoaResultApiDTO.builder().isSuccess(false).returnMessage(COA_FAIL).build();
        }
    }

    @Override
    public CoaResultApiDTO sendTrafficCoaRequest(String ipAddress, int port, String sharedSecret, TrafficControlApiDTO trafficControlApiDTO) {
        try {
            InetSocketAddress address = new InetSocketAddress(ipAddress, port);
            ArrayList<RadiusAttribute> attributeList = new ArrayList<RadiusAttribute>();
            if (!Objects.isNull(trafficControlApiDTO.getUserName())) {
                RadiusAttribute username = dictionary.createAttribute(-1, RadiusAvp.USER_NAME.getIndex(), trafficControlApiDTO.getUserName());
                attributeList.add(username);
            }
            if (!Objects.isNull(trafficControlApiDTO.getAcctSessionId())) {
                RadiusAttribute acctSessionId = dictionary.createAttribute(-1, RadiusAvp.ACCT_SESSION_ID.getIndex(), trafficControlApiDTO.getAcctSessionId());
                attributeList.add(acctSessionId);
            }
            if (!Objects.isNull(trafficControlApiDTO.getSessionTimeout())) {
                RadiusAttribute sessionTimeout = dictionary.createAttribute(-1, RadiusAvp.SESSION_TIMEOUT.getIndex(), String.valueOf(trafficControlApiDTO.getSessionTimeout()));
                attributeList.add(sessionTimeout);
            }
            ByteBuf header = RadiusPacket.buildHeader((byte)43, (byte)CoaIdUtil.genCoaId(), (byte[])new byte[16], attributeList);
            CoaRequest coaRequest = new CoaRequest(dictionary, header, attributeList);
            if (!Objects.isNull(trafficControlApiDTO.getTrafficLimit())) {
                RadiusAttribute trafficLimit = VendorSpecificAttributeUtil.buildVendorSpecificAttribute(VendorSpecificAttributeType.TPLINK_TRAFFIC_LIMIT, trafficControlApiDTO.getTrafficLimit());
                coaRequest = (RadiusRequest)coaRequest.addAttribute(trafficLimit);
            }
            if (!Objects.isNull(trafficControlApiDTO.getMaxUp())) {
                RadiusAttribute maxUp = VendorSpecificAttributeUtil.buildVendorSpecificAttribute(VendorSpecificAttributeType.WISPR_BANDWIDTH_MAX_UP, trafficControlApiDTO.getMaxUp());
                coaRequest = (RadiusRequest)coaRequest.addAttribute(maxUp);
            }
            if (!Objects.isNull(trafficControlApiDTO.getMaxDown())) {
                RadiusAttribute maxDown = VendorSpecificAttributeUtil.buildVendorSpecificAttribute(VendorSpecificAttributeType.WISPR_BANDWIDTH_MAX_DOWN, trafficControlApiDTO.getMaxDown());
                coaRequest = (RadiusRequest)coaRequest.addAttribute(maxDown);
            }
            RadiusResponse radiusResponse = SendRequestUtil.startClientAndSend((RadiusRequest)coaRequest, address, sharedSecret);
            return this.checkCoaResponse(radiusResponse);
        }
        catch (Exception e) {
            log.warn("CoA Request send failed, message is {}", (Object)e.getMessage());
            return CoaResultApiDTO.builder().isSuccess(false).returnMessage(COA_FAIL).build();
        }
    }

    private CoaResultApiDTO checkCoaResponse(RadiusResponse response) {
        if (Objects.isNull(response)) {
            return CoaResultApiDTO.builder().isSuccess(false).returnMessage(NO_RESPONSE).build();
        }
        if (Objects.equals(response.getType(), (byte)44)) {
            return CoaResultApiDTO.builder().isSuccess(true).returnMessage(COA_SUCCESS).build();
        }
        if (Objects.equals(response.getType(), (byte)45)) {
            List list = response.filterAttributes(RadiusAvp.ERROR_CAUSE.getIndex());
            if (CollectionUtils.isEmpty((Collection)list)) {
                return CoaResultApiDTO.builder().isSuccess(false).returnMessage(COA_FAIL).build();
            }
            String errorCauseMes = CoaErrorCause.parseByVal((Integer)ByteBuffer.wrap(((RadiusAttribute)list.get(0)).getValue()).getInt()).getMessage();
            return CoaResultApiDTO.builder().isSuccess(false).returnMessage(errorCauseMes).build();
        }
        if (log.isWarnEnabled()) {
            log.warn("wrong coa response received, the packet type is {}", (Object)response.getType());
        }
        return CoaResultApiDTO.builder().isSuccess(false).returnMessage(WRONG_RESPONSE).build();
    }
}

