/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.server.core;

import com.tplink.cdd.component.aaa.core.authentication.utils.UserCacheUtils;
import com.tplink.cdd.component.aaa.server.api.AuthServerService;
import com.tplink.cdd.component.aaa.server.config.AuthServerConfig;
import com.tplink.cdd.component.aaa.server.config.TacacsServerConfig;
import com.tplink.cdd.component.aaa.server.core.AuthRequestHandlerOrder;
import com.tplink.cdd.component.aaa.server.core.ContextAuthHandlerListener;
import com.tplink.cdd.component.aaa.server.core.ContextTacacsHandlerListener;
import com.tplink.cdd.component.aaa.server.core.HandlerTypeEnum;
import com.tplink.cdd.component.aaa.server.core.TacacsAuthRequestHandlerOrder;
import com.tplink.cdd.component.aaa.server.enums.RadiusServerType;
import com.tplink.cdd.component.aaa.server.io.RadiusServer;
import com.tplink.cdd.component.aaa.server.io.TacacsServer;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.SocketChannel;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class AuthServerServiceImpl
implements AuthServerService {
    private static final Logger log = LoggerFactory.getLogger(AuthServerServiceImpl.class);
    private static Map<RadiusServerType, RadiusServer> radiusServerMap = new HashMap<RadiusServerType, RadiusServer>();
    private TacacsServer tacacsServer;
    @Autowired
    private AuthServerConfig authServerConfig;
    @Autowired
    private TacacsServerConfig tacacsServerConfig;
    @Autowired
    private UserCacheUtils userCacheUtils;

    @Override
    public synchronized void startRadiusServer(RadiusServerType radiusServerType) {
        if (this.checkRadiusServerStatus(radiusServerType)) {
            log.info("Radius server has started, type: {}.", (Object)radiusServerType.name());
            return;
        }
        int nioEventLoopGroupThreadNum = 4;
        List<ChannelHandler> handlers = ContextAuthHandlerListener.authRequestHandlerBeans;
        final TreeMap orderHandlers = new TreeMap();
        switch (radiusServerType) {
            case ACCESS: {
                int port = this.authServerConfig.getRadiusAuthPort();
                handlers.forEach(handler -> {
                    AuthRequestHandlerOrder annotation = handler.getClass().getDeclaredAnnotation(AuthRequestHandlerOrder.class);
                    if (HandlerTypeEnum.RADIUS_ACCESS_ACCOUNTING.equals((Object)annotation.type()) || HandlerTypeEnum.RADIUS_ACCESS.equals((Object)annotation.type())) {
                        orderHandlers.put(annotation.order(), handler);
                    }
                });
                log.debug("Access add handler size: {}", (Object)orderHandlers.size());
                log.info("Start to init radius-server, type = {}, access-port = {}, event-loop-group-thread-num = {}", new Object[]{radiusServerType.name(), port, nioEventLoopGroupThreadNum});
                radiusServerMap.put(radiusServerType, new RadiusServer(nioEventLoopGroupThreadNum, (ChannelHandler)new ChannelInitializer<DatagramChannel>(){

                    protected void initChannel(DatagramChannel ch) {
                        ChannelPipeline pipeline = ch.pipeline();
                        orderHandlers.values().forEach(xva$0 -> pipeline.addLast(new ChannelHandler[]{xva$0}));
                    }
                }, new InetSocketAddress(port)));
                break;
            }
            case ACCOUNTING: {
                int port = this.authServerConfig.getRadiusAccountingPort();
                handlers.forEach(handler -> {
                    AuthRequestHandlerOrder annotation = handler.getClass().getDeclaredAnnotation(AuthRequestHandlerOrder.class);
                    if (HandlerTypeEnum.RADIUS_ACCESS_ACCOUNTING.equals((Object)annotation.type()) || HandlerTypeEnum.RADIUS_ACCOUNTING.equals((Object)annotation.type())) {
                        orderHandlers.put(annotation.order(), handler);
                    }
                });
                log.debug("Accounting add handler size: {}", (Object)orderHandlers.size());
                log.info("Start to init radius-server, type = {}, accounting-port = {}, event-loop-group-thread-num = {}", new Object[]{radiusServerType.name(), port, nioEventLoopGroupThreadNum});
                radiusServerMap.put(radiusServerType, new RadiusServer(nioEventLoopGroupThreadNum, (ChannelHandler)new ChannelInitializer<DatagramChannel>(){

                    protected void initChannel(DatagramChannel ch) {
                        ChannelPipeline pipeline = ch.pipeline();
                        orderHandlers.values().forEach(xva$0 -> pipeline.addLast(new ChannelHandler[]{xva$0}));
                    }
                }, new InetSocketAddress(port)));
                break;
            }
            default: {
                throw new RuntimeException("radius server type is invalid");
            }
        }
    }

    @Override
    public void stopRadiusServer(RadiusServerType radiusServerType) {
        if (!this.checkRadiusServerStatus(radiusServerType)) {
            log.info("Radius server has stop, type: {}.", (Object)radiusServerType.name());
            return;
        }
        log.info("Radius server stop, type: {}.", (Object)radiusServerType.name());
        radiusServerMap.get((Object)radiusServerType).close();
    }

    @Override
    public boolean checkRadiusServerStatus(RadiusServerType radiusServerType) {
        if (CollectionUtils.isEmpty(radiusServerMap) || Objects.isNull(radiusServerMap.get((Object)radiusServerType))) {
            return false;
        }
        return radiusServerMap.get((Object)radiusServerType).checkStatus();
    }

    @Override
    public void configureRadiusServer(@NonNull Integer authPort, @NonNull Integer accountingPort, String secretKey) {
        if (authPort == null) {
            throw new NullPointerException("authPort is marked non-null but is null");
        }
        if (accountingPort == null) {
            throw new NullPointerException("accountingPort is marked non-null but is null");
        }
        this.authServerConfig.setRadiusAuthPort(authPort);
        this.authServerConfig.setRadiusAccountingPort(accountingPort);
        this.authServerConfig.setRadiusSecretKey(secretKey);
    }

    @Override
    public synchronized void startTacacsServer() {
        if (this.checkTacacsServerStatus()) {
            log.info("TACACS+ server has started.");
            return;
        }
        List<ChannelHandler> handlers = ContextTacacsHandlerListener.getAuthRequestHandlerBeans();
        log.debug("Tacacs add handler size: {}", (Object)handlers.size());
        log.info("Start to init tacacs-server, access-port = {}, event-loop-group-thread-num = {}", (Object)this.tacacsServerConfig.getTacacsPort(), (Object)this.tacacsServerConfig.getNioEventLoopGroupThreadNum());
        this.tacacsServer = new TacacsServer(this.tacacsServerConfig.getNioEventLoopGroupThreadNum(), (ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel socketChannel) {
                ChannelPipeline cp = socketChannel.pipeline();
                List<ChannelHandler> handlersNew = ContextTacacsHandlerListener.getAuthRequestHandlerBeans();
                TreeMap orderHandlers = new TreeMap();
                handlersNew.forEach(handler -> {
                    TacacsAuthRequestHandlerOrder annotation = handler.getClass().getDeclaredAnnotation(TacacsAuthRequestHandlerOrder.class);
                    orderHandlers.put(annotation.order(), handler);
                });
                orderHandlers.values().forEach(xva$0 -> cp.addLast(new ChannelHandler[]{xva$0}));
            }
        }, new InetSocketAddress(this.tacacsServerConfig.getTacacsPort()));
    }

    @Override
    public void stopTacacsServer() {
        if (!this.checkTacacsServerStatus()) {
            log.info("TACACS+ server has stop.");
            return;
        }
        log.info("TACACS+ server stop.");
        this.tacacsServer.close();
    }

    @Override
    public boolean checkTacacsServerStatus() {
        if (Objects.isNull(this.tacacsServer)) {
            return false;
        }
        return this.tacacsServer.checkStatus();
    }

    @Override
    public void configureTacacsServer(Integer port, String secretKey, Integer nioEventLoopGroupThreadNum) {
        if (!Objects.isNull(port) && port > 0) {
            this.tacacsServerConfig.setTacacsPort(port);
        }
        if (!StringUtils.isEmpty((Object)secretKey)) {
            this.tacacsServerConfig.setSecretKey(secretKey);
        }
        if (!Objects.isNull(nioEventLoopGroupThreadNum) && nioEventLoopGroupThreadNum > 0) {
            this.tacacsServerConfig.setNioEventLoopGroupThreadNum(nioEventLoopGroupThreadNum);
        }
    }
}

