/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.core.enums;

import com.tplink.cdd.component.aaa.utils.StringUtils;
import com.tplink.cdd.radius.common.enums.error.ResponseCode;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum RadiusAccountingStatusType {
    START(1, "Start"),
    STOP(2, "Stop"),
    INTERIM_UPDATE(3, "Interim-Update"),
    ACCOUNTING_ON(7, "Accounting-On"),
    ACCOUNTING_OFF(8, "Accounting-Off");

    private static final Logger log;
    private final Integer index;
    private final String value;

    public static RadiusAccountingStatusType findByIndex(Integer index) {
        if (index == null) {
            log.warn("findByIndex failed. index is null");
            throw new RuntimeException(ResponseCode.ACCOUNTING_PARAMETER_IS_NULL.getMsg());
        }
        for (RadiusAccountingStatusType value : RadiusAccountingStatusType.values()) {
            if (!Objects.equals(value.getIndex(), index)) continue;
            return value;
        }
        log.warn("findByIndex not match. {}", (Object)index);
        throw new RuntimeException(ResponseCode.ACCOUNTING_ENUM_NOT_FOUND.getMsg());
    }

    public static RadiusAccountingStatusType findByValue(String value) {
        if (StringUtils.isEmpty(value)) {
            log.warn("findByValue failed. index is null");
            throw new RuntimeException(ResponseCode.ACCOUNTING_PARAMETER_IS_NULL.getMsg());
        }
        for (RadiusAccountingStatusType type : RadiusAccountingStatusType.values()) {
            if (!Objects.equals(type.getValue(), value)) continue;
            return type;
        }
        log.warn("findByValue not match. {}", (Object)value);
        throw new RuntimeException(ResponseCode.ACCOUNTING_ENUM_NOT_FOUND.getMsg());
    }

    public Integer getIndex() {
        return this.index;
    }

    public String getValue() {
        return this.value;
    }

    private RadiusAccountingStatusType(Integer index, String value) {
        this.index = index;
        this.value = value;
    }

    static {
        log = LoggerFactory.getLogger(RadiusAccountingStatusType.class);
    }
}

