/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.core.authentication.utils;

import com.tplink.cdd.radius.common.attribute.type.RadiusAttribute;
import com.tplink.cdd.radius.common.attribute.type.VendorSpecificAttributeType;
import com.tplink.cdd.radius.common.dictionary.DefaultDictionary;
import com.tplink.cdd.radius.common.dictionary.Dictionary;
import com.tplink.cdd.radius.common.enums.RadiusAvp;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VendorSpecificAttributeUtil {
    private static final Logger log = LoggerFactory.getLogger(VendorSpecificAttributeUtil.class);
    private static final Dictionary DICTIONARY = DefaultDictionary.INSTANCE;

    public static RadiusAttribute buildVendorSpecificAttribute(VendorSpecificAttributeType vendorSpecificAttributeType, Number value) {
        byte[] bytes = VendorSpecificAttributeUtil.toByteArray(value);
        int length = Unpooled.buffer().writeByte(vendorSpecificAttributeType.getValue()).writeBytes(bytes).readableBytes();
        ByteBuf byteBuf = Unpooled.buffer().writeByte(vendorSpecificAttributeType.getValue()).writeByte(length + 1).writeBytes(bytes);
        RadiusAttribute radiusAttribute = DICTIONARY.createAttribute(vendorSpecificAttributeType.getVendorId(), RadiusAvp.VENDOR_SPECIFIC.getIndex(), byteBuf);
        return radiusAttribute;
    }

    private static byte[] toByteArray(Number value) {
        if (value instanceof Long) {
            return VendorSpecificAttributeUtil.longToByteArray((Long)value);
        }
        if (value instanceof Integer) {
            return VendorSpecificAttributeUtil.intToByteArray((Integer)value);
        }
        return null;
    }

    private static byte[] longToByteArray(Long l) {
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bao);
        try {
            dos.writeLong(l);
        }
        catch (IOException e) {
            return null;
        }
        return bao.toByteArray();
    }

    private static byte[] intToByteArray(Integer i) {
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bao);
        try {
            dos.writeInt(i);
        }
        catch (IOException e) {
            return null;
        }
        return bao.toByteArray();
    }

    private VendorSpecificAttributeUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

