/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.core.authentication.utils;

import com.tplink.cdd.component.aaa.core.authentication.utils.CipherUtil;
import com.tplink.cdd.component.aaa.core.authentication.utils.WpaCipherUtil;
import com.tplink.cdd.radius.common.RadiusPacketException;
import com.tplink.cdd.radius.common.attribute.type.RadiusAttribute;
import com.tplink.cdd.radius.common.attribute.type.VendorSpecificAttribute;
import com.tplink.cdd.radius.common.attribute.type.VendorSpecificAttributeType;
import com.tplink.cdd.radius.common.enums.RadiusAvp;
import com.tplink.cdd.radius.common.packet.request.AccessRequest;
import com.tplink.cdd.radius.common.packet.request.RadiusRequest;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class TpLinkVsaUtil {
    public static final int TPLINK_VENDOR_ID = 11863;
    private static final int FOUND_KEY_VSA_LENGTH = 42;

    public static byte[][] getTpFindKeySubAttrs(VendorSpecificAttribute vsa) throws RadiusPacketException {
        try {
            ByteBuf vsaData = vsa.getData();
            vsaData.readBytes(6);
            if (vsaData.readByte() != 3) {
                throw new RadiusPacketException("Illegal subAttribute type for TPLink-Authentication-FindKey(3)");
            }
            vsaData.readBytes(2);
            int frame2Length = (vsaData.readByte() & 0xFF) - 2;
            byte[] frame2 = new byte[frame2Length];
            vsaData.readBytes(frame2);
            vsaData.readByte();
            int aNonceLength = (vsaData.readByte() & 0xFF) - 2;
            byte[] aNonce = new byte[aNonceLength];
            vsaData.readBytes(aNonce);
            byte[] sNonce = Arrays.copyOfRange(frame2, 17, 49);
            byte[] mic = Arrays.copyOfRange(frame2, 81, 97);
            vsaData.readByte();
            int ssIdLength = (vsaData.readByte() & 0xFF) - 2;
            byte[] ssId = new byte[ssIdLength];
            vsaData.readBytes(ssId);
            vsaData.readByte();
            int apMacLength = (vsaData.readByte() & 0xFF) - 2;
            byte[] apMac = new byte[apMacLength];
            vsaData.readBytes(apMac);
            vsaData.readByte();
            int staMacLength = (vsaData.readByte() & 0xFF) - 2;
            byte[] staMac = new byte[staMacLength];
            vsaData.readBytes(staMac);
            vsaData.readByte();
            int bssIdLength = (vsaData.readByte() & 0xFF) - 2;
            byte[] bssId = new byte[bssIdLength];
            vsaData.readBytes(bssId);
            return new byte[][]{frame2, aNonce, sNonce, mic, ssId, apMac, staMac, bssId};
        }
        catch (IndexOutOfBoundsException e) {
            throw new RadiusPacketException("Lack of enough packet data for ppsk unbound mac");
        }
    }

    public static byte[] genKeyData(byte[][] tpFindKeySubAttrs) {
        byte[] keyData4;
        byte[] keyData3;
        byte[] keyData2;
        byte[] keyData1;
        if (WpaCipherUtil.compareByteArray(tpFindKeySubAttrs[7], tpFindKeySubAttrs[6]) >= 0) {
            keyData1 = tpFindKeySubAttrs[6];
            keyData2 = tpFindKeySubAttrs[7];
        } else {
            keyData1 = tpFindKeySubAttrs[7];
            keyData2 = tpFindKeySubAttrs[6];
        }
        if (WpaCipherUtil.compareByteArray(tpFindKeySubAttrs[1], tpFindKeySubAttrs[2]) >= 0) {
            keyData3 = tpFindKeySubAttrs[2];
            keyData4 = tpFindKeySubAttrs[1];
        } else {
            keyData3 = tpFindKeySubAttrs[1];
            keyData4 = tpFindKeySubAttrs[2];
        }
        return CipherUtil.concat(CipherUtil.concat(keyData1, keyData2), CipherUtil.concat(keyData3, keyData4));
    }

    public static RadiusAttribute genFoundKeyVsa(byte[] pmk, AccessRequest accessRequest) {
        ByteBuf foundKey = Unpooled.buffer();
        foundKey.writeByte(26).writeByte(42).writeInt(11863).writeShort(1060).writeShort(290).writeBytes(pmk);
        return accessRequest.getDictionary().createAttribute(11863, RadiusAvp.VENDOR_SPECIFIC.getIndex(), foundKey);
    }

    public static Boolean existTpLinkVsaFindKey(RadiusRequest radiusRequest) {
        List vendorAttributes = radiusRequest.getVendorAttributes(11863);
        if (vendorAttributes.size() <= 0) {
            return false;
        }
        return !Objects.isNull(TpLinkVsaUtil.getVsaFindKey(vendorAttributes));
    }

    public static VendorSpecificAttribute getVsaFindKey(List<VendorSpecificAttribute> attributes) {
        for (VendorSpecificAttribute attribute : attributes) {
            ByteBuf data = attribute.getData();
            if (VendorSpecificAttributeType.TPLINK_AUTHENTICATION_FINDKEY.getValue() != data.getByte(6)) continue;
            return attribute;
        }
        return null;
    }
}

