/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.core.authentication.utils;

import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import org.apache.commons.codec.binary.Hex;
import org.bouncycastle.crypto.digests.MD4Digest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsChapUtil {
    private static final Logger log = LoggerFactory.getLogger(MsChapUtil.class);
    private static final String SHA1 = "SHA-1";
    private static final byte[] MAGIC1_2759 = new byte[]{77, 97, 103, 105, 99, 32, 115, 101, 114, 118, 101, 114, 32, 116, 111, 32, 99, 108, 105, 101, 110, 116, 32, 115, 105, 103, 110, 105, 110, 103, 32, 99, 111, 110, 115, 116, 97, 110, 116};
    private static final byte[] MAGIC2_2759 = new byte[]{80, 97, 100, 32, 116, 111, 32, 109, 97, 107, 101, 32, 105, 116, 32, 100, 111, 32, 109, 111, 114, 101, 32, 116, 104, 97, 110, 32, 111, 110, 101, 32, 105, 116, 101, 114, 97, 116, 105, 111, 110};
    private static final byte[] SHSPAD1 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] SHSPAD2 = new byte[]{-14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14};
    private static final byte[] MAGIC1_3079 = new byte[]{84, 104, 105, 115, 32, 105, 115, 32, 116, 104, 101, 32, 77, 80, 80, 69, 32, 77, 97, 115, 116, 101, 114, 32, 75, 101, 121};
    private static final byte[] MAGIC2_3079 = new byte[]{79, 110, 32, 116, 104, 101, 32, 99, 108, 105, 101, 110, 116, 32, 115, 105, 100, 101, 44, 32, 116, 104, 105, 115, 32, 105, 115, 32, 116, 104, 101, 32, 115, 101, 110, 100, 32, 107, 101, 121, 59, 32, 111, 110, 32, 116, 104, 101, 32, 115, 101, 114, 118, 101, 114, 32, 115, 105, 100, 101, 44, 32, 105, 116, 32, 105, 115, 32, 116, 104, 101, 32, 114, 101, 99, 101, 105, 118, 101, 32, 107, 101, 121, 46};
    private static final byte[] MAGIC3_3079 = new byte[]{79, 110, 32, 116, 104, 101, 32, 99, 108, 105, 101, 110, 116, 32, 115, 105, 100, 101, 44, 32, 116, 104, 105, 115, 32, 105, 115, 32, 116, 104, 101, 32, 114, 101, 99, 101, 105, 118, 101, 32, 107, 101, 121, 59, 32, 111, 110, 32, 116, 104, 101, 32, 115, 101, 114, 118, 101, 114, 32, 115, 105, 100, 101, 44, 32, 105, 116, 32, 105, 115, 32, 116, 104, 101, 32, 115, 101, 110, 100, 32, 107, 101, 121, 46};

    public static void parity_key(byte[] szOut, byte[] szIn, int offset) {
        int cNext = 0;
        int cWorking = 0;
        for (int i = 0; i < 7; ++i) {
            cWorking = 0xFF & szIn[i + offset];
            szOut[i] = (byte)((cWorking >> i | cNext | 1) & 0xFF);
            cWorking = 0xFF & szIn[i + offset];
            cNext = cWorking << 7 - i;
        }
        szOut[i] = (byte)(cNext | 1);
    }

    public static byte[] unicode(byte[] in) {
        int i;
        byte[] b = new byte[in.length * 2];
        for (i = 0; i < b.length; ++i) {
            b[i] = 0;
        }
        for (i = 0; i < in.length; ++i) {
            b[2 * i] = in[i];
        }
        return b;
    }

    public static byte[] NtPasswordHash(byte[] password) throws NoSuchAlgorithmException {
        byte[] passwordHash = new byte[16];
        byte[] uniPassword = MsChapUtil.unicode(password);
        MD4Digest md4 = new MD4Digest();
        md4.update(uniPassword, 0, uniPassword.length);
        md4.doFinal(passwordHash, 0);
        return passwordHash;
    }

    public static byte[] hashNtPasswordHash(byte[] passwordHash) throws NoSuchAlgorithmException {
        byte[] passwordHashHash = new byte[16];
        MD4Digest md4 = new MD4Digest();
        md4.update(passwordHash, 0, 16);
        md4.doFinal(passwordHashHash, 0);
        return passwordHashHash;
    }

    public static byte[] genMasterKey(byte[] passwordHashHash, byte[] ntResponse) throws NoSuchAlgorithmException {
        byte[] masterKey = new byte[16];
        MessageDigest md = MessageDigest.getInstance(SHA1);
        md.update(passwordHashHash);
        md.update(ntResponse);
        md.update(MAGIC1_3079);
        System.arraycopy(md.digest(), 0, masterKey, 0, 16);
        return masterKey;
    }

    public static byte[] genMppeSendKey(byte[] masterKey) throws NoSuchAlgorithmException {
        byte[] mppeSendKey = new byte[32];
        MessageDigest md = MessageDigest.getInstance(SHA1);
        md.update(masterKey);
        md.update(SHSPAD1);
        md.update(MAGIC3_3079);
        md.update(SHSPAD2);
        byte[] digest = md.digest();
        char[] chars = Hex.encodeHex((byte[])digest, (boolean)true);
        for (int i = 0; i < 32; ++i) {
            mppeSendKey[i] = (byte)chars[i];
        }
        return mppeSendKey;
    }

    public static byte[] genMppeRecvKey(byte[] masterKey) throws NoSuchAlgorithmException {
        byte[] mppeRecvKey = new byte[32];
        MessageDigest md = MessageDigest.getInstance(SHA1);
        md.update(masterKey);
        md.update(SHSPAD1);
        md.update(MAGIC2_3079);
        md.update(SHSPAD2);
        byte[] digest = md.digest();
        char[] chars = Hex.encodeHex((byte[])digest, (boolean)true);
        for (int i = 0; i < 32; ++i) {
            mppeRecvKey[i] = (byte)chars[i];
        }
        return mppeRecvKey;
    }

    public static void DesEncrypt(byte[] clear, int clearOffset, byte[] key, int keyOffset, byte[] cypher, int cypherOffset) {
        byte[] szParityKey = new byte[8];
        MsChapUtil.parity_key(szParityKey, key, keyOffset);
        try {
            DESKeySpec ks = new DESKeySpec(szParityKey);
            SecretKeyFactory skf = SecretKeyFactory.getInstance("DES");
            SecretKey sk = skf.generateSecret(ks);
            Cipher c = Cipher.getInstance("DES/CBC/NoPadding");
            IvParameterSpec ips = new IvParameterSpec(new byte[]{0, 0, 0, 0, 0, 0, 0, 0});
            c.init(1, (Key)sk, ips);
            c.doFinal(clear, clearOffset, clear.length - clearOffset, cypher, cypherOffset);
        }
        catch (Exception e) {
            log.warn(e.getMessage());
        }
    }

    public static byte[] challengeResponse(byte[] challenge, byte[] passwordHash) {
        int i;
        byte[] response = new byte[24];
        byte[] zPasswordHash = new byte[21];
        for (i = 0; i < 16; ++i) {
            zPasswordHash[i] = passwordHash[i];
        }
        for (i = 16; i < 21; ++i) {
            zPasswordHash[i] = 0;
        }
        MsChapUtil.DesEncrypt(challenge, 0, zPasswordHash, 0, response, 0);
        MsChapUtil.DesEncrypt(challenge, 0, zPasswordHash, 7, response, 8);
        MsChapUtil.DesEncrypt(challenge, 0, zPasswordHash, 14, response, 16);
        return response;
    }

    public static byte[] NtChallengeResponse(byte[] challenge, byte[] password) throws NoSuchAlgorithmException {
        byte[] passwordHash = MsChapUtil.NtPasswordHash(password);
        return MsChapUtil.challengeResponse(challenge, passwordHash);
    }

    public static byte[] generateNTResponse(byte[] authenticatorChallenge, byte[] peerChallenge, byte[] userName, byte[] password) throws NoSuchAlgorithmException {
        byte[] challenge = MsChapUtil.ChallengeHash(peerChallenge, authenticatorChallenge, userName);
        byte[] passwordHash = MsChapUtil.NtPasswordHash(password);
        return MsChapUtil.challengeResponse(challenge, passwordHash);
    }

    public static byte[] clientDoMSCHAPv2(byte[] userName, byte[] password, byte[] authChallenge, byte[] peerChallenge) throws NoSuchAlgorithmException {
        byte[] response = new byte[50];
        byte[] ntResponse = MsChapUtil.generateNTResponse(authChallenge, peerChallenge, userName, password);
        System.arraycopy(peerChallenge, 0, response, 2, 16);
        System.arraycopy(ntResponse, 0, response, 26, 24);
        return response;
    }

    public static boolean verifyMSCHAPv2(byte[] userName, byte[] password, byte[] challenge, byte[] response) throws NoSuchAlgorithmException {
        byte[] peerChallenge = new byte[16];
        byte[] peerNtResponse = new byte[24];
        System.arraycopy(response, 2, peerChallenge, 0, 16);
        System.arraycopy(response, 26, peerNtResponse, 0, 24);
        byte[] ntResponse = MsChapUtil.generateNTResponse(challenge, peerChallenge, userName, password);
        return Arrays.equals(ntResponse, peerNtResponse);
    }

    public static boolean verifyClientResponse(byte[] username, byte[] password, byte[] authChallenge, byte[] peerChallenge, byte[] clientNtResposne) throws NoSuchAlgorithmException {
        byte[] serverNtResponse = MsChapUtil.generateNTResponse(authChallenge, peerChallenge, username, password);
        return Arrays.equals(clientNtResposne, serverNtResponse);
    }

    public static byte[] ChallengeHash(byte[] PeerChallenge, byte[] AuthenticatorChallenge, byte[] userName) throws NoSuchAlgorithmException {
        byte[] challenge = new byte[8];
        MessageDigest md = MessageDigest.getInstance(SHA1);
        md.update(PeerChallenge, 0, 16);
        md.update(AuthenticatorChallenge, 0, 16);
        md.update(userName, 0, userName.length);
        System.arraycopy(md.digest(), 0, challenge, 0, 8);
        return challenge;
    }

    public static byte[] genAuthenticatorResponse(byte[] password, byte[] ntResponse, byte[] peerChallenge, byte[] authChallenge, byte[] username) throws NoSuchAlgorithmException {
        byte[] challenge = MsChapUtil.ChallengeHash(peerChallenge, authChallenge, username);
        byte[] passwordHash = MsChapUtil.NtPasswordHash(password);
        byte[] passwordHashHash = MsChapUtil.hashNtPasswordHash(passwordHash);
        byte[] digest1 = new byte[20];
        MessageDigest md = MessageDigest.getInstance(SHA1);
        md.update(passwordHashHash);
        md.update(ntResponse, 0, 24);
        md.update(MAGIC1_2759, 0, MAGIC1_2759.length);
        System.arraycopy(md.digest(), 0, digest1, 0, 20);
        byte[] digest2 = new byte[20];
        md.reset();
        md.update(digest1, 0, 20);
        md.update(challenge, 0, 8);
        md.update(MAGIC2_2759, 0, MAGIC2_2759.length);
        System.arraycopy(md.digest(), 0, digest2, 0, 20);
        byte[] authenticatorResponse = new byte[42];
        authenticatorResponse[0] = 83;
        authenticatorResponse[1] = 61;
        char[] chars = Hex.encodeHex((byte[])digest2, (boolean)false);
        for (int i = 0; i < 40; ++i) {
            authenticatorResponse[i + 2] = (byte)chars[i];
        }
        return authenticatorResponse;
    }
}

