/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.core.authentication.utils;

import com.tplink.cdd.component.aaa.core.authentication.dto.AuthReq;
import com.tplink.cdd.component.aaa.server.api.RadiusApiService;
import com.tplink.cdd.component.aaa.server.dto.UserApiDTO;
import com.tplink.cdd.component.aaa.server.dto.UserInfoRequestDTO;
import com.tplink.cdd.component.aaa.server.utils.CustomPIIMaskUtil;
import com.tplink.cdd.radius.common.packet.request.AccessRequest;
import java.net.InetSocketAddress;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
@Lazy(value=false)
public class GetUserInfoHelper
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(GetUserInfoHelper.class);
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public UserApiDTO getUserApiDTO(String username, AccessRequest accessRequest, AuthReq authReq) {
        InetSocketAddress remoteAddress = authReq.getRemoteAddress();
        UserInfoRequestDTO userInfoRequestDTO = new UserInfoRequestDTO();
        userInfoRequestDTO.setUsername(username);
        userInfoRequestDTO.setRemoteAddress(remoteAddress);
        userInfoRequestDTO.setAuthType(authReq.getAuthType());
        userInfoRequestDTO.setAccessRequest(accessRequest);
        RadiusApiService radiusApiService = (RadiusApiService)this.applicationContext.getBean(RadiusApiService.class);
        Optional<UserApiDTO> optionalUserApiDTO = radiusApiService.getUserInfo(userInfoRequestDTO);
        if (!optionalUserApiDTO.isPresent()) {
            log.info("Not found user: {}", (Object)CustomPIIMaskUtil.hash(username));
            throw new NoSuchElementException();
        }
        return optionalUserApiDTO.get();
    }

    public String getPassword(String username, AccessRequest accessRequest, AuthReq authReq) {
        return this.getUserApiDTO(username, accessRequest, authReq).getPassword();
    }
}

