/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.core.authentication.utils;

import com.tplink.cdd.component.aaa.server.utils.AccessRequestUtil;
import com.tplink.cdd.radius.common.eap.EapPacketException;
import com.tplink.cdd.radius.common.eap.enums.DataType;
import com.tplink.cdd.radius.common.eap.packet.BaseEapPacket;
import com.tplink.cdd.radius.common.eap.packet.EapPacket;
import com.tplink.cdd.radius.common.eap.packet.EapResponse;
import com.tplink.cdd.radius.common.eap.packet.data.EapTlsPacket;
import com.tplink.cdd.radius.common.packet.request.AccessRequest;
import com.tplink.cdd.radius.common.packet.request.AccessRequestEap;
import com.tplink.cdd.radius.common.tls.TlsPacket;
import com.tplink.cdd.radius.common.tls.recordlayer.RecordLayer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EapPacketUtil {
    private static final Logger log;
    public static final EapPacket INTERNAL_FAILURE;
    private static final byte DEFAULT_EAP_REQUEST_ID = 1;
    private static final byte MAX_EAP_REQUEST_ID = 126;

    public static EapPacket success(AccessRequestEap accessRequestEap) {
        return EapPacketUtil.success(AccessRequestUtil.findEapResponse((AccessRequest)accessRequestEap));
    }

    public static EapPacket success(EapResponse eapResponse) {
        return EapPacketUtil.success(eapResponse.getId());
    }

    public static EapPacket success(byte responseId) {
        byte requestId = EapPacketUtil.computeRequestId(responseId);
        return EapPacketUtil.wrap(Unpooled.buffer().writeByte(3).writeByte((int)requestId).writeShort(4), null);
    }

    public static EapPacket failure(AccessRequestEap accessRequestEap) {
        return EapPacketUtil.failure(AccessRequestUtil.findEapResponse((AccessRequest)accessRequestEap));
    }

    public static EapPacket failure(EapResponse eapResponse) {
        return EapPacketUtil.failure(eapResponse.getId());
    }

    public static EapPacket failure(byte responseId) {
        byte requestId = EapPacketUtil.computeRequestId(responseId);
        return EapPacketUtil.wrap(Unpooled.buffer().writeByte(4).writeByte((int)requestId).writeShort(4), null);
    }

    public static EapPacket empty(EapResponse eapResponse) {
        ByteBuf data = Unpooled.buffer().writeByte((int)eapResponse.getDataType().getIndex()).writeByte(0);
        log.debug("success - build - data - {} bytes", (Object)data.readableBytes());
        ByteBuf header = EapPacket.buildHeader((byte)1, (byte)EapPacketUtil.computeRequestId(eapResponse.getId()), (ByteBuf)data);
        log.debug("success - build - header - {} bytes", (Object)header.readableBytes());
        return EapPacketUtil.wrap(header, data);
    }

    public static EapPacket fromRecordLayerList(DataType dataType, byte requestId, RecordLayer ... recordLayers) {
        EapTlsPacket respDataValue = new EapTlsPacket(DataType.EAP_TTLS == dataType ? (byte)-128 : 0, new TlsPacket(Arrays.asList(recordLayers)));
        ByteBuf data = Unpooled.buffer().writeByte((int)dataType.getIndex()).writeBytes(respDataValue.toByteBuf());
        log.debug("success - build - tls data - {} bytes", (Object)data.readableBytes());
        ByteBuf header = EapPacket.buildHeader((byte)1, (byte)requestId, (ByteBuf)data);
        log.debug("success - build - tls header - {} bytes", (Object)header.readableBytes());
        return EapPacketUtil.wrap(header, data);
    }

    public static EapPacket wrap(ByteBuf header, ByteBuf data) {
        try {
            return BaseEapPacket.create((ByteBuf)header, (ByteBuf)data);
        }
        catch (EapPacketException e) {
            log.error("Unexpect exception caught when build EAP packet! header = {}, data = {}", new Object[]{header, data, e});
            return INTERNAL_FAILURE;
        }
    }

    public static byte computeRequestId(byte responseId) {
        byte requestId = (byte)(responseId + 1);
        return requestId > 126 ? (byte)1 : requestId;
    }

    public static EapPacket tlvSuccess(byte responseId) {
        byte requestId = EapPacketUtil.computeRequestId(responseId);
        ByteBuf data = Unpooled.buffer().writeByte((int)DataType.EAP_EXTENSIONS.getIndex()).writeByte(128).writeByte(3).writeShort(2).writeShort(1);
        ByteBuf header = EapPacket.buildHeader((byte)1, (byte)requestId, (ByteBuf)data);
        return EapPacketUtil.wrap(header, data);
    }

    private EapPacketUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        EapPacket internalFailure;
        log = LoggerFactory.getLogger(EapPacketUtil.class);
        try {
            internalFailure = BaseEapPacket.create((ByteBuf)Unpooled.buffer().writeByte(4).writeByte(1).writeShort(4), null);
        }
        catch (EapPacketException e) {
            log.error("Unexpect exception caught when build default internal failure EAP packet!", (Throwable)e);
            internalFailure = null;
        }
        INTERNAL_FAILURE = internalFailure;
    }
}

