/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.core.authentication.utils;

import com.tplink.cdd.radius.common.utils.RandomUtil;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Objects;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;

public class CipherUtil {
    public static byte[] toTunnelPassword(byte[] password, byte[] radiusKey, byte[] authenticator) {
        byte[] ci;
        byte[] salt = RandomUtil.randomBytes((int)2);
        salt[0] = (byte)(salt[0] | 0x80);
        byte[] dataLength = new byte[]{(byte)password.length};
        byte[] plainText = CipherUtil.concat(dataLength, password);
        if (plainText.length % 16 != 0) {
            int paddingLength = 16 - plainText.length % 16;
            byte[] paddingBytes = new byte[paddingLength];
            Arrays.fill(paddingBytes, (byte)0);
            plainText = CipherUtil.concat(plainText, paddingBytes);
        }
        int n = plainText.length / 16;
        byte[] bi = CipherUtil.doMD5(CipherUtil.concat(CipherUtil.concat(radiusKey, authenticator), salt));
        byte[] c = ci = CipherUtil.xorArrays(Arrays.copyOfRange(plainText, 0, 16), bi);
        for (int i = 1; i < n; ++i) {
            bi = CipherUtil.doMD5(CipherUtil.concat(radiusKey, ci));
            ci = CipherUtil.xorArrays(Arrays.copyOfRange(plainText, 16 * i, 16 * (i + 1)), bi);
            c = CipherUtil.concat(c, ci);
        }
        return CipherUtil.concat(salt, c);
    }

    public static byte[] xorArrays(byte[] a, byte[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("unmatched length of xor arrays");
        }
        for (int i = 0; i < a.length; ++i) {
            int n = i;
            a[n] = (byte)(a[n] ^ b[i]);
        }
        return a;
    }

    public static byte[] concat(byte[] a, byte[] b) {
        if (Objects.isNull(a)) {
            return b;
        }
        byte[] c = new byte[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static byte[] doCombinedHash(byte[] handShakeMessages) {
        byte[] result = new byte[36];
        MD5Digest md5Digest = new MD5Digest();
        SHA1Digest sha1Digest = new SHA1Digest();
        md5Digest.update(handShakeMessages, 0, handShakeMessages.length);
        sha1Digest.update(handShakeMessages, 0, handShakeMessages.length);
        md5Digest.doFinal(result, 0);
        sha1Digest.doFinal(result, 16);
        return result;
    }

    public static byte[] doSHA256(byte[] data) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(data);
            return messageDigest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] doSHA1(byte[] data) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.update(data);
            return messageDigest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] doMD5(byte[] data) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(data);
            return messageDigest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static long byteArrayToLong(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.put(bytes, 0, bytes.length);
        buffer.flip();
        return buffer.getLong();
    }
}

