/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.core.authentication.service.handler;

import com.tplink.cdd.component.aaa.core.authentication.annotation.Auth;
import com.tplink.cdd.component.aaa.core.authentication.dto.AuthReq;
import com.tplink.cdd.component.aaa.core.authentication.dto.AuthResp;
import com.tplink.cdd.component.aaa.core.authentication.service.handler.RadiusAuthAbstractHandler;
import com.tplink.cdd.component.aaa.core.authentication.utils.GetUserInfoHelper;
import com.tplink.cdd.radius.common.enums.AuthType;
import com.tplink.cdd.radius.common.enums.RadiusAuthPacketType;
import com.tplink.cdd.radius.common.packet.request.AccessRequest;
import com.tplink.cdd.radius.common.packet.request.AccessRequestPap;
import com.tplink.cdd.radius.common.packet.request.RadiusRequest;
import com.tplink.cdd.radius.common.utils.RadiusAttributeUtil;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Auth(radiusAuthPacketType=RadiusAuthPacketType.PAP, authType=AuthType.USER_ACCESS)
public class UserAccessPapAuthHandler
extends RadiusAuthAbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(UserAccessPapAuthHandler.class);
    @Autowired
    private GetUserInfoHelper getUserInfoHelper;

    @Override
    protected AuthResp auth(AuthReq authReq) {
        String password;
        log.info("-------PapUserAccessAuthHandler-------");
        AccessRequestPap accessRequestPap = (AccessRequestPap)authReq.getAccessRequest();
        String username = RadiusAttributeUtil.username((RadiusRequest)accessRequestPap);
        try {
            password = this.getUserInfoHelper.getPassword(username, (AccessRequest)accessRequestPap, authReq);
        }
        catch (NoSuchElementException e) {
            return AuthResp.reject((AccessRequest)accessRequestPap);
        }
        Optional passwordOptional = accessRequestPap.getPassword();
        if (!passwordOptional.isPresent()) {
            return AuthResp.reject((AccessRequest)accessRequestPap);
        }
        String inputPassword = (String)passwordOptional.get();
        return Objects.equals(password, inputPassword) ? AuthResp.accept((AccessRequest)accessRequestPap) : AuthResp.reject((AccessRequest)accessRequestPap);
    }
}

