/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.core.authentication.service.handler;

import com.tplink.cdd.component.aaa.core.authentication.annotation.EapAuth;
import com.tplink.cdd.component.aaa.core.authentication.cache.UserCache;
import com.tplink.cdd.component.aaa.core.authentication.cache.UserEapCacheInfo;
import com.tplink.cdd.component.aaa.core.authentication.dto.AuthReq;
import com.tplink.cdd.component.aaa.core.authentication.dto.AuthResp;
import com.tplink.cdd.component.aaa.core.authentication.eap.config.ActionProxy;
import com.tplink.cdd.component.aaa.core.authentication.eap.enums.CurrentState;
import com.tplink.cdd.component.aaa.core.authentication.eap.enums.TriggerEvent;
import com.tplink.cdd.component.aaa.core.authentication.service.handler.EapAuthHandler;
import com.tplink.cdd.radius.common.eap.enums.DataType;
import com.tplink.cdd.radius.common.eap.packet.EapPacket;
import com.tplink.cdd.radius.common.enums.AuthProtocol;
import com.tplink.cdd.radius.common.packet.request.AccessRequest;
import com.tplink.cdd.radius.common.packet.request.AccessRequestEap;
import com.tplink.cdd.radius.common.packet.request.RadiusRequest;
import com.tplink.cdd.radius.common.utils.RadiusAttributeUtil;
import com.tplink.nbu.common.utils.JacksonUtil;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@EapAuth(eapAuthProtocol=AuthProtocol.EAP_TLS)
public class UserAccessEapTlsAuthHandler
extends EapAuthHandler {
    private static final Logger log = LoggerFactory.getLogger(UserAccessEapTlsAuthHandler.class);
    @Autowired
    private ActionProxy actionProxy;
    @Autowired
    private UserCache userCache;

    @Override
    public AuthResp doAuth(AuthReq authReq) {
        AccessRequestEap accessRequestEap = (AccessRequestEap)authReq.getAccessRequest();
        String clientMac = RadiusAttributeUtil.clientMac((RadiusRequest)accessRequestEap);
        UserEapCacheInfo userEapCacheInfo = this.userCache.getUserEapCacheInfo(authReq.getNasMac(), clientMac);
        if (Objects.isNull(userEapCacheInfo)) {
            userEapCacheInfo = UserEapCacheInfo.builder().currentState(CurrentState.DEFAULT_STATE).build();
        }
        authReq.setUserEapCacheInfo(userEapCacheInfo);
        CurrentState currentState = userEapCacheInfo.getCurrentState();
        TriggerEvent triggerEvent = AuthProtocol.IDENTITY == authReq.getAuthProtocol() ? TriggerEvent.fromIdentityOrNak(DataType.IDENTITY, AuthProtocol.EAP_TLS) : (AuthProtocol.NAK == authReq.getAuthProtocol() ? TriggerEvent.fromIdentityOrNak(DataType.NAK, authReq.getNakAuthProtocol()) : super.tlsMap2TriggerEvent(authReq, accessRequestEap.getEapResponse()));
        log.debug("currentState = {}, triggerEvent = {}", (Object)JacksonUtil.parseToStr((Object)((Object)currentState)), (Object)JacksonUtil.parseToStr((Object)((Object)triggerEvent)));
        if (Objects.isNull((Object)triggerEvent)) {
            return AuthResp.reject((AccessRequest)accessRequestEap);
        }
        EapPacket eapPacket = this.actionProxy.action(currentState, triggerEvent, authReq);
        return AuthResp.fromEapPacket(eapPacket, authReq);
    }
}

