/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.core.authentication.service.handler;

import com.tplink.cdd.component.aaa.core.authentication.annotation.Auth;
import com.tplink.cdd.component.aaa.core.authentication.config.AaaExtendServiceFactory;
import com.tplink.cdd.component.aaa.core.authentication.dto.AuthReq;
import com.tplink.cdd.component.aaa.core.authentication.dto.AuthResp;
import com.tplink.cdd.component.aaa.core.authentication.service.handler.EapAuthHandler;
import com.tplink.cdd.component.aaa.core.authentication.service.handler.RadiusAuthAbstractHandler;
import com.tplink.cdd.component.aaa.server.api.extend.EapDefaultProtocolApiService;
import com.tplink.cdd.radius.common.enums.AuthProtocol;
import com.tplink.cdd.radius.common.enums.AuthType;
import com.tplink.cdd.radius.common.enums.RadiusAuthPacketType;
import com.tplink.cdd.radius.common.packet.request.AccessRequest;
import com.tplink.cdd.radius.common.packet.request.AccessRequestEap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Auth(radiusAuthPacketType=RadiusAuthPacketType.EAP, authType=AuthType.USER_ACCESS)
public class UserAccessEapAuthHandler
extends RadiusAuthAbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(UserAccessEapAuthHandler.class);
    @Autowired
    @Qualifier(value="eapAuthDispatcher")
    private Map<AuthProtocol, EapAuthHandler> eapAuthDispatcher;
    @Autowired
    private AaaExtendServiceFactory aaaExtendServiceFactory;

    @Override
    protected AuthResp auth(AuthReq authReq) {
        EapDefaultProtocolApiService eapDefaultProtocolApiService;
        AccessRequestEap accessRequestEap = (AccessRequestEap)authReq.getAccessRequest();
        AuthProtocol authProtocol = authReq.getAuthProtocol();
        if (AuthProtocol.IDENTITY == authProtocol && Objects.isNull(eapDefaultProtocolApiService = this.aaaExtendServiceFactory.getEapDefaultProtocolApiServiceBean())) {
            return this.eapAuthDispatcher.get(AuthProtocol.PEAP).doAuth(authReq);
        }
        EapAuthHandler userAccessEapAuthHandler = this.eapAuthDispatcher.get(authProtocol);
        if (AuthProtocol.NAK == authProtocol) {
            userAccessEapAuthHandler = this.eapAuthDispatcher.get(authReq.getNakAuthProtocol());
        }
        if (Objects.isNull(userAccessEapAuthHandler)) {
            log.warn("Failed to get eap auth handler, auth type = {}", (Object)authProtocol.getName());
            return AuthResp.reject((AccessRequest)accessRequestEap);
        }
        return userAccessEapAuthHandler.doAuth(authReq);
    }
}

