/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.core.authentication.service.handler;

import com.tplink.cdd.component.aaa.core.authentication.annotation.Auth;
import com.tplink.cdd.component.aaa.core.authentication.dto.AuthReq;
import com.tplink.cdd.component.aaa.core.authentication.dto.AuthResp;
import com.tplink.cdd.component.aaa.core.authentication.service.handler.RadiusAuthAbstractHandler;
import com.tplink.cdd.component.aaa.core.authentication.utils.GetUserInfoHelper;
import com.tplink.cdd.radius.common.enums.AuthType;
import com.tplink.cdd.radius.common.enums.RadiusAuthPacketType;
import com.tplink.cdd.radius.common.packet.request.AccessRequest;
import com.tplink.cdd.radius.common.packet.request.AccessRequestChap;
import com.tplink.cdd.radius.common.packet.request.RadiusRequest;
import com.tplink.cdd.radius.common.utils.RadiusAttributeUtil;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Auth(radiusAuthPacketType=RadiusAuthPacketType.CHAP, authType=AuthType.USER_ACCESS)
public class UserAccessChapAuthHandler
extends RadiusAuthAbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(UserAccessChapAuthHandler.class);
    @Autowired
    private GetUserInfoHelper getUserInfoHelper;

    @Override
    protected AuthResp auth(AuthReq authReq) {
        String password;
        log.info("-------ChapUserAccessAuthHandler-------");
        AccessRequestChap accessRequestChap = (AccessRequestChap)authReq.getAccessRequest();
        String username = RadiusAttributeUtil.username((RadiusRequest)accessRequestChap);
        try {
            password = this.getUserInfoHelper.getPassword(username, (AccessRequest)accessRequestChap, authReq);
        }
        catch (NoSuchElementException e) {
            return AuthResp.reject((AccessRequest)accessRequestChap);
        }
        return accessRequestChap.checkPassword(password) ? AuthResp.accept((AccessRequest)accessRequestChap) : AuthResp.reject((AccessRequest)accessRequestChap);
    }
}

