/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.core.authentication.service.handler;

import com.tplink.cdd.component.aaa.core.authentication.dto.AuthReq;
import com.tplink.cdd.component.aaa.core.authentication.dto.AuthResp;
import com.tplink.cdd.component.aaa.core.authentication.eap.EapAuthHelper;
import com.tplink.cdd.component.aaa.core.authentication.service.handler.RadiusAuthHandler;
import com.tplink.cdd.component.aaa.server.io.RequestCtx;
import com.tplink.cdd.component.aaa.server.utils.AccessRequestUtil;
import com.tplink.cdd.radius.common.eap.packet.EapResponse;
import com.tplink.cdd.radius.common.enums.AuthProtocol;
import com.tplink.cdd.radius.common.enums.AuthType;
import com.tplink.cdd.radius.common.enums.RadiusAuthPacketType;
import com.tplink.cdd.radius.common.packet.request.AccessRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class RadiusAuthAbstractHandler
implements RadiusAuthHandler {
    private static final Logger log = LoggerFactory.getLogger(RadiusAuthAbstractHandler.class);
    @Autowired
    private EapAuthHelper eapAuthHelper;

    @Override
    public AuthResp process(RequestCtx msg) {
        AuthReq authReq = AuthReq.builder().authType(this.currentAuthType()).authProtocol(AuthProtocol.fromPacketType((RadiusAuthPacketType)this.currentPacketType(), (AccessRequest)((AccessRequest)msg.getRequest()))).msg(msg).build();
        if (AuthProtocol.NAK == authReq.getAuthProtocol()) {
            authReq.setNakAuthProtocol(this.parseDesiredAuthProtocol(authReq));
        }
        log.debug("------ {} {} ------", (Object)authReq.getAuthType(), (Object)authReq.getAuthProtocol());
        return this.auth(authReq);
    }

    protected abstract AuthResp auth(AuthReq var1);

    private RadiusAuthPacketType currentPacketType() {
        return AccessRequestUtil.findPacketType(this);
    }

    private AuthType currentAuthType() {
        return AccessRequestUtil.findAuthType(this);
    }

    private AuthProtocol parseDesiredAuthProtocol(AuthReq authReq) {
        EapResponse eapResponse = AccessRequestUtil.findEapResponse(authReq.getAccessRequest());
        AuthProtocol nakAuthProtocol = this.eapAuthHelper.parseNakDesiredAuthProtocol(eapResponse);
        authReq.setNakAuthProtocol(nakAuthProtocol);
        return nakAuthProtocol;
    }
}

