/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.core.authentication.service.handler;

import com.tplink.cdd.component.aaa.core.authentication.annotation.Auth;
import com.tplink.cdd.component.aaa.core.authentication.dto.AuthReq;
import com.tplink.cdd.component.aaa.core.authentication.dto.AuthResp;
import com.tplink.cdd.component.aaa.core.authentication.service.handler.RadiusAuthAbstractHandler;
import com.tplink.cdd.component.aaa.core.authentication.utils.CipherUtil;
import com.tplink.cdd.component.aaa.core.authentication.utils.GetUserInfoHelper;
import com.tplink.cdd.radius.common.attribute.type.RadiusAttribute;
import com.tplink.cdd.radius.common.enums.AuthType;
import com.tplink.cdd.radius.common.enums.RadiusAuthPacketType;
import com.tplink.cdd.radius.common.enums.RadiusAvp;
import com.tplink.cdd.radius.common.packet.request.AccessRequest;
import com.tplink.cdd.radius.common.packet.request.AccessRequestPap;
import com.tplink.cdd.radius.common.packet.request.RadiusRequest;
import com.tplink.cdd.radius.common.utils.RadiusAttributeUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Auth(radiusAuthPacketType=RadiusAuthPacketType.PAP, authType=AuthType.PPSK_BOUND_MAC)
public class PpskBoundMacPapAuthHandler
extends RadiusAuthAbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(PpskBoundMacPapAuthHandler.class);
    private static final int TAG = 0;
    @Autowired
    private GetUserInfoHelper getUserInfoHelper;

    @Override
    protected AuthResp auth(AuthReq authReq) {
        String passwordStr;
        AccessRequestPap accessRequestPap = (AccessRequestPap)authReq.getAccessRequest();
        String username = RadiusAttributeUtil.username((RadiusRequest)accessRequestPap);
        try {
            passwordStr = this.getUserInfoHelper.getPassword(username, (AccessRequest)accessRequestPap, authReq);
        }
        catch (NoSuchElementException e) {
            return AuthResp.reject((AccessRequest)accessRequestPap);
        }
        byte[] password = passwordStr.getBytes(StandardCharsets.UTF_8);
        byte[] sharedKey = authReq.getRadiusKey().getBytes(StandardCharsets.UTF_8);
        byte[] authenticator = authReq.getAuthenticator();
        byte[] tunnelPassword = CipherUtil.toTunnelPassword(password, sharedKey, authenticator);
        ArrayList<RadiusAttribute> radiusAttributeList = new ArrayList<RadiusAttribute>();
        ByteBuf tunnelPasswordAttributeBuf = Unpooled.buffer();
        tunnelPasswordAttributeBuf.writeByte(RadiusAvp.TUNNEL_PASSWORD.getIndex()).writeByte(3 + tunnelPassword.length).writeByte(0).writeBytes(tunnelPassword);
        RadiusAttribute tunnelPasswordAttribute = accessRequestPap.getDictionary().createAttribute(-1, RadiusAvp.TUNNEL_PASSWORD.getIndex(), tunnelPasswordAttributeBuf);
        radiusAttributeList.add(tunnelPasswordAttribute);
        return AuthResp.acceptWithAttrs((AccessRequest)accessRequestPap, radiusAttributeList);
    }
}

