/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.core.authentication.service.handler;

import com.tplink.cdd.component.aaa.core.authentication.annotation.Auth;
import com.tplink.cdd.component.aaa.core.authentication.dto.AuthReq;
import com.tplink.cdd.component.aaa.core.authentication.dto.AuthResp;
import com.tplink.cdd.component.aaa.core.authentication.service.handler.RadiusAuthAbstractHandler;
import com.tplink.cdd.component.aaa.core.authentication.utils.GetUserInfoHelper;
import com.tplink.cdd.component.aaa.server.dto.UserApiDTO;
import com.tplink.cdd.component.aaa.utils.MacAddressUtil;
import com.tplink.cdd.radius.common.enums.AuthType;
import com.tplink.cdd.radius.common.enums.RadiusAuthPacketType;
import com.tplink.cdd.radius.common.packet.request.AccessRequest;
import com.tplink.cdd.radius.common.packet.request.AccessRequestPap;
import com.tplink.cdd.radius.common.packet.request.RadiusRequest;
import com.tplink.cdd.radius.common.utils.RadiusAttributeUtil;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Auth(radiusAuthPacketType=RadiusAuthPacketType.PAP, authType=AuthType.MAC)
public class MacPapAuthHandler
extends RadiusAuthAbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(MacPapAuthHandler.class);
    @Autowired
    private GetUserInfoHelper getUserInfoHelper;

    @Override
    protected AuthResp auth(AuthReq authReq) {
        UserApiDTO userApiDTO;
        AccessRequestPap accessRequestPap = (AccessRequestPap)authReq.getAccessRequest();
        String username = RadiusAttributeUtil.username((RadiusRequest)accessRequestPap);
        try {
            userApiDTO = this.getUserInfoHelper.getUserApiDTO(username, (AccessRequest)accessRequestPap, authReq);
        }
        catch (NoSuchElementException e) {
            return AuthResp.reject((AccessRequest)accessRequestPap);
        }
        List macUsers = userApiDTO.getMacUsers().stream().map(MacAddressUtil::toCompactMac).collect(Collectors.toList());
        return macUsers.contains(MacAddressUtil.toCompactMac(authReq.getUsername())) ? AuthResp.accept((AccessRequest)accessRequestPap) : AuthResp.reject((AccessRequest)accessRequestPap);
    }
}

