/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.core.authentication.service.handler;

import com.tplink.cdd.component.aaa.core.authentication.cache.UserEapCacheInfo;
import com.tplink.cdd.component.aaa.core.authentication.dto.AuthReq;
import com.tplink.cdd.component.aaa.core.authentication.dto.AuthResp;
import com.tplink.cdd.component.aaa.core.authentication.eap.enums.TriggerEvent;
import com.tplink.cdd.radius.common.eap.EapPacketException;
import com.tplink.cdd.radius.common.eap.packet.EapResponse;
import com.tplink.cdd.radius.common.eap.packet.data.EapTlsPacket;
import com.tplink.cdd.radius.common.enums.AuthProtocol;
import com.tplink.cdd.radius.common.tls.CipherSuite.TlsCipher;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EapAuthHandler {
    private static final Logger log = LoggerFactory.getLogger(EapAuthHandler.class);

    protected TriggerEvent tlsMap2TriggerEvent(AuthReq authReq, EapResponse eapResponse) {
        UserEapCacheInfo userEapCacheInfo = authReq.getUserEapCacheInfo();
        AuthProtocol authProtocol = authReq.getAuthProtocol();
        try {
            EapTlsPacket eapTlsPacket = EapTlsPacket.fromEapResponse((EapResponse)eapResponse, (TlsCipher)Optional.ofNullable(userEapCacheInfo.getEapTlsInfo()).map(UserEapCacheInfo.EapTlsInfo::getTlsCipher).orElse(null));
            authReq.setEapTlsPacket(eapTlsPacket);
            return TriggerEvent.fromTLS(authProtocol, eapTlsPacket, userEapCacheInfo.getCurrentState());
        }
        catch (EapPacketException e) {
            log.error("Failed to parse TLS packet for [EAP-TLS | EAP-TTLS | PEAP]!", (Throwable)e);
            return null;
        }
    }

    public AuthResp doAuth(AuthReq authReq) {
        return null;
    }
}

