/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.core.authentication.eap.tunnel;

import com.tplink.cdd.component.aaa.core.authentication.dto.AuthReq;
import com.tplink.cdd.component.aaa.core.authentication.eap.tunnel.TunnelAuthenticator;
import com.tplink.cdd.component.aaa.core.authentication.utils.EapPacketUtil;
import com.tplink.cdd.component.aaa.core.authentication.utils.MsChapUtil;
import com.tplink.cdd.radius.common.eap.enums.DataType;
import com.tplink.cdd.radius.common.eap.enums.OpCode;
import com.tplink.cdd.radius.common.utils.RandomUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsChapv2Authenticator
implements TunnelAuthenticator {
    private static final Logger log = LoggerFactory.getLogger(MsChapv2Authenticator.class);
    private static final byte[] OK_MESSAGE = new byte[]{32, 77, 61, 79, 75};
    private byte[] authChallenge;
    private byte[] peerChallenge;
    private byte[] ntResponse;
    private byte[] masterKey;
    private byte[] mppeSendKey;
    private byte[] mppeRecvKey;

    public byte[] sendChallenge(byte responseId, byte[] name) {
        byte[] serverAuthChallenge = RandomUtil.randomBytes((int)16);
        this.authChallenge = serverAuthChallenge;
        ByteBuf data = Unpooled.buffer().writeByte((int)DataType.MS_CHAP_V2.getIndex()).writeByte((int)OpCode.CHALLENGE.getIndex()).writeByte((int)EapPacketUtil.computeRequestId(responseId)).writeShort(21 + name.length).writeByte(16).writeBytes(serverAuthChallenge).writeBytes(name);
        return ByteBufUtil.getBytes((ByteBuf)data);
    }

    public byte[] processResponse(byte[] extensionDataValue, AuthReq authReq) {
        ByteBuf dataValue = Unpooled.buffer().writeBytes(extensionDataValue);
        if (OpCode.RESPONSE.getIndex() != dataValue.readByte()) {
            return ArrayUtils.EMPTY_BYTE_ARRAY;
        }
        try {
            byte msChapV2Id = dataValue.readByte();
            dataValue.readBytes(3);
            byte[] clientPeerChallenge = ByteBufUtil.getBytes((ByteBuf)dataValue.readBytes(16));
            dataValue.readBytes(8);
            byte[] clientNtResponse = ByteBufUtil.getBytes((ByteBuf)dataValue.readBytes(24));
            String username = authReq.getUserEapCacheInfo().getTunnelUsername();
            String password = authReq.getUserEapCacheInfo().getPassword();
            if (!MsChapUtil.verifyClientResponse(username.getBytes(), password.getBytes(), this.getAuthChallenge(), clientPeerChallenge, clientNtResponse)) {
                log.warn("check NtResponse failed !");
                return ArrayUtils.EMPTY_BYTE_ARRAY;
            }
            this.setPeerChallenge(clientPeerChallenge);
            this.setNtResponse(clientNtResponse);
            return this.genSuccessRequest(msChapV2Id, password.getBytes(), this.getNtResponse(), this.getPeerChallenge(), this.getAuthChallenge(), username.getBytes());
        }
        catch (Exception e) {
            log.error("something is wrong when mschapv2 check client response: {}", (Object)e.getMessage());
            e.printStackTrace();
            return ArrayUtils.EMPTY_BYTE_ARRAY;
        }
    }

    private byte[] genSuccessRequest(byte msChapV2Id, byte[] password, byte[] ntResponse, byte[] peerChallenge, byte[] authChallenge, byte[] username) throws NoSuchAlgorithmException {
        byte[] authenticatorResponse = MsChapUtil.genAuthenticatorResponse(password, ntResponse, peerChallenge, authChallenge, username);
        byte[] passwordHash = MsChapUtil.NtPasswordHash(password);
        byte[] passwordHashHash = MsChapUtil.hashNtPasswordHash(passwordHash);
        byte[] genMasterKey = MsChapUtil.genMasterKey(passwordHashHash, this.getNtResponse());
        byte[] genMppeSendKey = MsChapUtil.genMppeSendKey(genMasterKey);
        byte[] genMppeRecvKey = MsChapUtil.genMppeRecvKey(genMasterKey);
        this.setMasterKey(genMasterKey);
        this.setMppeSendKey(genMppeSendKey);
        this.setMppeRecvKey(genMppeRecvKey);
        ByteBuf data = Unpooled.buffer().writeByte((int)DataType.MS_CHAP_V2.getIndex()).writeByte((int)OpCode.SUCCESS.getIndex()).writeByte((int)msChapV2Id).writeShort(9 + authenticatorResponse.length).writeBytes(authenticatorResponse).writeBytes(OK_MESSAGE);
        return ByteBufUtil.getBytes((ByteBuf)data);
    }

    public byte[] getAuthChallenge() {
        return this.authChallenge;
    }

    public byte[] getPeerChallenge() {
        return this.peerChallenge;
    }

    public byte[] getNtResponse() {
        return this.ntResponse;
    }

    public byte[] getMasterKey() {
        return this.masterKey;
    }

    public byte[] getMppeSendKey() {
        return this.mppeSendKey;
    }

    public byte[] getMppeRecvKey() {
        return this.mppeRecvKey;
    }

    public void setAuthChallenge(byte[] authChallenge) {
        this.authChallenge = authChallenge;
    }

    public void setPeerChallenge(byte[] peerChallenge) {
        this.peerChallenge = peerChallenge;
    }

    public void setNtResponse(byte[] ntResponse) {
        this.ntResponse = ntResponse;
    }

    public void setMasterKey(byte[] masterKey) {
        this.masterKey = masterKey;
    }

    public void setMppeSendKey(byte[] mppeSendKey) {
        this.mppeSendKey = mppeSendKey;
    }

    public void setMppeRecvKey(byte[] mppeRecvKey) {
        this.mppeRecvKey = mppeRecvKey;
    }
}

