/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.core.authentication.eap.tunnel;

import com.tplink.cdd.component.aaa.core.authentication.eap.EapAuthHelper;
import com.tplink.cdd.component.aaa.core.authentication.eap.tunnel.TunnelAuthenticator;
import com.tplink.cdd.component.aaa.core.authentication.utils.EapPacketUtil;
import com.tplink.cdd.radius.common.eap.enums.DataType;
import com.tplink.cdd.radius.common.eap.packet.EapPacket;
import com.tplink.cdd.radius.common.utils.RandomUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EapMd5Authenticator
implements TunnelAuthenticator {
    private static final Logger log = LoggerFactory.getLogger(EapMd5Authenticator.class);
    private byte[] checkValue;

    public EapPacket setupRequest(EapAuthHelper eapAuthHelper, byte responseId, String password) {
        byte requestId = EapPacketUtil.computeRequestId(responseId);
        byte[] challenge = RandomUtil.randomBytes((int)16);
        this.checkValue = eapAuthHelper.computeEapMd5CheckValue(requestId, password, challenge);
        ByteBuf data = Unpooled.buffer().writeByte((int)DataType.MD5_CHALLENGE.getIndex()).writeByte(16).writeBytes(challenge);
        ByteBuf header = EapPacket.buildHeader((byte)1, (byte)requestId, (ByteBuf)data);
        return EapPacketUtil.wrap(header, data);
    }

    public boolean processChallenge(ByteBuf dataValue) {
        byte valueSize = dataValue.getByte(0);
        if (valueSize != 16) {
            return false;
        }
        byte[] inputEapMd5CheckValue = ByteBufUtil.getBytes((ByteBuf)dataValue, (int)1, (int)16);
        return Arrays.equals(inputEapMd5CheckValue, this.checkValue);
    }
}

