/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.core.authentication.eap.service.impl;

import com.tplink.cdd.component.aaa.core.authentication.cache.UserCache;
import com.tplink.cdd.component.aaa.core.authentication.cache.UserEapCacheInfo;
import com.tplink.cdd.component.aaa.core.authentication.config.AaaExtendServiceFactory;
import com.tplink.cdd.component.aaa.core.authentication.dto.AuthReq;
import com.tplink.cdd.component.aaa.core.authentication.eap.EapAuthHelper;
import com.tplink.cdd.component.aaa.core.authentication.eap.enums.CurrentState;
import com.tplink.cdd.component.aaa.core.authentication.utils.EapPacketUtil;
import com.tplink.cdd.component.aaa.server.api.extend.CertificateApiService;
import com.tplink.cdd.component.aaa.server.dto.ServerCertificateChainApiDTO;
import com.tplink.cdd.component.aaa.server.utils.AccessRequestUtil;
import com.tplink.cdd.radius.common.TunnelAuthException;
import com.tplink.cdd.radius.common.eap.EapPacketException;
import com.tplink.cdd.radius.common.eap.enums.DataType;
import com.tplink.cdd.radius.common.eap.enums.FragmentType;
import com.tplink.cdd.radius.common.eap.packet.EapPacket;
import com.tplink.cdd.radius.common.eap.packet.EapResponse;
import com.tplink.cdd.radius.common.eap.packet.data.EapTlsPacket;
import com.tplink.cdd.radius.common.packet.request.AccessRequest;
import com.tplink.cdd.radius.common.packet.request.RadiusRequest;
import com.tplink.cdd.radius.common.tls.CipherSuite.TlsCipher;
import com.tplink.cdd.radius.common.tls.TlsPacket;
import com.tplink.cdd.radius.common.tls.dto.SecurityParameters;
import com.tplink.cdd.radius.common.tls.enums.CertificateType;
import com.tplink.cdd.radius.common.tls.enums.CipherSuite;
import com.tplink.cdd.radius.common.tls.enums.HandshakeType;
import com.tplink.cdd.radius.common.tls.enums.RecordLayerType;
import com.tplink.cdd.radius.common.tls.enums.SignatureHashAlgorithm;
import com.tplink.cdd.radius.common.tls.enums.TlsVersion;
import com.tplink.cdd.radius.common.tls.recordlayer.ApplicationData;
import com.tplink.cdd.radius.common.tls.recordlayer.ChangeCipherSpec;
import com.tplink.cdd.radius.common.tls.recordlayer.Handshake;
import com.tplink.cdd.radius.common.tls.recordlayer.handshake.Certificate;
import com.tplink.cdd.radius.common.tls.recordlayer.handshake.CertificateRequest;
import com.tplink.cdd.radius.common.tls.recordlayer.handshake.ClientHello;
import com.tplink.cdd.radius.common.tls.recordlayer.handshake.ClientKeyExchange;
import com.tplink.cdd.radius.common.tls.recordlayer.handshake.Finished;
import com.tplink.cdd.radius.common.tls.recordlayer.handshake.HandshakeProtocol;
import com.tplink.cdd.radius.common.tls.recordlayer.handshake.ServerHello;
import com.tplink.cdd.radius.common.tls.recordlayer.handshake.ServerHelloDone;
import com.tplink.cdd.radius.common.utils.CipherUtil;
import com.tplink.cdd.radius.common.utils.RadiusAttributeUtil;
import com.tplink.cdd.radius.common.utils.RandomUtil;
import com.tplink.cdd.radius.common.utils.TlsUtil;
import com.tplink.cdd.radius.common.utils.TwoTuple;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class TlsAuthenticator {
    private static final Logger log = LoggerFactory.getLogger(TlsAuthenticator.class);
    private static final String TLS_HEADER_LOG = "success - build - tls - header - {} bytes";
    private static final String TLS_DATA_LOG = "success - build - tls data - {} bytes";
    @Autowired
    protected EapAuthHelper eapAuthHelper;
    @Autowired
    protected UserCache userCache;
    @Autowired
    protected AaaExtendServiceFactory aaaExtendServiceFactory;

    protected EapPacket init(AuthReq authReq, DataType dataType, CurrentState nextState) {
        AccessRequest accessRequest = authReq.getAccessRequest();
        String clientMac = RadiusAttributeUtil.clientMac((RadiusRequest)accessRequest);
        EapResponse eapResponse = AccessRequestUtil.findEapResponse(accessRequest);
        String nasMac = authReq.getNasMac();
        byte responseId = eapResponse.getId();
        ByteBuf data = Unpooled.buffer().writeByte((int)dataType.getIndex()).writeByte(32);
        ByteBuf header = EapPacket.buildHeader((byte)1, (byte)EapPacketUtil.computeRequestId(responseId), (ByteBuf)data);
        UserEapCacheInfo userEapCacheInfo = authReq.getUserEapCacheInfo();
        userEapCacheInfo.setCurrentState(nextState);
        this.userCache.setUserEapCacheInfo(nasMac, clientMac, userEapCacheInfo);
        return EapPacketUtil.wrap(header, data);
    }

    protected EapPacket clientHello(AuthReq authReq, CurrentState nextStateForFragment, CurrentState nextStateForFullPacket) {
        AccessRequest accessRequest = authReq.getAccessRequest();
        String clientMac = RadiusAttributeUtil.clientMac((RadiusRequest)accessRequest);
        EapResponse eapResponse = AccessRequestUtil.findEapResponse(accessRequest);
        DataType dataType = eapResponse.getDataType();
        EapTlsPacket eapTlsPacket = authReq.getEapTlsPacket();
        String nasMac = authReq.getNasMac();
        byte responseId = eapResponse.getId();
        ClientHello clientHello = (ClientHello)eapTlsPacket.getTlsPacket().getHandshakeProtocol(ClientHello.class);
        byte[] clientRandom = clientHello.getRandom();
        log.debug("success - get - client random");
        TlsVersion tlsVersion = clientHello.getVersion();
        log.debug("SUCCESS - GET - tls version - {}", (Object)tlsVersion.getName());
        if (tlsVersion == TlsVersion.V1_3) {
            log.warn("Unsupported Tls Version 1.3");
            return EapPacketUtil.failure(eapResponse);
        }
        CipherSuite selectedCipherSuite = this.parseCipherSuites(clientHello);
        if (Objects.isNull(selectedCipherSuite)) {
            return EapPacketUtil.failure(eapResponse);
        }
        log.debug("success - get - cipher suite  - {}", (Object)selectedCipherSuite.getName());
        byte[] serverRandom = RandomUtil.randomBytes((int)32);
        log.debug("success - process - server random");
        byte[] sessionId = RandomUtil.randomBytes((int)32);
        log.debug("success - process - server session id");
        ArrayList<HandshakeProtocol> currentStageHsDataList = new ArrayList<HandshakeProtocol>();
        ServerHello serverHello = this.constructServerHello(serverRandom, sessionId, selectedCipherSuite, tlsVersion);
        currentStageHsDataList.add((HandshakeProtocol)serverHello);
        log.debug("success - construct - server hello");
        Certificate certificate = this.constructServerCertificate();
        currentStageHsDataList.add((HandshakeProtocol)certificate);
        log.debug("success - construct - server certificate");
        CertificateRequest clientCertificateReq = null;
        if (Objects.equals(DataType.EAP_TLS, dataType)) {
            clientCertificateReq = this.constructClientCertificationReq(tlsVersion);
            currentStageHsDataList.add((HandshakeProtocol)clientCertificateReq);
            log.debug("success - construct - client certificate req");
        }
        ServerHelloDone serverHelloDone = this.constructServerHelloDone();
        currentStageHsDataList.add((HandshakeProtocol)serverHelloDone);
        log.debug("success - construct - server hello done");
        UserEapCacheInfo userEapCacheInfo = authReq.getUserEapCacheInfo();
        UserEapCacheInfo.EapTlsInfo eapTlsInfo = UserEapCacheInfo.EapTlsInfo.builder().version(Integer.valueOf(tlsVersion.getIndex())).cipherSuite(selectedCipherSuite).sessionId(sessionId).securityParameters(SecurityParameters.builder().clientRandom(clientRandom).serverRandom(serverRandom).build()).clientHelloStageHsData(clientHello.getData()).serverHelloStageHsData(this.hsDataList2ByteBuf(currentStageHsDataList)).build();
        ArrayList<Handshake> recordLayerList = new ArrayList<Handshake>();
        recordLayerList.add(new Handshake(tlsVersion, new HandshakeProtocol[]{serverHello}));
        recordLayerList.add(new Handshake(tlsVersion, new HandshakeProtocol[]{certificate}));
        recordLayerList.add(Objects.isNull(clientCertificateReq) ? new Handshake(tlsVersion, new HandshakeProtocol[]{serverHelloDone}) : new Handshake(tlsVersion, new HandshakeProtocol[]{clientCertificateReq, serverHelloDone}));
        TlsPacket tlsPacket = new TlsPacket(recordLayerList);
        ByteBuf data = Unpooled.buffer().writeByte((int)dataType.getIndex());
        if (this.eapAuthHelper.tlsPacketIsNeedSplit(tlsPacket)) {
            ByteBuf tlsPacketByteBuf = this.eapAuthHelper.splitTlsPacketAndFindFirst(tlsPacket, eapTlsInfo);
            data.writeByte(-64).writeInt(tlsPacket.getSize()).writeBytes(tlsPacketByteBuf);
            eapTlsInfo.setServerHelloLength(tlsPacket.getSize());
            userEapCacheInfo.setEapTlsInfo(eapTlsInfo);
            userEapCacheInfo.setCurrentState(nextStateForFragment);
            log.debug("success - build - split tls data - {} bytes", (Object)data.readableBytes());
        } else {
            EapTlsPacket eapTlsResp = new EapTlsPacket(-128, tlsPacket);
            data.writeBytes(eapTlsResp.toByteBuf());
            userEapCacheInfo.setCurrentState(nextStateForFullPacket);
            log.debug("success - build - full tls data - {} bytes", (Object)data.readableBytes());
        }
        ByteBuf header = EapPacket.buildHeader((byte)1, (byte)EapPacketUtil.computeRequestId(responseId), (ByteBuf)data);
        log.debug(TLS_HEADER_LOG, (Object)header.readableBytes());
        this.userCache.setUserEapCacheInfo(nasMac, clientMac, userEapCacheInfo);
        return EapPacketUtil.wrap(header, data);
    }

    protected EapPacket reqServerHelloNextFragment(AuthReq authReq, CurrentState nextStateNoMoreFragment, CurrentState nextStateMoreFragment) {
        AccessRequest accessRequest = authReq.getAccessRequest();
        String clientMac = RadiusAttributeUtil.clientMac((RadiusRequest)accessRequest);
        EapResponse eapResponse = AccessRequestUtil.findEapResponse(accessRequest);
        DataType dataType = eapResponse.getDataType();
        String nasMac = authReq.getNasMac();
        byte responseId = eapResponse.getId();
        UserEapCacheInfo userEapCacheInfo = this.userCache.getUserEapCacheInfo(nasMac, clientMac);
        UserEapCacheInfo.EapTlsInfo eapTlsInfo = userEapCacheInfo.getEapTlsInfo();
        List<ByteBuf> reqFragmentList = eapTlsInfo.getReqFragmentList();
        if (reqFragmentList.isEmpty()) {
            return EapPacketUtil.INTERNAL_FAILURE;
        }
        ByteBuf currentFragment = reqFragmentList.remove(0);
        ByteBuf data = Unpooled.buffer().writeByte((int)dataType.getIndex());
        if (reqFragmentList.isEmpty()) {
            data.writeByte(-128);
            userEapCacheInfo.setCurrentState(nextStateNoMoreFragment);
        } else {
            data.writeByte(-64);
            userEapCacheInfo.setCurrentState(nextStateMoreFragment);
        }
        data.writeInt(eapTlsInfo.getServerHelloLength().intValue()).writeBytes(currentFragment);
        log.debug(TLS_DATA_LOG, (Object)data.readableBytes());
        ByteBuf header = EapPacket.buildHeader((byte)1, (byte)EapPacketUtil.computeRequestId(responseId), (ByteBuf)data);
        log.debug(TLS_HEADER_LOG, (Object)header.readableBytes());
        eapTlsInfo.setReqFragmentList(reqFragmentList);
        userEapCacheInfo.setEapTlsInfo(eapTlsInfo);
        this.userCache.setUserEapCacheInfo(nasMac, clientMac, userEapCacheInfo);
        return EapPacketUtil.wrap(header, data);
    }

    protected EapPacket clientKey(FragmentType fragmentType, AuthReq authReq) {
        AccessRequest accessRequest = authReq.getAccessRequest();
        String clientMac = RadiusAttributeUtil.clientMac((RadiusRequest)accessRequest);
        EapResponse eapResponse = AccessRequestUtil.findEapResponse(accessRequest);
        DataType dataType = eapResponse.getDataType();
        byte responseId = eapResponse.getId();
        String nasMac = authReq.getNasMac();
        try {
            switch (fragmentType) {
                case FIRST_FRAGMENT: 
                case MIDDLE_FRAGMENT: 
                case LAST_FRAGMENT: {
                    throw new EapPacketException("temp");
                }
                case FULL_PACKET: {
                    return this.clientKeyFullPacket(dataType, authReq.getEapTlsPacket(), CurrentState.afterTlsClientKey(dataType), nasMac, clientMac, responseId);
                }
            }
            log.error("Invalid fragment type [{}]!", (Object)fragmentType);
        }
        catch (EapPacketException e) {
            log.warn("Filed to convert eap packet to EAP-TLS packet, authReq = {}", (Object)authReq, (Object)e);
        }
        return EapPacketUtil.failure(eapResponse);
    }

    protected EapPacket ack(AuthReq authReq, CurrentState nextState) {
        AccessRequest accessRequest = authReq.getAccessRequest();
        String clientMac = RadiusAttributeUtil.clientMac((RadiusRequest)accessRequest);
        EapResponse eapResponse = AccessRequestUtil.findEapResponse(accessRequest);
        String nasMac = authReq.getNasMac();
        DataType dataType = eapResponse.getDataType();
        UserEapCacheInfo userEapCacheInfo = authReq.getUserEapCacheInfo();
        TlsCipher tlsCipher = userEapCacheInfo.getEapTlsInfo().getTlsCipher();
        byte responseId = eapResponse.getId();
        byte[] identity = new byte[]{DataType.IDENTITY.getIndex()};
        ApplicationData respAddData = new ApplicationData(identity, tlsCipher);
        TlsPacket serverTlsPacket = new TlsPacket(Collections.singletonList(respAddData));
        EapTlsPacket respDataValue = new EapTlsPacket(0, serverTlsPacket);
        ByteBuf data = Unpooled.buffer().writeByte((int)dataType.getIndex()).writeBytes(respDataValue.toByteBuf());
        log.debug(TLS_DATA_LOG, (Object)data.readableBytes());
        ByteBuf header = EapPacket.buildHeader((byte)1, (byte)EapPacketUtil.computeRequestId(responseId), (ByteBuf)data);
        log.debug(TLS_HEADER_LOG, (Object)header.readableBytes());
        userEapCacheInfo.setCurrentState(nextState);
        this.userCache.setUserEapCacheInfo(nasMac, clientMac, userEapCacheInfo);
        return EapPacketUtil.wrap(header, data);
    }

    protected EapPacket tunnelAuth(AuthReq authReq) {
        EapTlsPacket eapTlsPacket = authReq.getEapTlsPacket();
        List reqAppDataList = eapTlsPacket.getTlsPacket().getApplicationDataList();
        try {
            return this.doTunnelAuth(authReq, reqAppDataList);
        }
        catch (TunnelAuthException e) {
            log.error("Exception caught when tunnel auth, error msg = {}", (Object)e.getMessage());
            return EapPacketUtil.INTERNAL_FAILURE;
        }
    }

    protected abstract EapPacket doTunnelAuth(AuthReq var1, List<ApplicationData> var2) throws TunnelAuthException;

    private EapPacket clientKeyFullPacket(DataType dataType, EapTlsPacket eapTlsPacket, CurrentState nextState, String nasMac, String clientMac, byte responseId) {
        TlsPacket clientTlsPacket = eapTlsPacket.getTlsPacket();
        UserEapCacheInfo userEapCacheInfo = this.userCache.getUserEapCacheInfo(nasMac, clientMac);
        UserEapCacheInfo.EapTlsInfo eapTlsInfo = userEapCacheInfo.getEapTlsInfo();
        CipherSuite cipherSuite = eapTlsInfo.getCipherSuite();
        SecurityParameters securityParameters = eapTlsInfo.getSecurityParameters();
        ByteBuf clientHelloStageHsData = eapTlsInfo.getClientHelloStageHsData();
        ByteBuf serverHelloStageHsData = eapTlsInfo.getServerHelloStageHsData();
        TlsVersion tlsVersion = TlsVersion.fromIndex((short)((short)eapTlsInfo.getVersion().intValue()));
        ArrayList<HandshakeProtocol> currentStageHsDataList = new ArrayList<HandshakeProtocol>();
        ClientKeyExchange clientKeyExchange = (ClientKeyExchange)clientTlsPacket.getHandshakeProtocol(ClientKeyExchange.class);
        currentStageHsDataList.add((HandshakeProtocol)clientKeyExchange);
        log.debug("success - get - client key exchange");
        ChangeCipherSpec changeCipherSpec = clientTlsPacket.getChangeCipherSpec();
        byte changeCipherSpecMessage = changeCipherSpec.getChangeCipherSpecMessage();
        log.debug("success - get - change cipher spec");
        boolean changeCipherSpecSuccess = this.checkChangeCipherSpec(changeCipherSpecMessage);
        log.debug("success - process - check change cipher spec - {}", (Object)changeCipherSpecSuccess);
        if (!changeCipherSpecSuccess) {
            return EapPacketUtil.failure(responseId);
        }
        Finished clientFinished = (Finished)clientTlsPacket.getHandshakeProtocol(Finished.class);
        ByteBuf encryptedClientFinished = clientFinished.getEncryptedClientFinished();
        log.debug("success - get - client finished");
        TlsCipher tlsCipher = this.constructTlsCipher(securityParameters, cipherSuite, clientKeyExchange.getEncryptedPreMaster(), tlsVersion);
        if (Objects.isNull(tlsCipher)) {
            log.warn("Failed to construct master secret or tls-cipher");
            return EapPacketUtil.failure(responseId);
        }
        log.debug("success - process - construct master secret and tls-cipher");
        TwoTuple<Boolean, byte[]> clientFinishedCheckResult = this.checkClientFinished(tlsCipher, securityParameters, ByteBufUtil.getBytes((ByteBuf)encryptedClientFinished), this.constructHsData(clientHelloStageHsData, serverHelloStageHsData, this.hsDataList2ByteBuf(currentStageHsDataList)), tlsVersion);
        Boolean clientFinishedSuccess = (Boolean)clientFinishedCheckResult.getFirst();
        log.debug("success - process - check client finished result - {}", (Object)clientFinishedSuccess);
        if (Objects.isNull(clientFinishedSuccess) || !clientFinishedSuccess.booleanValue()) {
            return EapPacketUtil.failure(responseId);
        }
        ChangeCipherSpec serverChangeCipherSpec = this.constructChangeCipherSpec(tlsVersion);
        log.debug("success - construct - change cipher spec - {}", (Object)serverChangeCipherSpec.getChangeCipherSpecMessage());
        Finished serverFinished = this.constructServerFinished(tlsCipher, securityParameters, (byte[])clientFinishedCheckResult.getSecond(), this.constructHsData(clientHelloStageHsData, serverHelloStageHsData, this.hsDataList2ByteBuf(currentStageHsDataList)), tlsVersion);
        if (Objects.isNull(serverFinished)) {
            return EapPacketUtil.failure(responseId);
        }
        log.debug("success - construct - server finished - {} bytes", (Object)serverFinished.getEncryptedServerFinished().length);
        ArrayList<Object> recordLayerList = new ArrayList<Object>();
        recordLayerList.add(serverChangeCipherSpec);
        recordLayerList.add(new Handshake(tlsVersion, new HandshakeProtocol[]{serverFinished}));
        TlsPacket serverTlsPacket = new TlsPacket(recordLayerList);
        EapTlsPacket eapTlsResp = Objects.equals(dataType, DataType.EAP_TTLS) ? new EapTlsPacket(-128, serverTlsPacket) : new EapTlsPacket(0, serverTlsPacket);
        ByteBuf data = Unpooled.buffer().writeByte((int)dataType.getIndex()).writeBytes(eapTlsResp.toByteBuf());
        log.debug(TLS_DATA_LOG, (Object)data.readableBytes());
        ByteBuf header = EapPacket.buildHeader((byte)1, (byte)EapPacketUtil.computeRequestId(responseId), (ByteBuf)data);
        log.debug(TLS_HEADER_LOG, (Object)header.readableBytes());
        eapTlsInfo.setSecurityParameters(securityParameters);
        eapTlsInfo.setTlsCipher(tlsCipher);
        userEapCacheInfo.setEapTlsInfo(eapTlsInfo);
        userEapCacheInfo.setCurrentState(nextState);
        this.userCache.setUserEapCacheInfo(nasMac, clientMac, userEapCacheInfo);
        return EapPacketUtil.wrap(header, data);
    }

    private CipherSuite parseCipherSuites(ClientHello clientHello) {
        List receivedSuiteList = clientHello.getCipherSuiteList();
        return CipherSuite.fromClientCipherSuites((List)receivedSuiteList);
    }

    private boolean checkChangeCipherSpec(byte changeCipherSpecMessage) {
        return Objects.equals((byte)1, changeCipherSpecMessage);
    }

    private TwoTuple<Boolean, byte[]> checkClientFinished(TlsCipher tlsCipher, SecurityParameters securityParameters, byte[] encryptedInputClientFinished, ByteBuf toCheckHsData, TlsVersion tlsVersion) {
        byte[] inputClientFinished = TlsUtil.decryptTlsText((TlsCipher)tlsCipher, (RecordLayerType)RecordLayerType.HANDSHAKE, (byte[])encryptedInputClientFinished);
        if (Objects.isNull(inputClientFinished)) {
            return TwoTuple.newInstance((Object)Boolean.FALSE, null);
        }
        byte[] inputVerifyData = this.eapAuthHelper.getClientVerifyData(inputClientFinished);
        byte[] verifyData = this.eapAuthHelper.buildClientFinishedVerifyData(securityParameters.getMasterSecret(), toCheckHsData, tlsVersion);
        return TwoTuple.newInstance((Object)Arrays.equals(inputVerifyData, verifyData), (Object)this.eapAuthHelper.getClientFinished(inputClientFinished));
    }

    private ByteBuf hsDataList2ByteBuf(List<HandshakeProtocol> handshakeProtocolList) {
        ByteBuf totalHsData = Unpooled.buffer();
        for (HandshakeProtocol handshakeProtocol : handshakeProtocolList) {
            totalHsData.writeBytes(handshakeProtocol.getData());
        }
        return totalHsData;
    }

    private ByteBuf constructHsData(ByteBuf ... hsDataList) {
        ByteBuf totalHsData = Unpooled.buffer();
        for (ByteBuf hsData : hsDataList) {
            totalHsData.writeBytes(hsData.copy());
        }
        return totalHsData;
    }

    private ServerHello constructServerHello(byte[] random2, byte[] sessionId, CipherSuite cipherSuite, TlsVersion tlsVersion) {
        return new ServerHello(tlsVersion, random2, sessionId, Short.valueOf(cipherSuite.getIndex()), 0);
    }

    private ServerHelloDone constructServerHelloDone() {
        return new ServerHelloDone();
    }

    private Certificate constructServerCertificate() {
        ByteBuf certificateByteBuf = Unpooled.buffer();
        CertificateApiService certificateApiServiceBean = this.aaaExtendServiceFactory.getCertificateApiServiceBean();
        ServerCertificateChainApiDTO serverCertificateChain = null;
        if (!Objects.isNull(certificateApiServiceBean)) {
            serverCertificateChain = certificateApiServiceBean.getServerCertificateChain();
            if (Objects.isNull(serverCertificateChain)) {
                log.warn("get serverCertificate failed.");
                return null;
            }
        } else {
            return null;
        }
        for (byte[] content : serverCertificateChain.getCertificateContents()) {
            certificateByteBuf.writeMedium(content.length).writeBytes(content);
        }
        return new Certificate(certificateByteBuf, certificateByteBuf.readableBytes());
    }

    private CertificateRequest constructClientCertificationReq(TlsVersion tlsVersion) {
        return new CertificateRequest(tlsVersion, this.constructSignHashAlgorithms(), new byte[]{CertificateType.RSA_SIGN.getIndex()});
    }

    private TlsCipher constructTlsCipher(SecurityParameters securityParameters, CipherSuite cipherSuite, ByteBuf encryptedPreMasterSecret, TlsVersion tlsVersion) {
        try {
            ServerCertificateChainApiDTO serverCertificateChain = null;
            CertificateApiService certificateApiServiceBean = this.aaaExtendServiceFactory.getCertificateApiServiceBean();
            if (!Objects.isNull(certificateApiServiceBean)) {
                serverCertificateChain = certificateApiServiceBean.getServerCertificateChain();
                if (Objects.isNull(serverCertificateChain)) {
                    log.warn("get serverCertificateChain failed.");
                    return null;
                }
            } else {
                log.warn("get certificateApiServiceBean failed.");
                return null;
            }
            byte[] preMasterSecret = this.eapAuthHelper.decryptByCertificatePrivateKey(ByteBufUtil.getBytes((ByteBuf)encryptedPreMasterSecret), serverCertificateChain.getPrivateKey());
            byte[] masterSecret = this.eapAuthHelper.buildMasterSecret(CipherUtil.concat((byte[])securityParameters.getClientRandom(), (byte[])securityParameters.getServerRandom()), preMasterSecret, tlsVersion);
            securityParameters.setMasterSecret(masterSecret);
            return TlsCipher.create((CipherSuite)cipherSuite, (SecurityParameters)securityParameters, (TlsVersion)tlsVersion);
        }
        catch (Exception e) {
            log.warn("Failed to decrypt pre-master-secret [{}]", (Object)encryptedPreMasterSecret);
            return null;
        }
    }

    private ChangeCipherSpec constructChangeCipherSpec(TlsVersion tlsVersion) {
        return new ChangeCipherSpec(tlsVersion);
    }

    private Finished constructServerFinished(TlsCipher tlsCipher, SecurityParameters securityParameters, byte[] clientFinished, ByteBuf toCheckHsData, TlsVersion tlsVersion) {
        toCheckHsData.writeBytes(clientFinished);
        byte[] serverFinishedVerifyData = this.eapAuthHelper.buildServerFinishedVerifyData(securityParameters.getMasterSecret(), toCheckHsData, tlsVersion);
        ByteBuf serverFinished = Unpooled.buffer().writeByte((int)HandshakeType.FINISHED.getIndex()).writeMedium(serverFinishedVerifyData.length).writeBytes(serverFinishedVerifyData);
        byte[] encryptedServerFinished = TlsUtil.encryptTlsText((TlsCipher)tlsCipher, (RecordLayerType)RecordLayerType.HANDSHAKE, (byte[])ByteBufUtil.getBytes((ByteBuf)serverFinished));
        return Objects.isNull(encryptedServerFinished) ? null : new Finished(encryptedServerFinished);
    }

    private List<SignatureHashAlgorithm> constructSignHashAlgorithms() {
        ArrayList<SignatureHashAlgorithm> list = new ArrayList<SignatureHashAlgorithm>();
        list.add(SignatureHashAlgorithm.RSA_PKCS1_SHA1);
        list.add(SignatureHashAlgorithm.RSA_PKCS1_SHA256);
        list.add(SignatureHashAlgorithm.SHA224_RSA);
        list.add(SignatureHashAlgorithm.RSA_PKCS1_SHA384);
        list.add(SignatureHashAlgorithm.RSA_PKCS1_SHA512);
        return list;
    }
}

