/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.core.authentication.eap.service.impl;

import cn.hutool.core.util.PrimitiveArrayUtil;
import com.tplink.cdd.component.aaa.core.authentication.cache.UserEapCacheInfo;
import com.tplink.cdd.component.aaa.core.authentication.dto.AuthReq;
import com.tplink.cdd.component.aaa.core.authentication.eap.annotation.Action;
import com.tplink.cdd.component.aaa.core.authentication.eap.enums.ActionCategory;
import com.tplink.cdd.component.aaa.core.authentication.eap.enums.CurrentState;
import com.tplink.cdd.component.aaa.core.authentication.eap.enums.TlsTunnelProtocolEnum;
import com.tplink.cdd.component.aaa.core.authentication.eap.service.ActionBucket;
import com.tplink.cdd.component.aaa.core.authentication.eap.service.impl.TlsAuthenticator;
import com.tplink.cdd.component.aaa.core.authentication.eap.tunnel.EapMd5Authenticator;
import com.tplink.cdd.component.aaa.core.authentication.eap.tunnel.MsChapv2Authenticator;
import com.tplink.cdd.component.aaa.core.authentication.utils.EapPacketUtil;
import com.tplink.cdd.component.aaa.core.authentication.utils.GetUserInfoHelper;
import com.tplink.cdd.component.aaa.server.api.extend.EapTunnelProtocolApiService;
import com.tplink.cdd.component.aaa.server.utils.AccessRequestUtil;
import com.tplink.cdd.component.aaa.server.utils.CustomPIIMaskUtil;
import com.tplink.cdd.radius.common.TunnelAuthException;
import com.tplink.cdd.radius.common.dictionary.Dictionary;
import com.tplink.cdd.radius.common.eap.EapPacketException;
import com.tplink.cdd.radius.common.eap.enums.DataType;
import com.tplink.cdd.radius.common.eap.enums.FragmentType;
import com.tplink.cdd.radius.common.eap.enums.OpCode;
import com.tplink.cdd.radius.common.eap.packet.BaseEapPacket;
import com.tplink.cdd.radius.common.eap.packet.EapPacket;
import com.tplink.cdd.radius.common.eap.packet.EapResponse;
import com.tplink.cdd.radius.common.eap.packet.data.EapTlsPacket;
import com.tplink.cdd.radius.common.enums.AuthProtocol;
import com.tplink.cdd.radius.common.packet.request.AccessRequest;
import com.tplink.cdd.radius.common.packet.request.RadiusRequest;
import com.tplink.cdd.radius.common.tls.CipherSuite.TlsCipher;
import com.tplink.cdd.radius.common.tls.recordlayer.ApplicationData;
import com.tplink.cdd.radius.common.tls.recordlayer.RecordLayer;
import com.tplink.cdd.radius.common.utils.RadiusAttributeUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class PeapActionBucket
extends TlsAuthenticator
implements ActionBucket {
    private static final Logger log = LoggerFactory.getLogger(PeapActionBucket.class);
    @Autowired
    private GetUserInfoHelper getUserInfoHelper;

    @Action(value=ActionCategory.PEAP_ACTION_INIT)
    public EapPacket action0(AuthReq authReq) {
        return super.init(authReq, DataType.PEAP, CurrentState.PEAP_STATE_READY);
    }

    @Action(value=ActionCategory.PEAP_ACTION_PROCESS_CLIENT_HELLO)
    public EapPacket action1(AuthReq authReq) {
        return super.clientHello(authReq, CurrentState.PEAP_STATE_SERVER_HELLO_SEND_FRAGMENT_ING, CurrentState.PEAP_STATE_WAIT_CLIENT_KEY);
    }

    @Action(value=ActionCategory.PEAP_ACTION_SEND_SERVER_HELLO_NEXT_FRAGMENT)
    public EapPacket action2(AuthReq authReq) {
        return super.reqServerHelloNextFragment(authReq, CurrentState.PEAP_STATE_WAIT_CLIENT_KEY, CurrentState.PEAP_STATE_SERVER_HELLO_SEND_FRAGMENT_ING);
    }

    @Action(value=ActionCategory.PEAP_ACTION_PROCESS_CLIENT_KEY_FULL)
    public EapPacket action3(AuthReq authReq) {
        return super.clientKey(FragmentType.FULL_PACKET, authReq);
    }

    @Action(value=ActionCategory.PEAP_ACTION_PROCESS_ACK)
    public EapPacket action4(AuthReq authReq) {
        return super.ack(authReq, CurrentState.PEAP_STATE_WAIT_TUNNEL_AUTHENTICATION);
    }

    @Action(value=ActionCategory.PEAP_ACTION_PROCESS_TUNNEL_AUTHENTICATION_START)
    public EapPacket action5(AuthReq authReq) {
        return super.tunnelAuth(authReq);
    }

    @Action(value=ActionCategory.PEAP_ACTION_PROCESS_TUNNEL_AUTHENTICATION_MD5_CHALLENGE)
    public EapPacket action6(AuthReq authReq) {
        return this.dealMd5Challenge(authReq);
    }

    @Action(value=ActionCategory.PEAP_ACTION_PROCESS_TUNNEL_AUTHENTICATION_WAIT_MSCHAPV2_RESPONSE)
    public EapPacket action7(AuthReq authReq) {
        return this.dealMsChapV2WaitResponse(authReq);
    }

    @Action(value=ActionCategory.PEAP_ACTION_PROCESS_TUNNEL_AUTHENTICATION_WAIT_MSCHAPV2_VERIFIED_RESPONSE)
    public EapPacket action8(AuthReq authReq) {
        return this.dealMsChapV2VerifyResponse(authReq);
    }

    @Action(value=ActionCategory.PEAP_ACTION_PROCESS_TUNNEL_AUTHENTICATION_FINISH)
    public EapPacket action9(AuthReq authReq) {
        return this.dealTunnelFinish(authReq);
    }

    @Override
    protected EapPacket doTunnelAuth(AuthReq authReq, List<ApplicationData> reqAppDataList) throws TunnelAuthException {
        List<TlsTunnelProtocolEnum> tlsTunnelAllowProtocol;
        TlsTunnelProtocolEnum tlsTunnelDefaultProtocol;
        String password;
        AccessRequest accessRequest = authReq.getAccessRequest();
        String clientMac = RadiusAttributeUtil.clientMac((RadiusRequest)accessRequest);
        EapResponse eapResponse = AccessRequestUtil.findEapResponse(accessRequest);
        DataType dataType = eapResponse.getDataType();
        byte responseId = eapResponse.getId();
        UserEapCacheInfo userEapCacheInfo = authReq.getUserEapCacheInfo();
        TlsCipher tlsCipher = userEapCacheInfo.getEapTlsInfo().getTlsCipher();
        Optional<byte[]> tunnelOptional = reqAppDataList.stream().map(ApplicationData::getPlainText).filter(PrimitiveArrayUtil::isNotEmpty).findFirst();
        if (!tunnelOptional.isPresent()) {
            throw new TunnelAuthException("Failed to parse tunnel EAP packet");
        }
        byte[] tunnel = tunnelOptional.get();
        byte firstByte = tunnel[0];
        DataType extensionsDataType = DataType.fromIndex((byte)firstByte);
        if (Objects.isNull(extensionsDataType)) {
            throw new TunnelAuthException("Unsupported Extensions EAP data type [" + firstByte + "]");
        }
        byte[] extensionsDataValue = Arrays.copyOfRange(tunnel, 1, tunnel.length);
        String username = new String(extensionsDataValue, StandardCharsets.UTF_8);
        log.debug("tunnel identity username = {}", (Object)CustomPIIMaskUtil.hash(username));
        try {
            password = this.getUserInfoHelper.getPassword(username, accessRequest, authReq);
        }
        catch (NoSuchElementException e) {
            return EapPacketUtil.failure(responseId);
        }
        EapTunnelProtocolApiService eapTunnelProtocolApiService = this.aaaExtendServiceFactory.getEapTunnelProtocolApiServiceBean();
        if (Objects.isNull(eapTunnelProtocolApiService)) {
            tlsTunnelDefaultProtocol = TlsTunnelProtocolEnum.EAP_MD5;
            tlsTunnelAllowProtocol = TlsTunnelProtocolEnum.peapAllTunnelProtocol();
        } else {
            tlsTunnelDefaultProtocol = eapTunnelProtocolApiService.getDefaultEapTunnel(authReq);
            tlsTunnelAllowProtocol = eapTunnelProtocolApiService.getAllowedEapTunnel(authReq);
        }
        switch (extensionsDataType) {
            case IDENTITY: {
                TlsTunnelProtocolEnum usedTunnelProtocol = null;
                if (tlsTunnelDefaultProtocol.isEapProtocol()) {
                    usedTunnelProtocol = tlsTunnelDefaultProtocol;
                } else if (tlsTunnelAllowProtocol.contains((Object)TlsTunnelProtocolEnum.EAP_MD5)) {
                    usedTunnelProtocol = TlsTunnelProtocolEnum.EAP_MD5;
                } else if (tlsTunnelAllowProtocol.contains((Object)TlsTunnelProtocolEnum.EAP_MSCHAP_V2)) {
                    usedTunnelProtocol = TlsTunnelProtocolEnum.EAP_MSCHAP_V2;
                }
                if (Objects.isNull((Object)usedTunnelProtocol)) {
                    log.debug("unsupported eap tunnel protocol");
                    return EapPacketUtil.failure(responseId);
                }
                switch (usedTunnelProtocol) {
                    case EAP_MD5: {
                        EapMd5Authenticator eapMd5Authenticator = new EapMd5Authenticator();
                        EapPacket innerEapPacket = eapMd5Authenticator.setupRequest(this.eapAuthHelper, responseId, password);
                        userEapCacheInfo.setTunnelAuthenticator(eapMd5Authenticator);
                        userEapCacheInfo.setCurrentState(CurrentState.PEAP_STATE_WAIT_MD5_CHALLENGE);
                        userEapCacheInfo.setTunnelUsername(username);
                        userEapCacheInfo.setPassword(password);
                        this.userCache.setUserEapCacheInfo(authReq.getNasMac(), clientMac, userEapCacheInfo);
                        return EapPacketUtil.fromRecordLayerList(dataType, EapPacketUtil.computeRequestId(responseId), new RecordLayer[]{new ApplicationData(ByteBufUtil.getBytes((ByteBuf)innerEapPacket.getData()), tlsCipher)});
                    }
                    case EAP_MSCHAP_V2: {
                        MsChapv2Authenticator msChapv2Authenticator = new MsChapv2Authenticator();
                        byte[] sendChallenge = msChapv2Authenticator.sendChallenge(responseId, extensionsDataValue);
                        ApplicationData applicationData = new ApplicationData(sendChallenge, tlsCipher);
                        userEapCacheInfo.setCurrentState(CurrentState.PEAP_STATE_WAIT_MSCHAPV2_RESPONSE);
                        userEapCacheInfo.setTunnelAuthenticator(msChapv2Authenticator);
                        userEapCacheInfo.setTunnelUsername(username);
                        userEapCacheInfo.setPassword(password);
                        this.userCache.setUserEapCacheInfo(authReq.getNasMac(), clientMac, userEapCacheInfo);
                        return EapPacketUtil.fromRecordLayerList(dataType, EapPacketUtil.computeRequestId(responseId), new RecordLayer[]{applicationData});
                    }
                }
                log.error("unsupported tunnel protocol: {}", (Object)usedTunnelProtocol.name());
                throw new TunnelAuthException("Unsupported tunnel protocol: " + usedTunnelProtocol.name());
            }
            case NAK: {
                log.debug("{} start PEAP-NAK", (Object)CustomPIIMaskUtil.hash(authReq.getUsername()));
                AuthProtocol nakDesiredAuthProtocol = this.eapAuthHelper.parseNakDesiredAuthProtocol(Unpooled.wrappedBuffer((byte[])extensionsDataValue));
                TlsTunnelProtocolEnum desiredProtocol = TlsTunnelProtocolEnum.mapperAuthProtocol(nakDesiredAuthProtocol);
                if (Objects.isNull((Object)desiredProtocol) || !tlsTunnelAllowProtocol.contains((Object)desiredProtocol)) {
                    log.debug("Unallowed peap tunnel protocol: {}", (Object)nakDesiredAuthProtocol.getName());
                    return EapPacketUtil.failure(responseId);
                }
                if (AuthProtocol.MS_CHAP_V2 == nakDesiredAuthProtocol) {
                    MsChapv2Authenticator msChapv2Authenticator = new MsChapv2Authenticator();
                    byte[] sendChallenge = msChapv2Authenticator.sendChallenge(responseId, extensionsDataValue);
                    ApplicationData applicationData = new ApplicationData(sendChallenge, tlsCipher);
                    userEapCacheInfo.setCurrentState(CurrentState.PEAP_STATE_WAIT_MSCHAPV2_RESPONSE);
                    userEapCacheInfo.setTunnelAuthenticator(msChapv2Authenticator);
                    this.userCache.setUserEapCacheInfo(authReq.getNasMac(), clientMac, userEapCacheInfo);
                    return EapPacketUtil.fromRecordLayerList(dataType, EapPacketUtil.computeRequestId(responseId), new RecordLayer[]{applicationData});
                }
                if (AuthProtocol.EAP_MD5 == nakDesiredAuthProtocol) {
                    EapMd5Authenticator eapMd5Authenticator = new EapMd5Authenticator();
                    EapPacket innerEapPacket = eapMd5Authenticator.setupRequest(this.eapAuthHelper, responseId, password);
                    userEapCacheInfo.setTunnelAuthenticator(eapMd5Authenticator);
                    userEapCacheInfo.setCurrentState(CurrentState.PEAP_STATE_WAIT_MD5_CHALLENGE);
                    this.userCache.setUserEapCacheInfo(authReq.getNasMac(), clientMac, userEapCacheInfo);
                    return EapPacketUtil.fromRecordLayerList(dataType, EapPacketUtil.computeRequestId(responseId), new RecordLayer[]{new ApplicationData(ByteBufUtil.getBytes((ByteBuf)innerEapPacket.getData()), tlsCipher)});
                }
                throw new TunnelAuthException("Unsupported NAK desired auth type [" + nakDesiredAuthProtocol + "]");
            }
        }
        throw new TunnelAuthException("Unsupported Extensions EAP data type [" + extensionsDataType + "]");
    }

    private EapPacket dealMd5Challenge(AuthReq authReq) {
        UserEapCacheInfo userEapCacheInfo = authReq.getUserEapCacheInfo();
        AccessRequest accessRequest = authReq.getAccessRequest();
        String clientMac = RadiusAttributeUtil.clientMac((RadiusRequest)accessRequest);
        EapResponse eapResponse = AccessRequestUtil.findEapResponse(accessRequest);
        byte responseId = eapResponse.getId();
        Dictionary dictionary = accessRequest.getDictionary();
        DataType dataType = eapResponse.getDataType();
        EapTlsPacket eapTlsPacket = authReq.getEapTlsPacket();
        List reqAppDataList = eapTlsPacket.getTlsPacket().getApplicationDataList();
        TlsCipher tlsCipher = userEapCacheInfo.getEapTlsInfo().getTlsCipher();
        Optional<byte[]> tunnelOptional = reqAppDataList.stream().map(ApplicationData::getPlainText).filter(PrimitiveArrayUtil::isNotEmpty).findFirst();
        if (!tunnelOptional.isPresent()) {
            log.warn("Failed to parse tunnel EAP packet");
            return EapPacketUtil.failure(responseId);
        }
        byte[] tunnel = tunnelOptional.get();
        byte firstByte = tunnel[0];
        DataType extensionsDataType = DataType.fromIndex((byte)firstByte);
        if (Objects.isNull(extensionsDataType)) {
            log.warn("Unsupported Extensions EAP data type [" + firstByte + "]");
            return EapPacketUtil.failure(responseId);
        }
        byte[] extensionsDataValue = Arrays.copyOfRange(tunnel, 1, tunnel.length);
        if (DataType.NAK == extensionsDataType) {
            AuthProtocol nakDesiredAuthProtocol = this.eapAuthHelper.parseNakDesiredAuthProtocol(Unpooled.wrappedBuffer((byte[])extensionsDataValue));
            if (AuthProtocol.MS_CHAP_V2 == nakDesiredAuthProtocol) {
                MsChapv2Authenticator msChapv2Authenticator = new MsChapv2Authenticator();
                byte[] sendChallenge = msChapv2Authenticator.sendChallenge(responseId, extensionsDataValue);
                ApplicationData applicationData = new ApplicationData(sendChallenge, tlsCipher);
                userEapCacheInfo.setCurrentState(CurrentState.PEAP_STATE_WAIT_MSCHAPV2_RESPONSE);
                userEapCacheInfo.setTunnelAuthenticator(msChapv2Authenticator);
                this.userCache.setUserEapCacheInfo(authReq.getNasMac(), clientMac, userEapCacheInfo);
                return EapPacketUtil.fromRecordLayerList(dataType, EapPacketUtil.computeRequestId(responseId), new RecordLayer[]{applicationData});
            }
            log.debug("Unsupported NAK desired auth type [" + nakDesiredAuthProtocol + "]");
            return EapPacketUtil.failure(responseId);
        }
        EapMd5Authenticator eapMd5Authenticator1 = (EapMd5Authenticator)userEapCacheInfo.getTunnelAuthenticator();
        boolean authSuccess = eapMd5Authenticator1.processChallenge(Unpooled.wrappedBuffer((byte[])extensionsDataValue));
        log.debug("auth result = {}", (Object)authSuccess);
        ByteBuf data = Unpooled.buffer().writeByte(33).writeByte(128).writeByte(3).writeShort(2).writeShort(authSuccess ? 1 : 2);
        log.debug("success - build - extensions request packet data - {} bytes", (Object)data.readableBytes());
        ByteBuf header = EapPacket.buildHeader((byte)1, (byte)EapPacketUtil.computeRequestId(responseId), (ByteBuf)data);
        log.debug("success - build - extensions request packet header - {} bytes", (Object)header.readableBytes());
        userEapCacheInfo.setCurrentState(CurrentState.PEAP_STATE_TUNNEL_FINISH);
        this.userCache.setUserEapCacheInfo(authReq.getNasMac(), clientMac, userEapCacheInfo);
        return EapPacketUtil.fromRecordLayerList(dataType, EapPacketUtil.computeRequestId(responseId), new RecordLayer[]{new ApplicationData(ByteBufUtil.getBytes((ByteBuf)EapPacketUtil.wrap(header, data).toByteBuf()), tlsCipher)});
    }

    private EapPacket dealMsChapV2WaitResponse(AuthReq authReq) {
        UserEapCacheInfo userEapCacheInfo = authReq.getUserEapCacheInfo();
        TlsCipher tlsCipher = userEapCacheInfo.getEapTlsInfo().getTlsCipher();
        AccessRequest accessRequest = authReq.getAccessRequest();
        EapResponse eapResponse = AccessRequestUtil.findEapResponse(accessRequest);
        DataType dataType = eapResponse.getDataType();
        byte responseId = eapResponse.getId();
        EapTlsPacket eapTlsPacket = authReq.getEapTlsPacket();
        List reqAppDataList = eapTlsPacket.getTlsPacket().getApplicationDataList();
        Optional<byte[]> tunnelOptional = reqAppDataList.stream().map(ApplicationData::getPlainText).filter(PrimitiveArrayUtil::isNotEmpty).findFirst();
        if (!tunnelOptional.isPresent()) {
            log.warn("Failed to parse tunnel EAP packet");
            return EapPacketUtil.failure(responseId);
        }
        byte[] tunnel = tunnelOptional.get();
        byte[] extensionsDataValue = Arrays.copyOfRange(tunnel, 1, tunnel.length);
        String clientMac = RadiusAttributeUtil.clientMac((RadiusRequest)accessRequest);
        try {
            MsChapv2Authenticator msChapv2Authenticator = (MsChapv2Authenticator)userEapCacheInfo.getTunnelAuthenticator();
            byte[] successRequest = msChapv2Authenticator.processResponse(extensionsDataValue, authReq);
            if (successRequest == null || successRequest.length == 0) {
                return EapPacketUtil.failure(responseId);
            }
            ApplicationData applicationData = new ApplicationData(successRequest, tlsCipher);
            userEapCacheInfo.setTunnelAuthenticator(msChapv2Authenticator);
            userEapCacheInfo.setCurrentState(CurrentState.PEAP_STATE_WAIT_MSCHAPV2_VERIFIED_RESPONSE);
            this.userCache.setUserEapCacheInfo(authReq.getNasMac(), clientMac, userEapCacheInfo);
            return EapPacketUtil.fromRecordLayerList(dataType, EapPacketUtil.computeRequestId(responseId), new RecordLayer[]{applicationData});
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return EapPacketUtil.failure(responseId);
        }
    }

    private EapPacket dealMsChapV2VerifyResponse(AuthReq authReq) {
        UserEapCacheInfo userEapCacheInfo = authReq.getUserEapCacheInfo();
        TlsCipher tlsCipher = userEapCacheInfo.getEapTlsInfo().getTlsCipher();
        AccessRequest accessRequest = authReq.getAccessRequest();
        EapResponse eapResponse = AccessRequestUtil.findEapResponse(accessRequest);
        String clientMac = RadiusAttributeUtil.clientMac((RadiusRequest)accessRequest);
        DataType dataType = eapResponse.getDataType();
        byte responseId = eapResponse.getId();
        EapTlsPacket eapTlsPacket = authReq.getEapTlsPacket();
        List reqAppDataList = eapTlsPacket.getTlsPacket().getApplicationDataList();
        Optional<byte[]> tunnelOptional = reqAppDataList.stream().map(ApplicationData::getPlainText).filter(PrimitiveArrayUtil::isNotEmpty).findFirst();
        if (!tunnelOptional.isPresent()) {
            log.warn("Failed to parse tunnel EAP packet");
            return EapPacketUtil.failure(responseId);
        }
        byte[] tunnel = tunnelOptional.get();
        log.warn("now get verified response with opcode {}", (Object)tunnel[1]);
        if (OpCode.SUCCESS.getIndex() == tunnel[1]) {
            byte[] tlvSuccess = ByteBufUtil.getBytes((ByteBuf)EapPacketUtil.tlvSuccess(responseId).toByteBuf());
            ApplicationData applicationData = new ApplicationData(tlvSuccess, tlsCipher);
            userEapCacheInfo.setCurrentState(CurrentState.PEAP_STATE_TUNNEL_FINISH);
            this.userCache.setUserEapCacheInfo(authReq.getNasMac(), clientMac, userEapCacheInfo);
            return EapPacketUtil.fromRecordLayerList(dataType, EapPacketUtil.computeRequestId(responseId), new RecordLayer[]{applicationData});
        }
        return EapPacketUtil.failure(responseId);
    }

    private EapPacket dealTunnelFinish(AuthReq authReq) {
        UserEapCacheInfo userEapCacheInfo = authReq.getUserEapCacheInfo();
        AccessRequest accessRequest = authReq.getAccessRequest();
        EapResponse eapResponse = AccessRequestUtil.findEapResponse(accessRequest);
        String clientMac = RadiusAttributeUtil.clientMac((RadiusRequest)accessRequest);
        byte responseId = eapResponse.getId();
        EapTlsPacket eapTlsPacket = authReq.getEapTlsPacket();
        List reqAppDataList = eapTlsPacket.getTlsPacket().getApplicationDataList();
        Optional<byte[]> tunnelOptional = reqAppDataList.stream().map(ApplicationData::getPlainText).filter(PrimitiveArrayUtil::isNotEmpty).findFirst();
        if (!tunnelOptional.isPresent()) {
            log.warn("Failed to parse tunnel EAP packet");
            return EapPacketUtil.failure(responseId);
        }
        byte[] tunnel = tunnelOptional.get();
        byte firstByte = tunnel[0];
        if (Objects.equals((byte)2, firstByte)) {
            try {
                log.warn("now get full eappacket with response code 2");
                EapResponse tunnelEapResp = (EapResponse)BaseEapPacket.fromByteBuf((ByteBuf)Unpooled.wrappedBuffer((byte[])tunnel));
                ByteBuf dataValue = tunnelEapResp.getDataValue();
                dataValue.readBytes(4);
                short status = dataValue.readShort();
                if (status == 1) {
                    userEapCacheInfo.setCurrentState(CurrentState.afterTunnelAuth(authReq));
                    this.userCache.setUserEapCacheInfo(authReq.getNasMac(), clientMac, userEapCacheInfo);
                }
                return status == 1 ? EapPacketUtil.success(responseId) : EapPacketUtil.failure(responseId);
            }
            catch (EapPacketException e) {
                log.warn("Exception when parse tunnel EAP packet");
                return EapPacketUtil.failure(responseId);
            }
        }
        log.warn("Failed to parse tunnel finished EAP packet");
        return EapPacketUtil.failure(responseId);
    }
}

