/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.core.authentication.eap.service.impl;

import com.tplink.cdd.component.aaa.core.authentication.cache.UserEapCacheInfo;
import com.tplink.cdd.component.aaa.core.authentication.dto.AuthReq;
import com.tplink.cdd.component.aaa.core.authentication.eap.annotation.Action;
import com.tplink.cdd.component.aaa.core.authentication.eap.enums.ActionCategory;
import com.tplink.cdd.component.aaa.core.authentication.eap.enums.CurrentState;
import com.tplink.cdd.component.aaa.core.authentication.eap.enums.TlsTunnelProtocolEnum;
import com.tplink.cdd.component.aaa.core.authentication.eap.service.ActionBucket;
import com.tplink.cdd.component.aaa.core.authentication.eap.service.impl.TlsAuthenticator;
import com.tplink.cdd.component.aaa.core.authentication.eap.tunnel.EapMd5Authenticator;
import com.tplink.cdd.component.aaa.core.authentication.eap.tunnel.MsChapv2Authenticator;
import com.tplink.cdd.component.aaa.core.authentication.utils.EapPacketUtil;
import com.tplink.cdd.component.aaa.core.authentication.utils.GetUserInfoHelper;
import com.tplink.cdd.component.aaa.server.api.extend.EapTunnelProtocolApiService;
import com.tplink.cdd.component.aaa.server.utils.AccessRequestUtil;
import com.tplink.cdd.component.aaa.server.utils.CustomPIIMaskUtil;
import com.tplink.cdd.radius.common.RadiusPacketException;
import com.tplink.cdd.radius.common.TunnelAuthException;
import com.tplink.cdd.radius.common.attribute.type.RadiusAttribute;
import com.tplink.cdd.radius.common.dictionary.Dictionary;
import com.tplink.cdd.radius.common.eap.enums.DataType;
import com.tplink.cdd.radius.common.eap.enums.FragmentType;
import com.tplink.cdd.radius.common.eap.enums.OpCode;
import com.tplink.cdd.radius.common.eap.packet.EapPacket;
import com.tplink.cdd.radius.common.eap.packet.EapResponse;
import com.tplink.cdd.radius.common.eap.packet.data.EapTlsPacket;
import com.tplink.cdd.radius.common.enums.AuthProtocol;
import com.tplink.cdd.radius.common.packet.request.AccessRequest;
import com.tplink.cdd.radius.common.packet.request.RadiusRequest;
import com.tplink.cdd.radius.common.tls.CipherSuite.TlsCipher;
import com.tplink.cdd.radius.common.tls.recordlayer.ApplicationData;
import com.tplink.cdd.radius.common.tls.recordlayer.RecordLayer;
import com.tplink.cdd.radius.common.ttls.TunnelReq;
import com.tplink.cdd.radius.common.utils.RadiusAttributeUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class EapTtlsActionBucket
extends TlsAuthenticator
implements ActionBucket {
    private static final Logger log = LoggerFactory.getLogger(EapTtlsActionBucket.class);
    @Autowired
    private GetUserInfoHelper getUserInfoHelper;

    @Action(value=ActionCategory.EAP_TTLS_ACTION_INIT)
    public EapPacket action0(AuthReq authReq) {
        return super.init(authReq, DataType.EAP_TTLS, CurrentState.EAP_TTLS_STATE_READY);
    }

    @Action(value=ActionCategory.EAP_TTLS_ACTION_PROCESS_CLIENT_HELLO)
    public EapPacket action1(AuthReq authReq) {
        return super.clientHello(authReq, CurrentState.EAP_TTLS_STATE_SERVER_HELLO_SEND_FRAGMENT_ING, CurrentState.EAP_TTLS_STATE_WAIT_CLIENT_KEY);
    }

    @Action(value=ActionCategory.EAP_TTLS_ACTION_SEND_SERVER_HELLO_NEXT_FRAGMENT)
    public EapPacket action2(AuthReq authReq) {
        return super.reqServerHelloNextFragment(authReq, CurrentState.EAP_TTLS_STATE_WAIT_CLIENT_KEY, CurrentState.EAP_TTLS_STATE_SERVER_HELLO_SEND_FRAGMENT_ING);
    }

    @Action(value=ActionCategory.EAP_TTLS_ACTION_PROCESS_CLIENT_KEY_FULL)
    public EapPacket action3(AuthReq authReq) {
        return super.clientKey(FragmentType.FULL_PACKET, authReq);
    }

    @Action(value=ActionCategory.EAP_TTLS_ACTION_PROCESS_TUNNEL_AUTHENTICATION_START)
    public EapPacket action4(AuthReq authReq) {
        return super.tunnelAuth(authReq);
    }

    @Action(value=ActionCategory.EAP_TTLS_ACTION_PROCESS_TUNNEL_AUTHENTICATION_EAP_MD5_CHALLENGE)
    public EapPacket action5(AuthReq authReq) {
        return this.dealEapMd5Challenge(authReq);
    }

    @Action(value=ActionCategory.EAP_TTLS_ACTION_PROCESS_TUNNEL_AUTHENTICATION_WAIT_EAPMSCHAPV2_RESPONSE)
    public EapPacket action6(AuthReq authReq) {
        return this.dealEapMsChapV2WaitResponse(authReq);
    }

    @Action(value=ActionCategory.EAP_TTLS_ACTION_PROCESS_TUNNEL_AUTHENTICATION_WAIT_EAPMSCHAPV2_VERIFIED_RESPONSE)
    public EapPacket action7(AuthReq authReq) {
        return this.dealEapMsChapV2VerifiedResponse(authReq);
    }

    @Override
    protected EapPacket doTunnelAuth(AuthReq authReq, List<ApplicationData> reqAppDataList) throws TunnelAuthException {
        List<TlsTunnelProtocolEnum> tlsTunnelAllowProtocol;
        TlsTunnelProtocolEnum tlsTunnelDefaultProtocol;
        TunnelReq tunnelReq;
        AccessRequest accessRequest = authReq.getAccessRequest();
        EapResponse eapResponse = AccessRequestUtil.findEapResponse(accessRequest);
        String clientMac = RadiusAttributeUtil.clientMac((RadiusRequest)accessRequest);
        DataType dataType = eapResponse.getDataType();
        byte responseId = eapResponse.getId();
        Dictionary dictionary = accessRequest.getDictionary();
        List<RadiusAttribute> diameterAttributeList = this.eapAuthHelper.appDataList2AvpList(dictionary, reqAppDataList);
        try {
            tunnelReq = TunnelReq.fromRadiusAttributeList(diameterAttributeList);
        }
        catch (RadiusPacketException e) {
            throw new TunnelAuthException("Failed to parse tunnel-request");
        }
        UserEapCacheInfo userEapCacheInfo = authReq.getUserEapCacheInfo();
        TlsCipher tlsCipher = userEapCacheInfo.getEapTlsInfo().getTlsCipher();
        EapTunnelProtocolApiService eapTunnelProtocolApiService = this.aaaExtendServiceFactory.getEapTunnelProtocolApiServiceBean();
        if (Objects.isNull(eapTunnelProtocolApiService)) {
            tlsTunnelDefaultProtocol = TlsTunnelProtocolEnum.EAP_MD5;
            tlsTunnelAllowProtocol = TlsTunnelProtocolEnum.ttlsAllTunnelProtocol();
        } else {
            tlsTunnelDefaultProtocol = eapTunnelProtocolApiService.getDefaultEapTunnel(authReq);
            tlsTunnelAllowProtocol = eapTunnelProtocolApiService.getAllowedEapTunnel(authReq);
        }
        switch (tunnelReq.getAuthType()) {
            case EAP_MESSAGE: {
                EapResponse tunnelEapResp = tunnelReq.getEapResponse();
                DataType tunnelDataType = tunnelEapResp.getDataType();
                switch (tunnelDataType) {
                    case IDENTITY: {
                        String password;
                        String username = this.getUsernameFromTunnelEapResp(tunnelEapResp);
                        try {
                            password = this.getUserInfoHelper.getPassword(username, accessRequest, authReq);
                        }
                        catch (NoSuchElementException e) {
                            return EapPacketUtil.failure(responseId);
                        }
                        TlsTunnelProtocolEnum usedTunnelProtocol = null;
                        if (tlsTunnelDefaultProtocol.isEapProtocol()) {
                            usedTunnelProtocol = tlsTunnelDefaultProtocol;
                        } else if (tlsTunnelAllowProtocol.contains((Object)TlsTunnelProtocolEnum.EAP_MD5)) {
                            usedTunnelProtocol = TlsTunnelProtocolEnum.EAP_MD5;
                        } else if (tlsTunnelAllowProtocol.contains((Object)TlsTunnelProtocolEnum.EAP_MSCHAP_V2)) {
                            usedTunnelProtocol = TlsTunnelProtocolEnum.EAP_MSCHAP_V2;
                        }
                        if (Objects.isNull((Object)usedTunnelProtocol)) {
                            log.debug("unsupported eap tunnel protocol");
                            return EapPacketUtil.failure(responseId);
                        }
                        switch (usedTunnelProtocol) {
                            case EAP_MD5: {
                                log.debug("{} identity EAP-MD5", (Object)CustomPIIMaskUtil.hash(username));
                                EapMd5Authenticator eapMd5Authenticator = new EapMd5Authenticator();
                                EapPacket tunnelEapReq = eapMd5Authenticator.setupRequest(this.eapAuthHelper, tunnelEapResp.getId(), password);
                                userEapCacheInfo.setTunnelUsername(username);
                                userEapCacheInfo.setPassword(password);
                                userEapCacheInfo.setTunnelAuthenticator(eapMd5Authenticator);
                                userEapCacheInfo.setCurrentState(CurrentState.EAP_TTLS_STATE_WAIT_EAP_MD5_CHALLENGE);
                                this.userCache.setUserEapCacheInfo(authReq.getNasMac(), clientMac, userEapCacheInfo);
                                return EapPacketUtil.fromRecordLayerList(dataType, EapPacketUtil.computeRequestId(responseId), new RecordLayer[]{this.eapAuthHelper.avpList2AppData(tunnelEapReq.toRadiusAttribute(dictionary), tlsCipher)});
                            }
                            case EAP_MSCHAP_V2: {
                                log.debug("{} identity EAP_MSCHAP_V2", (Object)CustomPIIMaskUtil.hash(username));
                                MsChapv2Authenticator msChapv2Authenticator = new MsChapv2Authenticator();
                                byte[] sendChallenge = msChapv2Authenticator.sendChallenge(tunnelEapResp.getId(), username.getBytes());
                                byte tunnelRequestId = EapPacketUtil.computeRequestId(tunnelEapResp.getId());
                                ByteBuf tunnelEapData = Unpooled.buffer().writeBytes(sendChallenge);
                                ByteBuf tunnelEapHeader = EapPacket.buildHeader((byte)1, (byte)tunnelRequestId, (ByteBuf)tunnelEapData);
                                EapPacket tunnelEapReq = EapPacketUtil.wrap(tunnelEapHeader, tunnelEapData);
                                userEapCacheInfo.setTunnelAuthenticator(msChapv2Authenticator);
                                userEapCacheInfo.setTunnelUsername(username);
                                userEapCacheInfo.setPassword(password);
                                userEapCacheInfo.setCurrentState(CurrentState.EAP_TTLS_STATE_WAIT_EAPMSCHAPV2_RESPONSE);
                                this.userCache.setUserEapCacheInfo(authReq.getNasMac(), clientMac, userEapCacheInfo);
                                return EapPacketUtil.fromRecordLayerList(dataType, EapPacketUtil.computeRequestId(responseId), new RecordLayer[]{this.eapAuthHelper.avpList2AppData(tunnelEapReq.toRadiusAttribute(dictionary), tlsCipher)});
                            }
                        }
                        log.warn("unsupported tunnel protocol: {}", (Object)tlsTunnelDefaultProtocol.name());
                        throw new TunnelAuthException("Unsupported tunnel protocol: " + tlsTunnelDefaultProtocol.name());
                    }
                    case NAK: {
                        AuthProtocol nakDesiredAuthProtocol = this.eapAuthHelper.parseNakDesiredAuthProtocol(tunnelEapResp);
                        TlsTunnelProtocolEnum desiredProtocol = TlsTunnelProtocolEnum.mapperAuthProtocol(nakDesiredAuthProtocol);
                        if (Objects.isNull((Object)desiredProtocol) || !tlsTunnelAllowProtocol.contains((Object)desiredProtocol)) {
                            log.debug("Unallowed ttls tunnel protocol: {}", (Object)nakDesiredAuthProtocol.getName());
                            return EapPacketUtil.failure(responseId);
                        }
                        return this.beginDesiredAuthProtocol(nakDesiredAuthProtocol, tunnelEapResp, dataType, responseId, dictionary, tlsCipher, authReq, clientMac);
                    }
                }
                throw new TunnelAuthException("Unsupported EAP data type [" + tunnelDataType + "]");
            }
            case USER_PASSWORD: {
                String password;
                String receivedUsername = ((RadiusAttribute)tunnelReq.getAttributeList().get(0)).getValueString();
                log.debug("{} start TTLS-PAP valid password", (Object)receivedUsername);
                if (!tlsTunnelAllowProtocol.contains((Object)TlsTunnelProtocolEnum.PAP)) {
                    log.debug("unsupported tunnel pap protocol");
                    return EapPacketUtil.failure(responseId);
                }
                try {
                    password = this.getUserInfoHelper.getPassword(receivedUsername, accessRequest, authReq);
                }
                catch (NoSuchElementException e) {
                    return EapPacketUtil.failure(responseId);
                }
                String receivedPassword = ((RadiusAttribute)tunnelReq.getAttributeList().get(1)).getValueString();
                if (Objects.equals(password, receivedPassword)) {
                    userEapCacheInfo.setCurrentState(CurrentState.afterTunnelAuth(authReq));
                    userEapCacheInfo.setTunnelUsername(receivedUsername);
                    userEapCacheInfo.setPassword(password);
                    this.userCache.setUserEapCacheInfo(authReq.getNasMac(), clientMac, userEapCacheInfo);
                    return EapPacketUtil.success(responseId);
                }
                log.warn("TTLS PAP tunnel username {} or password {} is wrong", (Object)CustomPIIMaskUtil.hash(receivedUsername), (Object)CustomPIIMaskUtil.mask(receivedPassword));
                return EapPacketUtil.failure(responseId);
            }
        }
        throw new TunnelAuthException("Unsupported TTLS Tunnel method " + tunnelReq.getAuthType().getName());
    }

    private String getUsernameFromTunnelEapResp(EapResponse tunnelEapResp) {
        ByteBuf dataValue = tunnelEapResp.getDataValue();
        byte[] dataValueBytes = ByteBufUtil.getBytes((ByteBuf)dataValue);
        int dataValueLength = dataValueBytes.length;
        byte[] usernameBytes = new byte[dataValueLength - 1];
        System.arraycopy(dataValueBytes, 0, usernameBytes, 0, dataValueLength - 1);
        return new String(usernameBytes, StandardCharsets.UTF_8);
    }

    private EapPacket beginDesiredAuthProtocol(AuthProtocol desiredAuthProtocol, EapResponse tunnelEapResp, DataType dataType, byte responseId, Dictionary dictionary, TlsCipher tlsCipher, AuthReq authReq, String clientMac) throws TunnelAuthException {
        UserEapCacheInfo userEapCacheInfo = authReq.getUserEapCacheInfo();
        String tunnelUsername = userEapCacheInfo.getTunnelUsername();
        switch (desiredAuthProtocol) {
            case EAP_MD5: {
                EapMd5Authenticator eapMd5Authenticator = new EapMd5Authenticator();
                String password = this.getUserInfoHelper.getPassword(tunnelUsername, authReq.getAccessRequest(), authReq);
                EapPacket tunnelEapReq = eapMd5Authenticator.setupRequest(this.eapAuthHelper, tunnelEapResp.getId(), password);
                userEapCacheInfo.setTunnelAuthenticator(eapMd5Authenticator);
                this.userCache.setUserEapCacheInfo(authReq.getNasMac(), clientMac, userEapCacheInfo);
                return EapPacketUtil.fromRecordLayerList(dataType, EapPacketUtil.computeRequestId(responseId), new RecordLayer[]{this.eapAuthHelper.avpList2AppData(tunnelEapReq.toRadiusAttribute(dictionary), tlsCipher)});
            }
            case MS_CHAP_V2: {
                MsChapv2Authenticator msChapv2Authenticator = new MsChapv2Authenticator();
                byte[] sendChallenge = msChapv2Authenticator.sendChallenge(tunnelEapResp.getId(), tunnelUsername.getBytes());
                byte tunnelRequestId = EapPacketUtil.computeRequestId(tunnelEapResp.getId());
                ByteBuf tunnelEapData = Unpooled.buffer().writeBytes(sendChallenge);
                ByteBuf tunnelEapHeader = EapPacket.buildHeader((byte)1, (byte)tunnelRequestId, (ByteBuf)tunnelEapData);
                EapPacket tunnelEapReq = EapPacketUtil.wrap(tunnelEapHeader, tunnelEapData);
                userEapCacheInfo.setTunnelAuthenticator(msChapv2Authenticator);
                userEapCacheInfo.setCurrentState(CurrentState.EAP_TTLS_STATE_WAIT_EAPMSCHAPV2_RESPONSE);
                this.userCache.setUserEapCacheInfo(authReq.getNasMac(), clientMac, userEapCacheInfo);
                return EapPacketUtil.fromRecordLayerList(dataType, EapPacketUtil.computeRequestId(responseId), new RecordLayer[]{this.eapAuthHelper.avpList2AppData(tunnelEapReq.toRadiusAttribute(dictionary), tlsCipher)});
            }
        }
        throw new TunnelAuthException("Unsupported NAK desired auth type [" + desiredAuthProtocol + "]");
    }

    private EapPacket dealEapMd5Challenge(AuthReq authReq) {
        EapMd5Authenticator eapMd5Authenticator;
        boolean authSuccess;
        TunnelReq tunnelReq;
        UserEapCacheInfo userEapCacheInfo = authReq.getUserEapCacheInfo();
        AccessRequest accessRequest = authReq.getAccessRequest();
        String clientMac = RadiusAttributeUtil.clientMac((RadiusRequest)accessRequest);
        EapResponse eapResponse = AccessRequestUtil.findEapResponse(accessRequest);
        byte responseId = eapResponse.getId();
        Dictionary dictionary = accessRequest.getDictionary();
        DataType dataType = eapResponse.getDataType();
        EapTlsPacket eapTlsPacket = authReq.getEapTlsPacket();
        List reqAppDataList = eapTlsPacket.getTlsPacket().getApplicationDataList();
        List<RadiusAttribute> diameterAttributeList = this.eapAuthHelper.appDataList2AvpList(dictionary, reqAppDataList);
        try {
            tunnelReq = TunnelReq.fromRadiusAttributeList(diameterAttributeList);
        }
        catch (RadiusPacketException e) {
            log.error(e.getMessage());
            return EapPacketUtil.failure(responseId);
        }
        EapResponse tunnelEapResp = tunnelReq.getEapResponse();
        TlsCipher tlsCipher = userEapCacheInfo.getEapTlsInfo().getTlsCipher();
        DataType tunnelDataType = tunnelEapResp.getDataType();
        if (DataType.NAK == tunnelDataType) {
            AuthProtocol nakDesiredAuthProtocol = this.eapAuthHelper.parseNakDesiredAuthProtocol(tunnelEapResp);
            try {
                return this.beginDesiredAuthProtocol(nakDesiredAuthProtocol, tunnelEapResp, dataType, responseId, dictionary, tlsCipher, authReq, clientMac);
            }
            catch (TunnelAuthException e) {
                log.debug(e.getMessage());
                EapPacketUtil.failure(responseId);
            }
        }
        if (authSuccess = (eapMd5Authenticator = (EapMd5Authenticator)userEapCacheInfo.getTunnelAuthenticator()).processChallenge(tunnelEapResp.getDataValue())) {
            userEapCacheInfo.setCurrentState(CurrentState.afterTunnelAuth(authReq));
            this.userCache.setUserEapCacheInfo(authReq.getNasMac(), clientMac, userEapCacheInfo);
        }
        return authSuccess ? EapPacketUtil.success(responseId) : EapPacketUtil.failure(responseId);
    }

    private EapPacket dealEapMsChapV2WaitResponse(AuthReq authReq) {
        TunnelReq tunnelReq;
        UserEapCacheInfo userEapCacheInfo = authReq.getUserEapCacheInfo();
        TlsCipher tlsCipher = userEapCacheInfo.getEapTlsInfo().getTlsCipher();
        AccessRequest accessRequest = authReq.getAccessRequest();
        EapResponse eapResponse = AccessRequestUtil.findEapResponse(accessRequest);
        String clientMac = RadiusAttributeUtil.clientMac((RadiusRequest)accessRequest);
        DataType dataType = eapResponse.getDataType();
        byte responseId = eapResponse.getId();
        Dictionary dictionary = accessRequest.getDictionary();
        EapTlsPacket eapTlsPacket = authReq.getEapTlsPacket();
        List reqAppDataList = eapTlsPacket.getTlsPacket().getApplicationDataList();
        List<RadiusAttribute> diameterAttributeList = this.eapAuthHelper.appDataList2AvpList(dictionary, reqAppDataList);
        try {
            tunnelReq = TunnelReq.fromRadiusAttributeList(diameterAttributeList);
        }
        catch (RadiusPacketException e) {
            log.error(e.getMessage());
            return EapPacketUtil.failure(responseId);
        }
        EapResponse tunnelEapResp = tunnelReq.getEapResponse();
        byte[] tunnelEapData = ByteBufUtil.getBytes((ByteBuf)tunnelEapResp.getData());
        byte[] tunnelEapDataValue = Arrays.copyOfRange(tunnelEapData, 1, tunnelEapData.length);
        try {
            MsChapv2Authenticator msChapv2Authenticator = (MsChapv2Authenticator)userEapCacheInfo.getTunnelAuthenticator();
            byte[] successRequest = msChapv2Authenticator.processResponse(tunnelEapDataValue, authReq);
            if (successRequest == null || successRequest.length == 0) {
                return EapPacketUtil.failure(responseId);
            }
            byte tunnelRequestId = EapPacketUtil.computeRequestId(tunnelEapResp.getId());
            ByteBuf tunnelReqEapData = Unpooled.buffer().writeBytes(successRequest);
            ByteBuf tunnelReqEapHeader = EapPacket.buildHeader((byte)1, (byte)tunnelRequestId, (ByteBuf)tunnelReqEapData);
            EapPacket tunnelReqEap = EapPacketUtil.wrap(tunnelReqEapHeader, tunnelReqEapData);
            userEapCacheInfo.setTunnelAuthenticator(msChapv2Authenticator);
            userEapCacheInfo.setCurrentState(CurrentState.EAP_TTLS_STATE_WAIT_EAPMSCHAPV2_VERIFIED_RESPONSE);
            this.userCache.setUserEapCacheInfo(authReq.getNasMac(), clientMac, userEapCacheInfo);
            return EapPacketUtil.fromRecordLayerList(dataType, EapPacketUtil.computeRequestId(responseId), new RecordLayer[]{this.eapAuthHelper.avpList2AppData(tunnelReqEap.toRadiusAttribute(dictionary), tlsCipher)});
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return EapPacketUtil.failure(responseId);
        }
    }

    private EapPacket dealEapMsChapV2VerifiedResponse(AuthReq authReq) {
        boolean authSuccess;
        TunnelReq tunnelReq;
        UserEapCacheInfo userEapCacheInfo = authReq.getUserEapCacheInfo();
        AccessRequest accessRequest = authReq.getAccessRequest();
        EapResponse eapResponse = AccessRequestUtil.findEapResponse(accessRequest);
        String clientMac = RadiusAttributeUtil.clientMac((RadiusRequest)accessRequest);
        byte responseId = eapResponse.getId();
        Dictionary dictionary = accessRequest.getDictionary();
        EapTlsPacket eapTlsPacket = authReq.getEapTlsPacket();
        List reqAppDataList = eapTlsPacket.getTlsPacket().getApplicationDataList();
        List<RadiusAttribute> diameterAttributeList = this.eapAuthHelper.appDataList2AvpList(dictionary, reqAppDataList);
        try {
            tunnelReq = TunnelReq.fromRadiusAttributeList(diameterAttributeList);
        }
        catch (RadiusPacketException e) {
            log.error(e.getMessage());
            return EapPacketUtil.failure(responseId);
        }
        EapResponse tunnelEapResp = tunnelReq.getEapResponse();
        byte[] tunnelEapData = ByteBufUtil.getBytes((ByteBuf)tunnelEapResp.getData());
        byte[] tunnelEapDataValue = Arrays.copyOfRange(tunnelEapData, 1, tunnelEapData.length);
        log.warn("ttls-eapmschapv2 now get opcode {}", (Object)tunnelEapDataValue[0]);
        boolean bl = authSuccess = OpCode.SUCCESS.getIndex() == tunnelEapDataValue[0];
        if (authSuccess) {
            userEapCacheInfo.setCurrentState(CurrentState.afterTunnelAuth(authReq));
            this.userCache.setUserEapCacheInfo(authReq.getNasMac(), clientMac, userEapCacheInfo);
        }
        return authSuccess ? EapPacketUtil.success(responseId) : EapPacketUtil.failure(responseId);
    }
}

