/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.core.authentication.eap.service.impl;

import com.tplink.cdd.component.aaa.core.authentication.cache.UserCache;
import com.tplink.cdd.component.aaa.core.authentication.cache.UserEapCacheInfo;
import com.tplink.cdd.component.aaa.core.authentication.config.AaaExtendServiceFactory;
import com.tplink.cdd.component.aaa.core.authentication.dto.AuthReq;
import com.tplink.cdd.component.aaa.core.authentication.eap.EapAuthHelper;
import com.tplink.cdd.component.aaa.core.authentication.eap.annotation.Action;
import com.tplink.cdd.component.aaa.core.authentication.eap.enums.ActionCategory;
import com.tplink.cdd.component.aaa.core.authentication.eap.enums.CurrentState;
import com.tplink.cdd.component.aaa.core.authentication.eap.service.ActionBucket;
import com.tplink.cdd.component.aaa.core.authentication.utils.EapPacketUtil;
import com.tplink.cdd.component.aaa.server.api.extend.CertificateApiService;
import com.tplink.cdd.component.aaa.server.api.extend.EapTlsCertificationApiService;
import com.tplink.cdd.component.aaa.server.dto.CertificateApiDTO;
import com.tplink.cdd.component.aaa.server.dto.ServerCertificateChainApiDTO;
import com.tplink.cdd.component.aaa.server.utils.AccessRequestUtil;
import com.tplink.cdd.radius.common.eap.EapPacketException;
import com.tplink.cdd.radius.common.eap.enums.DataType;
import com.tplink.cdd.radius.common.eap.packet.EapPacket;
import com.tplink.cdd.radius.common.eap.packet.EapResponse;
import com.tplink.cdd.radius.common.eap.packet.data.EapTlsPacket;
import com.tplink.cdd.radius.common.packet.request.AccessRequest;
import com.tplink.cdd.radius.common.packet.request.RadiusRequest;
import com.tplink.cdd.radius.common.tls.CipherSuite.TlsCipher;
import com.tplink.cdd.radius.common.tls.TlsPacket;
import com.tplink.cdd.radius.common.tls.dto.SecurityParameters;
import com.tplink.cdd.radius.common.tls.enums.CertificateType;
import com.tplink.cdd.radius.common.tls.enums.CipherSuite;
import com.tplink.cdd.radius.common.tls.enums.HandshakeType;
import com.tplink.cdd.radius.common.tls.enums.HashAlgorithm;
import com.tplink.cdd.radius.common.tls.enums.RecordLayerType;
import com.tplink.cdd.radius.common.tls.enums.SignatureHashAlgorithm;
import com.tplink.cdd.radius.common.tls.enums.TlsVersion;
import com.tplink.cdd.radius.common.tls.recordlayer.Alert;
import com.tplink.cdd.radius.common.tls.recordlayer.ChangeCipherSpec;
import com.tplink.cdd.radius.common.tls.recordlayer.Handshake;
import com.tplink.cdd.radius.common.tls.recordlayer.handshake.Certificate;
import com.tplink.cdd.radius.common.tls.recordlayer.handshake.CertificateRequest;
import com.tplink.cdd.radius.common.tls.recordlayer.handshake.CertificateVerify;
import com.tplink.cdd.radius.common.tls.recordlayer.handshake.ClientHello;
import com.tplink.cdd.radius.common.tls.recordlayer.handshake.ClientKeyExchange;
import com.tplink.cdd.radius.common.tls.recordlayer.handshake.Finished;
import com.tplink.cdd.radius.common.tls.recordlayer.handshake.HandshakeProtocol;
import com.tplink.cdd.radius.common.tls.recordlayer.handshake.ServerHello;
import com.tplink.cdd.radius.common.tls.recordlayer.handshake.ServerHelloDone;
import com.tplink.cdd.radius.common.utils.CipherUtil;
import com.tplink.cdd.radius.common.utils.RadiusAttributeUtil;
import com.tplink.cdd.radius.common.utils.RandomUtil;
import com.tplink.cdd.radius.common.utils.TlsUtil;
import com.tplink.cdd.radius.common.utils.TwoTuple;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class EapTlsActionBucket
implements ActionBucket {
    private static final Logger log = LoggerFactory.getLogger(EapTlsActionBucket.class);
    @Autowired
    private EapAuthHelper eapAuthHelper;
    @Autowired
    private UserCache userCache;
    @Autowired
    private AaaExtendServiceFactory aaaExtendServiceFactory;
    @Autowired
    private EapTlsCertificationApiService eapTlsCertificationApiService;

    @Action(value=ActionCategory.EAP_TLS_ACTION_INIT)
    public EapPacket action0(AuthReq authReq) {
        AccessRequest accessRequest = authReq.getAccessRequest();
        String clientMac = RadiusAttributeUtil.clientMac((RadiusRequest)accessRequest);
        EapResponse eapResponse = AccessRequestUtil.findEapResponse(accessRequest);
        byte responseId = eapResponse.getId();
        ByteBuf data = Unpooled.buffer().writeByte((int)DataType.EAP_TLS.getIndex()).writeByte(32);
        ByteBuf header = EapPacket.buildHeader((byte)1, (byte)EapPacketUtil.computeRequestId(responseId), (ByteBuf)data);
        UserEapCacheInfo userEapCacheInfo = authReq.getUserEapCacheInfo();
        userEapCacheInfo.setCurrentState(CurrentState.EAP_TLS_STATE_READY);
        this.userCache.setUserEapCacheInfo(authReq.getNasMac(), clientMac, userEapCacheInfo);
        return EapPacketUtil.wrap(header, data);
    }

    @Action(value=ActionCategory.EAP_TLS_ACTION_PROCESS_CLIENT_HELLO)
    public EapPacket action1(AuthReq authReq) {
        AccessRequest accessRequest = authReq.getAccessRequest();
        String clientMac = RadiusAttributeUtil.clientMac((RadiusRequest)accessRequest);
        EapResponse eapResponse = AccessRequestUtil.findEapResponse(accessRequest);
        EapTlsPacket eapTlsPacket = authReq.getEapTlsPacket();
        byte responseId = eapResponse.getId();
        ClientHello clientHello = (ClientHello)eapTlsPacket.getTlsPacket().getHandshakeProtocol(ClientHello.class);
        byte[] clientRandom = clientHello.getRandom();
        log.debug("SUCCESS - GET - client random - {}", (Object)clientRandom);
        TlsVersion tlsVersion = clientHello.getVersion();
        log.debug("SUCCESS - GET - tls version - {}", (Object)tlsVersion.getName());
        if (tlsVersion == TlsVersion.V1_3) {
            log.warn("Unsupported Tls Version 1.3");
            return EapPacketUtil.failure(eapResponse);
        }
        CipherSuite selectedCipherSuite = this.parseCipherSuites(clientHello);
        log.debug("SUCCESS - GET - cipher suite  - {}", (Object)selectedCipherSuite);
        if (Objects.isNull(selectedCipherSuite)) {
            return EapPacketUtil.failure(eapResponse);
        }
        byte[] serverRandom = RandomUtil.randomBytes((int)32);
        TlsUtil.writeGMTUnixTime((byte[])serverRandom, (int)0);
        log.debug("SUCCESS - PROCESS - server random - {}", (Object)serverRandom);
        byte[] sessionId = RandomUtil.randomBytes((int)32);
        log.debug("SUCCESS - PROCESS - server session id - {}", (Object)sessionId);
        ServerHello serverHello = this.constructServerHello(serverRandom, sessionId, selectedCipherSuite, tlsVersion);
        log.debug("SUCCESS - CONSTRUCT - server hello");
        Certificate certificate = this.constructServerCertificate();
        log.debug("SUCCESS - CONSTRUCT - server certificate");
        CertificateRequest clientCertificateReq = this.constructClientCertificationReq(tlsVersion);
        log.debug("SUCCESS - CONSTRUCT - client certificate req");
        ServerHelloDone serverHelloDone = this.constructServerHelloDone();
        log.debug("SUCCESS - CONSTRUCT - server hello done");
        UserEapCacheInfo userEapCacheInfo = authReq.getUserEapCacheInfo();
        ByteBuf serverHelloStageHsData = this.hsDataList2ByteBuf(new HandshakeProtocol[]{serverHello, certificate, clientCertificateReq, serverHelloDone});
        UserEapCacheInfo.EapTlsInfo eapTlsInfo = UserEapCacheInfo.EapTlsInfo.builder().version(Integer.valueOf(tlsVersion.getIndex())).cipherSuite(selectedCipherSuite).sessionId(sessionId).securityParameters(SecurityParameters.builder().clientRandom(clientRandom).serverRandom(serverRandom).build()).clientHelloStageHsData(clientHello.getData()).serverHelloStageHsData(serverHelloStageHsData).build();
        ArrayList<Handshake> recordLayerList = new ArrayList<Handshake>();
        recordLayerList.add(new Handshake(tlsVersion, new HandshakeProtocol[]{serverHello}));
        recordLayerList.add(new Handshake(tlsVersion, new HandshakeProtocol[]{certificate}));
        recordLayerList.add(new Handshake(tlsVersion, new HandshakeProtocol[]{clientCertificateReq, serverHelloDone}));
        TlsPacket tlsPacket = new TlsPacket(recordLayerList);
        ByteBuf data = Unpooled.buffer().writeByte((int)eapResponse.getDataType().getIndex());
        if (this.eapAuthHelper.tlsPacketIsNeedSplit(tlsPacket)) {
            ByteBuf tlsPacketByteBuf = this.eapAuthHelper.splitTlsPacketAndFindFirst(tlsPacket, eapTlsInfo);
            data.writeByte(-64).writeInt(tlsPacket.getSize()).writeBytes(tlsPacketByteBuf);
            eapTlsInfo.setServerHelloLength(tlsPacket.getSize());
            userEapCacheInfo.setEapTlsInfo(eapTlsInfo);
            userEapCacheInfo.setCurrentState(CurrentState.EAP_TLS_STATE_SERVER_HELLO_SEND_FRAGMENT_ING);
            log.debug("SUCCESS - BUILD - split eapTls data - {} bytes", (Object)data.readableBytes());
        } else {
            EapTlsPacket eapTlsResp = new EapTlsPacket(-128, tlsPacket);
            data.writeBytes(eapTlsResp.toByteBuf());
            userEapCacheInfo.setCurrentState(CurrentState.EAP_TLS_STATE_WAIT_CLIENT_KEY);
            log.debug("SUCCESS - BUILD - full eapTls data - {} bytes", (Object)data.readableBytes());
        }
        ByteBuf header = EapPacket.buildHeader((byte)1, (byte)EapPacketUtil.computeRequestId(responseId), (ByteBuf)data);
        log.debug("SUCCESS - BUILD - eapTls header - {} bytes", (Object)header.readableBytes());
        this.userCache.setUserEapCacheInfo(authReq.getNasMac(), clientMac, userEapCacheInfo);
        return EapPacketUtil.wrap(header, data);
    }

    @Action(value=ActionCategory.EAP_TLS_ACTION_SEND_SERVER_HELLO_NEXT_FRAGMENT)
    public EapPacket action2(AuthReq authReq) {
        AccessRequest accessRequest = authReq.getAccessRequest();
        String clientMac = RadiusAttributeUtil.clientMac((RadiusRequest)accessRequest);
        EapResponse eapResponse = AccessRequestUtil.findEapResponse(accessRequest);
        byte responseId = eapResponse.getId();
        String nasMac = authReq.getNasMac();
        UserEapCacheInfo userEapCacheInfo = this.userCache.getUserEapCacheInfo(nasMac, clientMac);
        UserEapCacheInfo.EapTlsInfo eapTlsInfo = userEapCacheInfo.getEapTlsInfo();
        List<ByteBuf> reqFragmentList = eapTlsInfo.getReqFragmentList();
        if (reqFragmentList.isEmpty()) {
            return EapPacketUtil.INTERNAL_FAILURE;
        }
        ByteBuf currentFragment = reqFragmentList.remove(0);
        ByteBuf data = Unpooled.buffer().writeByte((int)eapResponse.getDataType().getIndex());
        if (reqFragmentList.isEmpty()) {
            data.writeByte(-128);
            userEapCacheInfo.setCurrentState(CurrentState.EAP_TLS_STATE_WAIT_CLIENT_KEY);
        } else {
            data.writeByte(-64);
            userEapCacheInfo.setCurrentState(CurrentState.EAP_TLS_STATE_SERVER_HELLO_SEND_FRAGMENT_ING);
        }
        data.writeInt(eapTlsInfo.getServerHelloLength().intValue()).writeBytes(currentFragment);
        log.debug("SUCCESS - BUILD - eapTls data - {} bytes", (Object)data.readableBytes());
        ByteBuf header = EapPacket.buildHeader((byte)1, (byte)EapPacketUtil.computeRequestId(responseId), (ByteBuf)data);
        log.debug("SUCCESS - BUILD - eapTls header - {} bytes", (Object)header.readableBytes());
        eapTlsInfo.setReqFragmentList(reqFragmentList);
        userEapCacheInfo.setEapTlsInfo(eapTlsInfo);
        this.userCache.setUserEapCacheInfo(nasMac, clientMac, userEapCacheInfo);
        return EapPacketUtil.wrap(header, data);
    }

    @Action(value=ActionCategory.EAP_TLS_ACTION_PROCESS_CLIENT_KEY_FULL)
    public EapPacket action3(AuthReq authReq) {
        AccessRequest accessRequest = authReq.getAccessRequest();
        String clientMac = RadiusAttributeUtil.clientMac((RadiusRequest)accessRequest);
        EapResponse eapResponse = AccessRequestUtil.findEapResponse(accessRequest);
        try {
            EapTlsPacket eapTlsPacket = EapTlsPacket.fromEapResponse((EapResponse)eapResponse, null);
            return this.processClientKeyFullPacket(eapTlsPacket, eapResponse.getId(), authReq.getNasMac(), clientMac);
        }
        catch (EapPacketException e) {
            log.warn("Filed to convert eap packet to EAP-TLS packet, authReq = {}", (Object)authReq, (Object)e);
            return EapPacketUtil.failure(eapResponse);
        }
    }

    @Action(value=ActionCategory.EAP_TLS_ACTION_PROCESS_CLIENT_KEY_FRAGMENT_FIRST)
    public EapPacket action4(AuthReq authReq) {
        AccessRequest accessRequest = authReq.getAccessRequest();
        String clientMac = RadiusAttributeUtil.clientMac((RadiusRequest)accessRequest);
        EapResponse eapResponse = AccessRequestUtil.findEapResponse(accessRequest);
        EapTlsPacket eapTlsPacket = authReq.getEapTlsPacket();
        ArrayList<ByteBuf> respFragmentList = new ArrayList<ByteBuf>();
        respFragmentList.add(eapTlsPacket.getSplitFragment());
        UserEapCacheInfo userEapCacheInfo = this.userCache.getUserEapCacheInfo(authReq.getNasMac(), clientMac);
        UserEapCacheInfo.EapTlsInfo eapTlsInfo = userEapCacheInfo.getEapTlsInfo();
        eapTlsInfo.setRespFragmentList(respFragmentList);
        userEapCacheInfo.setEapTlsInfo(eapTlsInfo);
        userEapCacheInfo.setCurrentState(CurrentState.EAP_TLS_STATE_WAIT_CLIENT_KEY_NEXT_FRAGMENT);
        this.userCache.setUserEapCacheInfo(authReq.getNasMac(), clientMac, userEapCacheInfo);
        return EapPacketUtil.empty(eapResponse);
    }

    @Action(value=ActionCategory.EAP_TLS_ACTION_PROCESS_CLIENT_KEY_FRAGMENT_MIDDLE)
    public EapPacket action5(AuthReq authReq) {
        AccessRequest accessRequest = authReq.getAccessRequest();
        String clientMac = RadiusAttributeUtil.clientMac((RadiusRequest)accessRequest);
        EapResponse eapResponse = AccessRequestUtil.findEapResponse(accessRequest);
        EapTlsPacket eapTlsPacket = authReq.getEapTlsPacket();
        UserEapCacheInfo userEapCacheInfo = this.userCache.getUserEapCacheInfo(authReq.getNasMac(), clientMac);
        UserEapCacheInfo.EapTlsInfo eapTlsInfo = userEapCacheInfo.getEapTlsInfo();
        List<ByteBuf> respFragmentList = eapTlsInfo.getRespFragmentList();
        respFragmentList.add(eapTlsPacket.getSplitFragment());
        eapTlsInfo.setRespFragmentList(respFragmentList);
        userEapCacheInfo.setEapTlsInfo(eapTlsInfo);
        this.userCache.setUserEapCacheInfo(authReq.getNasMac(), clientMac, userEapCacheInfo);
        return EapPacketUtil.empty(eapResponse);
    }

    @Action(value=ActionCategory.EAP_TLS_ACTION_PROCESS_CLIENT_KEY_FRAGMENT_LAST)
    public EapPacket action6(AuthReq authReq) {
        EapTlsPacket fullEapTlsPacket;
        AccessRequest accessRequest = authReq.getAccessRequest();
        String clientMac = RadiusAttributeUtil.clientMac((RadiusRequest)accessRequest);
        EapResponse eapResponse = AccessRequestUtil.findEapResponse(accessRequest);
        EapTlsPacket eapTlsPacket = authReq.getEapTlsPacket();
        String nasMac = authReq.getNasMac();
        UserEapCacheInfo userEapCacheInfo = this.userCache.getUserEapCacheInfo(nasMac, clientMac);
        List<ByteBuf> respFragmentList = userEapCacheInfo.getEapTlsInfo().getRespFragmentList();
        respFragmentList.add(eapTlsPacket.getSplitFragment());
        try {
            fullEapTlsPacket = EapTlsPacket.assembleSplitFragment(respFragmentList);
        }
        catch (EapPacketException e) {
            log.warn("Filed to convert eap packet to EAP-TLS packet, authReq = {}", (Object)authReq, (Object)e);
            return EapPacketUtil.failure(eapResponse);
        }
        return this.processClientKeyFullPacket(fullEapTlsPacket, eapResponse.getId(), nasMac, clientMac);
    }

    @Action(value=ActionCategory.EAP_TLS_ACTION_PROCESS_ACK)
    public EapPacket action7(AuthReq authReq) {
        AccessRequest accessRequest = authReq.getAccessRequest();
        String clientMac = RadiusAttributeUtil.clientMac((RadiusRequest)accessRequest);
        EapResponse eapResponse = AccessRequestUtil.findEapResponse(accessRequest);
        UserEapCacheInfo userEapCacheInfo = authReq.getUserEapCacheInfo();
        userEapCacheInfo.setCurrentState(CurrentState.EAP_TLS_STATE_AUTH_SUCCESS);
        this.userCache.setUserEapCacheInfo(authReq.getNasMac(), clientMac, userEapCacheInfo);
        return EapPacketUtil.success(eapResponse);
    }

    @Action(value=ActionCategory.EAP_TLS_ACTION_PROCESS_ALERT)
    public EapPacket action8(AuthReq authReq) {
        EapTlsPacket eapTlsPacket = authReq.getEapTlsPacket();
        Alert.AlertMessage alertMessage = eapTlsPacket.getTlsPacket().getAlertMessage();
        if (Objects.nonNull(alertMessage)) {
            log.warn("Received an alert message : [{}] - [{}]", (Object)alertMessage.getLevel(), (Object)alertMessage.getDescription());
        } else {
            log.error("Unrecognized alert message!");
        }
        return EapPacketUtil.INTERNAL_FAILURE;
    }

    private EapPacket processClientKeyFullPacket(EapTlsPacket eapTlsPacket, byte responseId, String nasMac, String clientMac) {
        TlsPacket clientTlsPacket = eapTlsPacket.getTlsPacket();
        UserEapCacheInfo userEapCacheInfo = this.userCache.getUserEapCacheInfo(nasMac, clientMac);
        UserEapCacheInfo.EapTlsInfo eapTlsInfo = userEapCacheInfo.getEapTlsInfo();
        CipherSuite cipherSuite = eapTlsInfo.getCipherSuite();
        SecurityParameters securityParameters = eapTlsInfo.getSecurityParameters();
        ByteBuf clientHelloStageHsData = eapTlsInfo.getClientHelloStageHsData();
        ByteBuf serverHelloStageHsData = eapTlsInfo.getServerHelloStageHsData();
        TlsVersion tlsVersion = TlsVersion.fromIndex((short)((short)eapTlsInfo.getVersion().intValue()));
        Certificate certificate = (Certificate)clientTlsPacket.getHandshakeProtocol(Certificate.class);
        log.debug("SUCCESS - GET - client certificate chain count - {}", (Object)certificate.getClientCertificateChain().size());
        X509Certificate clientCertificate = certificate.getClientCertificate();
        boolean clientCertificateSuccess = this.checkClientCertificate(clientCertificate, certificate.getCaCertificate());
        log.debug("SUCCESS - PROCESS - check client certificate - {}", (Object)clientCertificateSuccess);
        if (!clientCertificateSuccess) {
            return EapPacketUtil.failure(responseId);
        }
        ClientKeyExchange clientKeyExchange = (ClientKeyExchange)clientTlsPacket.getHandshakeProtocol(ClientKeyExchange.class);
        log.debug("SUCCESS - GET - client key exchange - {}", (Object)clientKeyExchange);
        CertificateVerify certificateVerify = (CertificateVerify)clientTlsPacket.getHandshakeProtocol(CertificateVerify.class);
        log.debug("SUCCESS - GET - certificate verify - {}", (Object)certificateVerify);
        boolean certificateVerifySuccess = this.checkCertificateVerify(clientCertificate, certificateVerify.getSignature(), certificateVerify.getSignatureHashAlgorithm(), this.constructHsData(clientHelloStageHsData, serverHelloStageHsData, this.hsDataList2ByteBuf(new HandshakeProtocol[]{certificate, clientKeyExchange})));
        log.debug("SUCCESS - PROCESS - check certificate verify - {}", (Object)certificateVerifySuccess);
        if (!certificateVerifySuccess) {
            return EapPacketUtil.failure(responseId);
        }
        ChangeCipherSpec changeCipherSpec = clientTlsPacket.getChangeCipherSpec();
        if (Objects.isNull(changeCipherSpec)) {
            return EapPacketUtil.failure(responseId);
        }
        byte changeCipherSpecMessage = changeCipherSpec.getChangeCipherSpecMessage();
        log.debug("SUCCESS - GET - change cipher spec - {}", (Object)changeCipherSpecMessage);
        boolean changeCipherSpecSuccess = this.checkChangeCipherSpec(changeCipherSpecMessage);
        log.debug("SUCCESS - PROCESS - check change cipher spec - {}", (Object)changeCipherSpecSuccess);
        if (!changeCipherSpecSuccess) {
            return EapPacketUtil.failure(responseId);
        }
        Finished clientFinished = (Finished)clientTlsPacket.getHandshakeProtocol(Finished.class);
        log.debug("SUCCESS - GET - encrypted handshake message (client finished)");
        ByteBuf encryptedClientFinished = clientFinished.getEncryptedClientFinished();
        TlsCipher tlsCipher = this.constructTlsCipher(securityParameters, cipherSuite, clientKeyExchange.getEncryptedPreMaster(), tlsVersion);
        if (Objects.isNull(tlsCipher)) {
            log.warn("Failed to construct master secret or tls-cipher");
            return EapPacketUtil.failure(responseId);
        }
        log.debug("SUCCESS - PROCESS - construct master secret and tls-cipher - {}", (Object)securityParameters.getMasterSecret());
        TwoTuple<Boolean, byte[]> clientFinishedCheckResult = this.checkClientFinished(tlsCipher, securityParameters, ByteBufUtil.getBytes((ByteBuf)encryptedClientFinished), this.constructHsData(clientHelloStageHsData, serverHelloStageHsData, this.hsDataList2ByteBuf(new HandshakeProtocol[]{certificate, clientKeyExchange, certificateVerify})), tlsVersion);
        Boolean clientFinishedSuccess = (Boolean)clientFinishedCheckResult.getFirst();
        log.debug("SUCCESS - PROCESS - check client finished result - {}", (Object)clientFinishedSuccess);
        if (Objects.isNull(clientFinishedSuccess) || !clientFinishedSuccess.booleanValue()) {
            return EapPacketUtil.failure(responseId);
        }
        ChangeCipherSpec serverChangeCipherSpec = this.constructChangeCipherSpec(tlsVersion);
        log.debug("SUCCESS - CONSTRUCT - change cipher spec - {}", (Object)serverChangeCipherSpec.getChangeCipherSpecMessage());
        Finished serverFinished = this.constructServerFinished(tlsCipher, securityParameters, this.constructHsData(clientHelloStageHsData, serverHelloStageHsData, this.hsDataList2ByteBuf(new HandshakeProtocol[]{certificate, clientKeyExchange, certificateVerify})), (byte[])clientFinishedCheckResult.getSecond(), tlsVersion);
        if (Objects.isNull(serverFinished)) {
            return EapPacketUtil.failure(responseId);
        }
        log.debug("SUCCESS - CONSTRUCT - server finished - {} bytes", (Object)serverFinished.getEncryptedServerFinished().length);
        ArrayList<Object> recordLayerList = new ArrayList<Object>();
        recordLayerList.add(serverChangeCipherSpec);
        recordLayerList.add(new Handshake(tlsVersion, new HandshakeProtocol[]{serverFinished}));
        TlsPacket serverTlsPacket = new TlsPacket(recordLayerList);
        EapTlsPacket eapTlsResp = new EapTlsPacket(-128, serverTlsPacket);
        ByteBuf data = Unpooled.buffer().writeByte((int)DataType.EAP_TLS.getIndex()).writeBytes(eapTlsResp.toByteBuf());
        log.debug("SUCCESS - BUILD - eapTls data - {} bytes", (Object)data.readableBytes());
        ByteBuf header = EapPacket.buildHeader((byte)1, (byte)EapPacketUtil.computeRequestId(responseId), (ByteBuf)data);
        log.debug("SUCCESS - BUILD - eapTls header - {} bytes", (Object)header.readableBytes());
        eapTlsInfo.setSecurityParameters(securityParameters);
        eapTlsInfo.setTlsCipher(tlsCipher);
        userEapCacheInfo.setEapTlsInfo(eapTlsInfo);
        userEapCacheInfo.setCurrentState(CurrentState.EAP_TLS_STATE_WAIT_TLS_ACK);
        this.userCache.setUserEapCacheInfo(nasMac, clientMac, userEapCacheInfo);
        return EapPacketUtil.wrap(header, data);
    }

    private CipherSuite parseCipherSuites(ClientHello clientHello) {
        List receivedSuiteList = clientHello.getCipherSuiteList();
        return CipherSuite.fromClientCipherSuites((List)receivedSuiteList);
    }

    private ServerHello constructServerHello(byte[] random2, byte[] sessionId, CipherSuite cipherSuite, TlsVersion tlsVersion) {
        return new ServerHello(tlsVersion, random2, sessionId, Short.valueOf(cipherSuite.getIndex()), 0);
    }

    private Certificate constructServerCertificate() {
        ByteBuf certificateByteBuf = Unpooled.buffer();
        ServerCertificateChainApiDTO serverCertificateChain = null;
        CertificateApiService certificateApiServiceBean = this.aaaExtendServiceFactory.getCertificateApiServiceBean();
        if (!Objects.isNull(certificateApiServiceBean)) {
            serverCertificateChain = certificateApiServiceBean.getServerCertificateChain();
            if (Objects.isNull(serverCertificateChain)) {
                log.warn("failed to get serverCertificateChain");
                return null;
            }
        } else {
            log.warn("failed to get certificateApiServiceBean");
            return null;
        }
        for (byte[] content : serverCertificateChain.getCertificateContents()) {
            certificateByteBuf.writeMedium(content.length).writeBytes(content);
        }
        return new Certificate(certificateByteBuf, certificateByteBuf.readableBytes());
    }

    private CertificateRequest constructClientCertificationReq(TlsVersion tlsVersion) {
        return new CertificateRequest(tlsVersion, this.constructSignHashAlgorithms(), new byte[]{CertificateType.RSA_SIGN.getIndex()});
    }

    private ServerHelloDone constructServerHelloDone() {
        return new ServerHelloDone();
    }

    private boolean checkCertificateVerify(X509Certificate clientCertificate, ByteBuf clientSignature, SignatureHashAlgorithm signatureHashAlgorithm, ByteBuf toCheckHsData) {
        try {
            byte[] hashedMessage;
            PublicKey clientPublicKey = clientCertificate.getPublicKey();
            byte[] inputHashedMessage = this.eapAuthHelper.decryptByCertificatePublicKey(ByteBufUtil.getBytes((ByteBuf)clientSignature), clientPublicKey);
            if (Objects.isNull(signatureHashAlgorithm)) {
                hashedMessage = this.eapAuthHelper.messageHash(ByteBufUtil.getBytes((ByteBuf)toCheckHsData));
            } else {
                switch (HashAlgorithm.fromIndex((byte)signatureHashAlgorithm.getHash())) {
                    case MD5: {
                        hashedMessage = DigestUtils.md5((byte[])ByteBufUtil.getBytes((ByteBuf)toCheckHsData));
                        break;
                    }
                    case SHA1: {
                        hashedMessage = DigestUtils.sha1((byte[])ByteBufUtil.getBytes((ByteBuf)toCheckHsData));
                        break;
                    }
                    case SHA224: {
                        hashedMessage = DigestUtils.sha3_224((byte[])ByteBufUtil.getBytes((ByteBuf)toCheckHsData));
                        break;
                    }
                    case SHA256: {
                        hashedMessage = DigestUtils.sha256((byte[])ByteBufUtil.getBytes((ByteBuf)toCheckHsData));
                        break;
                    }
                    case SHA384: {
                        hashedMessage = DigestUtils.sha384((byte[])ByteBufUtil.getBytes((ByteBuf)toCheckHsData));
                        break;
                    }
                    case SHA512: {
                        hashedMessage = DigestUtils.sha512((byte[])ByteBufUtil.getBytes((ByteBuf)toCheckHsData));
                        break;
                    }
                    default: {
                        hashedMessage = new byte[]{0};
                    }
                }
            }
            return Arrays.equals(inputHashedMessage, hashedMessage);
        }
        catch (Exception e) {
            log.warn("Failed to decrypt client signature", (Throwable)e);
            return false;
        }
    }

    private boolean checkChangeCipherSpec(byte changeCipherSpecMessage) {
        return Objects.equals((byte)1, changeCipherSpecMessage);
    }

    private ChangeCipherSpec constructChangeCipherSpec(TlsVersion tlsVersion) {
        return new ChangeCipherSpec(tlsVersion);
    }

    private Finished constructServerFinished(TlsCipher tlsCipher, SecurityParameters securityParameters, ByteBuf toCheckHsData, byte[] clientFinished, TlsVersion tlsVersion) {
        toCheckHsData.writeBytes(clientFinished);
        byte[] serverFinishedVerifyData = this.eapAuthHelper.buildServerFinishedVerifyData(securityParameters.getMasterSecret(), toCheckHsData, tlsVersion);
        ByteBuf serverFinished = Unpooled.buffer().writeByte((int)HandshakeType.FINISHED.getIndex()).writeMedium(serverFinishedVerifyData.length).writeBytes(serverFinishedVerifyData);
        byte[] encryptedServerFinished = TlsUtil.encryptTlsText((TlsCipher)tlsCipher, (RecordLayerType)RecordLayerType.HANDSHAKE, (byte[])ByteBufUtil.getBytes((ByteBuf)serverFinished));
        return Objects.isNull(encryptedServerFinished) ? null : new Finished(encryptedServerFinished);
    }

    private ByteBuf constructHsData(ByteBuf ... hsDataList) {
        ByteBuf totalHsData = Unpooled.buffer();
        for (ByteBuf hsData : hsDataList) {
            totalHsData.writeBytes(hsData.copy());
        }
        return totalHsData;
    }

    private ByteBuf hsDataList2ByteBuf(HandshakeProtocol ... handshakeProtocols) {
        ByteBuf totalHsData = Unpooled.buffer();
        for (HandshakeProtocol handshakeProtocol : handshakeProtocols) {
            totalHsData.writeBytes(handshakeProtocol.getData());
        }
        return totalHsData;
    }

    private boolean checkClientCertificate(X509Certificate clientCertificate, X509Certificate caCertificate) {
        List<X509Certificate> trustCaCertificateList = this.filterTrustCertification(caCertificate);
        for (X509Certificate certificate : trustCaCertificateList) {
            PublicKey publicKey = certificate.getPublicKey();
            try {
                clientCertificate.verify(publicKey);
                log.debug("Success to verify client certificate when use [{}]", (Object)certificate.getSerialNumber());
                return true;
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException e) {
                log.warn("Failed to verify client certificate when use [{}]", (Object)certificate.getSerialNumber());
            }
        }
        log.warn("Failed to verify client certificate");
        return false;
    }

    private TlsCipher constructTlsCipher(SecurityParameters securityParameters, CipherSuite cipherSuite, ByteBuf encryptedPreMasterSecret, TlsVersion tlsVersion) {
        try {
            ServerCertificateChainApiDTO serverCertificateChain = null;
            CertificateApiService certificateApiServiceBean = this.aaaExtendServiceFactory.getCertificateApiServiceBean();
            if (!Objects.isNull(certificateApiServiceBean)) {
                serverCertificateChain = certificateApiServiceBean.getServerCertificateChain();
                if (Objects.isNull(serverCertificateChain)) {
                    log.warn("failed to get serverCertificateChain.");
                    return null;
                }
            } else {
                log.warn("failed to get certificateApiServiceBean.");
                return null;
            }
            byte[] preMasterSecret = this.eapAuthHelper.decryptByCertificatePrivateKey(ByteBufUtil.getBytes((ByteBuf)encryptedPreMasterSecret), serverCertificateChain.getPrivateKey());
            byte[] masterSecret = this.eapAuthHelper.buildMasterSecret(CipherUtil.concat((byte[])securityParameters.getClientRandom(), (byte[])securityParameters.getServerRandom()), preMasterSecret, tlsVersion);
            securityParameters.setMasterSecret(masterSecret);
            return TlsCipher.create((CipherSuite)cipherSuite, (SecurityParameters)securityParameters, (TlsVersion)tlsVersion);
        }
        catch (Exception e) {
            log.warn("Failed to decrypt pre-master-secret [{}]", (Object)encryptedPreMasterSecret);
            return null;
        }
    }

    private List<X509Certificate> filterTrustCertification(X509Certificate clientInputCaCer) {
        Optional<CertificateApiDTO> optionalCertificateDetailDO = this.eapTlsCertificationApiService.getTrustCertification(clientInputCaCer.getSerialNumber());
        ArrayList<X509Certificate> result = new ArrayList<X509Certificate>();
        X509Certificate caCertificate = null;
        CertificateApiService certificateApiServiceBean = this.aaaExtendServiceFactory.getCertificateApiServiceBean();
        if (!Objects.isNull(certificateApiServiceBean)) {
            caCertificate = certificateApiServiceBean.getCaCertificate();
            if (Objects.isNull(caCertificate)) {
                log.warn("failed to get caCertificate.");
                return Collections.emptyList();
            }
        } else {
            log.warn("failed to get certificateApiServiceBean.");
            return Collections.emptyList();
        }
        result.add(caCertificate);
        if (optionalCertificateDetailDO.isPresent()) {
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(optionalCertificateDetailDO.get().getContent());){
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                result.add((X509Certificate)cf.generateCertificate(inputStream));
            }
            catch (IOException | CertificateException e) {
                log.error("Failed to convert certificate", (Throwable)e);
            }
        }
        return result;
    }

    private TwoTuple<Boolean, byte[]> checkClientFinished(TlsCipher tlsCipher, SecurityParameters securityParameters, byte[] encryptedInputClientFinished, ByteBuf toCheckHsData, TlsVersion tlsVersion) {
        byte[] inputClientFinished = TlsUtil.decryptTlsText((TlsCipher)tlsCipher, (RecordLayerType)RecordLayerType.HANDSHAKE, (byte[])encryptedInputClientFinished);
        if (Objects.isNull(inputClientFinished)) {
            return TwoTuple.newInstance((Object)Boolean.FALSE, null);
        }
        byte[] inputVerifyData = this.eapAuthHelper.getClientVerifyData(inputClientFinished);
        byte[] verifyData = this.eapAuthHelper.buildClientFinishedVerifyData(securityParameters.getMasterSecret(), toCheckHsData, tlsVersion);
        return TwoTuple.newInstance((Object)Arrays.equals(inputVerifyData, verifyData), (Object)this.eapAuthHelper.getClientFinished(inputClientFinished));
    }

    private List<SignatureHashAlgorithm> constructSignHashAlgorithms() {
        ArrayList<SignatureHashAlgorithm> list = new ArrayList<SignatureHashAlgorithm>();
        list.add(SignatureHashAlgorithm.RSA_PKCS1_SHA1);
        list.add(SignatureHashAlgorithm.RSA_PKCS1_SHA256);
        list.add(SignatureHashAlgorithm.SHA224_RSA);
        list.add(SignatureHashAlgorithm.RSA_PKCS1_SHA384);
        list.add(SignatureHashAlgorithm.RSA_PKCS1_SHA512);
        return list;
    }
}

