/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.core.authentication.eap.service.impl;

import com.tplink.cdd.component.aaa.core.authentication.cache.UserCache;
import com.tplink.cdd.component.aaa.core.authentication.cache.UserEapCacheInfo;
import com.tplink.cdd.component.aaa.core.authentication.dto.AuthReq;
import com.tplink.cdd.component.aaa.core.authentication.eap.EapAuthHelper;
import com.tplink.cdd.component.aaa.core.authentication.eap.annotation.Action;
import com.tplink.cdd.component.aaa.core.authentication.eap.enums.ActionCategory;
import com.tplink.cdd.component.aaa.core.authentication.eap.enums.CurrentState;
import com.tplink.cdd.component.aaa.core.authentication.eap.service.ActionBucket;
import com.tplink.cdd.component.aaa.core.authentication.utils.EapPacketUtil;
import com.tplink.cdd.component.aaa.core.authentication.utils.GetUserInfoHelper;
import com.tplink.cdd.component.aaa.server.utils.AccessRequestUtil;
import com.tplink.cdd.radius.common.eap.enums.DataType;
import com.tplink.cdd.radius.common.eap.packet.EapPacket;
import com.tplink.cdd.radius.common.eap.packet.EapResponse;
import com.tplink.cdd.radius.common.packet.request.AccessRequest;
import com.tplink.cdd.radius.common.packet.request.RadiusRequest;
import com.tplink.cdd.radius.common.utils.RadiusAttributeUtil;
import com.tplink.cdd.radius.common.utils.RandomUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class EapMd5ActionBucket
implements ActionBucket {
    private static final Logger log = LoggerFactory.getLogger(EapMd5ActionBucket.class);
    @Autowired
    private UserCache userCache;
    @Autowired
    private EapAuthHelper eapAuthHelper;
    @Autowired
    private GetUserInfoHelper getUserInfoHelper;

    @Action(value=ActionCategory.EAP_MD5_ACTION_INIT)
    public EapPacket action0(AuthReq authReq) {
        String password;
        AccessRequest accessRequest = authReq.getAccessRequest();
        String clientMac = RadiusAttributeUtil.clientMac((RadiusRequest)accessRequest);
        EapResponse eapResponse = AccessRequestUtil.findEapResponse(accessRequest);
        String username = RadiusAttributeUtil.username((RadiusRequest)accessRequest);
        try {
            password = this.getUserInfoHelper.getPassword(username, accessRequest, authReq);
        }
        catch (NoSuchElementException e) {
            return EapPacketUtil.failure(eapResponse);
        }
        byte responseId = eapResponse.getId();
        byte requestId = EapPacketUtil.computeRequestId(responseId);
        byte[] challenge = RandomUtil.randomBytes((int)16);
        byte[] checkValue = this.eapAuthHelper.computeEapMd5CheckValue(requestId, password, challenge);
        ByteBuf data = Unpooled.buffer().writeByte((int)DataType.MD5_CHALLENGE.getIndex()).writeByte(16).writeBytes(challenge);
        ByteBuf header = EapPacket.buildHeader((byte)1, (byte)requestId, (ByteBuf)data);
        UserEapCacheInfo userEapCacheInfo = authReq.getUserEapCacheInfo();
        userEapCacheInfo.setCurrentState(CurrentState.EAP_MD5_STATE_READY);
        userEapCacheInfo.setEapMd5Info(UserEapCacheInfo.EapMd5Info.builder().checkValue(checkValue).build());
        this.userCache.setUserEapCacheInfo(authReq.getNasMac(), clientMac, userEapCacheInfo);
        return EapPacketUtil.wrap(header, data);
    }

    @Action(value=ActionCategory.EAP_MD5_ACTION_PRECESS_CHALLENGE_VALUE)
    public EapPacket action1(AuthReq authReq) {
        UserEapCacheInfo userEapCacheInfo;
        UserEapCacheInfo.EapMd5Info eapMd5Info;
        byte[] checkValue;
        AccessRequest accessRequest = authReq.getAccessRequest();
        String clientMac = RadiusAttributeUtil.clientMac((RadiusRequest)accessRequest);
        EapResponse eapResponse = AccessRequestUtil.findEapResponse(accessRequest);
        ByteBuf dataValue = eapResponse.getDataValue();
        byte valueSize = dataValue.getByte(0);
        if (valueSize != 16) {
            return EapPacketUtil.failure(eapResponse);
        }
        byte[] inputEapMd5CheckValue = ByteBufUtil.getBytes((ByteBuf)dataValue, (int)1, (int)16);
        if (!Arrays.equals(inputEapMd5CheckValue, checkValue = (eapMd5Info = (userEapCacheInfo = authReq.getUserEapCacheInfo()).getEapMd5Info()).getCheckValue())) {
            return EapPacketUtil.failure(eapResponse);
        }
        userEapCacheInfo.setCurrentState(CurrentState.EAP_MD5_STATE_AUTH_SUCCESS);
        this.userCache.setUserEapCacheInfo(authReq.getNasMac(), clientMac, userEapCacheInfo);
        return EapPacketUtil.success(eapResponse);
    }
}

