/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.core.authentication.eap.enums;

import com.tplink.cdd.component.aaa.core.authentication.eap.enums.CurrentState;
import com.tplink.cdd.radius.common.eap.enums.DataType;
import com.tplink.cdd.radius.common.eap.packet.data.EapTlsPacket;
import com.tplink.cdd.radius.common.enums.AuthProtocol;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum TriggerEvent {
    IDENTITY_EVENT_INIT_EAP_MD5(DataType.IDENTITY, AuthProtocol.EAP_MD5.getIndex()),
    IDENTITY_EVENT_INIT_EAP_TLS(DataType.IDENTITY, AuthProtocol.EAP_TLS.getIndex()),
    IDENTITY_EVENT_INIT_EAP_TTLS(DataType.IDENTITY, AuthProtocol.EAP_TTLS.getIndex()),
    IDENTITY_EVENT_INIT_PEAP(DataType.IDENTITY, AuthProtocol.PEAP.getIndex()),
    NAK_EVENT_DESIRED_EAP_MD5(DataType.NAK, AuthProtocol.EAP_MD5.getIndex()),
    NAK_EVENT_DESIRED_EAP_TLS(DataType.NAK, AuthProtocol.EAP_TLS.getIndex()),
    NAK_EVENT_DESIRED_EAP_TTLS(DataType.NAK, AuthProtocol.EAP_TTLS.getIndex()),
    NAK_EVENT_DESIRED_PEAP(DataType.NAK, AuthProtocol.PEAP.getIndex()),
    EAP_MD5_EVENT_CHALLENGE_VALUE(DataType.MD5_CHALLENGE, 1),
    EAP_TLS_EVENT_CLIENT_HELLO(DataType.EAP_TLS, 1),
    EAP_TLS_EVENT_REQ_SERVER_HELLO_NEXT_FRAGMENT(DataType.EAP_TLS, 2),
    EAP_TLS_EVENT_CLIENT_KEY_FULL_PACKET(DataType.EAP_TLS, 3),
    EAP_TLS_EVENT_CLIENT_KEY_FIRST_FRAGMENT(DataType.EAP_TLS, 4),
    EAP_TLS_EVENT_CLIENT_KEY_MIDDLE_FRAGMENT(DataType.EAP_TLS, 5),
    EAP_TLS_EVENT_CLIENT_KEY_LAST_FRAGMENT(DataType.EAP_TLS, 6),
    EAP_TLS_EVENT_ACK(DataType.EAP_TLS, 7),
    EAP_TLS_EVENT_ALERT(DataType.EAP_TLS, 8),
    EAP_TTLS_EVENT_CLIENT_HELLO(DataType.EAP_TTLS, 1),
    EAP_TTLS_EVENT_REQ_SERVER_HELLO_NEXT_FRAGMENT(DataType.EAP_TTLS, 2),
    EAP_TTLS_EVENT_CLIENT_KEY_FULL_PACKET(DataType.EAP_TTLS, 3),
    EAP_TTLS_EVENT_TUNNEL_AUTHENTICATION(DataType.EAP_TTLS, 4),
    PEAP_EVENT_CLIENT_HELLO(DataType.PEAP, 1),
    PEAP_EVENT_REQ_SERVER_HELLO_NEXT_FRAGMENT(DataType.PEAP, 2),
    PEAP_EVENT_CLIENT_KEY_FULL_PACKET(DataType.PEAP, 3),
    PEAP_EVENT_ACK(DataType.PEAP, 4),
    PEAP_EVENT_TUNNEL_AUTHENTICATION(DataType.PEAP, 5);

    private static final Logger log;
    private final DataType type;
    private final Integer step;

    private TriggerEvent(DataType dataType, Integer step) {
        this.type = dataType;
        this.step = step;
    }

    public static TriggerEvent of(DataType dataType, Integer step) {
        for (TriggerEvent triggerEvent : TriggerEvent.values()) {
            if (!Objects.equals(triggerEvent.getType(), dataType) || !Objects.equals(triggerEvent.getStep(), step)) continue;
            return triggerEvent;
        }
        return null;
    }

    public static TriggerEvent fromIdentityOrNak(DataType dataType, AuthProtocol identityAuthProtocol) {
        return Arrays.stream(TriggerEvent.values()).filter(triggerEvent -> Objects.equals(dataType, triggerEvent.getType()) && Objects.equals(triggerEvent.getStep(), identityAuthProtocol.getIndex())).findFirst().orElse(null);
    }

    public static TriggerEvent fromTLS(AuthProtocol authProtocol, EapTlsPacket eapTlsPacket, CurrentState currentState) {
        if (eapTlsPacket.isClientKeyFirstFragment()) {
            return EAP_TLS_EVENT_CLIENT_KEY_FIRST_FRAGMENT;
        }
        if (eapTlsPacket.isClientKeyMiddleFragment()) {
            return EAP_TLS_EVENT_CLIENT_KEY_MIDDLE_FRAGMENT;
        }
        if (eapTlsPacket.isClientKeyLastFragment()) {
            return EAP_TLS_EVENT_CLIENT_KEY_LAST_FRAGMENT;
        }
        if (eapTlsPacket.isAlert()) {
            return EAP_TLS_EVENT_ALERT;
        }
        if (eapTlsPacket.isNoFlagsAndNoSplitFragment()) {
            if (eapTlsPacket.isApplicationData()) {
                switch (authProtocol) {
                    case EAP_TTLS: {
                        return EAP_TTLS_EVENT_TUNNEL_AUTHENTICATION;
                    }
                    case PEAP: {
                        return PEAP_EVENT_TUNNEL_AUTHENTICATION;
                    }
                }
            }
            switch (currentState) {
                case EAP_TLS_STATE_WAIT_TLS_ACK: {
                    return EAP_TLS_EVENT_ACK;
                }
                case PEAP_STATE_WAIT_TLS_ACK: {
                    return PEAP_EVENT_ACK;
                }
                case EAP_TLS_STATE_SERVER_HELLO_SEND_FRAGMENT_ING: {
                    return EAP_TLS_EVENT_REQ_SERVER_HELLO_NEXT_FRAGMENT;
                }
                case EAP_TTLS_STATE_SERVER_HELLO_SEND_FRAGMENT_ING: {
                    return EAP_TTLS_EVENT_REQ_SERVER_HELLO_NEXT_FRAGMENT;
                }
                case PEAP_STATE_SERVER_HELLO_SEND_FRAGMENT_ING: {
                    return PEAP_EVENT_REQ_SERVER_HELLO_NEXT_FRAGMENT;
                }
            }
        }
        if (eapTlsPacket.isClientHello()) {
            switch (authProtocol) {
                case EAP_TLS: {
                    return EAP_TLS_EVENT_CLIENT_HELLO;
                }
                case EAP_TTLS: {
                    return EAP_TTLS_EVENT_CLIENT_HELLO;
                }
                case PEAP: {
                    return PEAP_EVENT_CLIENT_HELLO;
                }
            }
        }
        if (eapTlsPacket.isClientKeyFullPacket()) {
            switch (authProtocol) {
                case EAP_TLS: {
                    return EAP_TLS_EVENT_CLIENT_KEY_FULL_PACKET;
                }
                case EAP_TTLS: {
                    return EAP_TTLS_EVENT_CLIENT_KEY_FULL_PACKET;
                }
                case PEAP: {
                    return PEAP_EVENT_CLIENT_KEY_FULL_PACKET;
                }
            }
        }
        if (eapTlsPacket.isApplicationData() && (Objects.equals(eapTlsPacket.getFlags(), (byte)-128) || Objects.equals(eapTlsPacket.getFlags(), (byte)0))) {
            return EAP_TTLS_EVENT_TUNNEL_AUTHENTICATION;
        }
        log.warn("Failed to parse trigger event [EAP-TLS | EAP-TTLS | PEAP], auth protocol = {}, current state = {}", (Object)authProtocol, (Object)currentState);
        return null;
    }

    public static Set<TriggerEvent> buildSet(TriggerEvent ... triggerEventList) {
        return new HashSet<TriggerEvent>(Arrays.asList(triggerEventList));
    }

    public DataType getType() {
        return this.type;
    }

    public Integer getStep() {
        return this.step;
    }

    static {
        log = LoggerFactory.getLogger(TriggerEvent.class);
    }
}

